/*
 * Decompiled with CFR 0.152.
 */
package dev.latvian.mods.kubejs.bindings;

import dev.latvian.mods.kubejs.item.ingredient.IngredientWithCustomPredicate;
import dev.latvian.mods.kubejs.platform.IngredientPlatformHelper;
import dev.latvian.mods.kubejs.recipe.RecipesEventJS;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientAction;
import dev.latvian.mods.kubejs.recipe.ingredientaction.CustomIngredientActionCallback;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.Nullable;

public interface IngredientWrapper {
    public static final Ingredient none = Ingredient.f_43901_;
    public static final Ingredient all = IngredientPlatformHelper.get().wildcard();

    public static Ingredient of(Ingredient ingredient) {
        return ingredient;
    }

    public static Ingredient of(Ingredient ingredient, int count) {
        return ingredient.kjs$withCount(count);
    }

    public static Ingredient custom(Ingredient parent, Predicate<ItemStack> predicate) {
        if (RecipesEventJS.customIngredientMap != null) {
            IngredientWithCustomPredicate ingredient = new IngredientWithCustomPredicate(parent, UUID.randomUUID(), predicate);
            RecipesEventJS.customIngredientMap.put(ingredient.uuid, ingredient);
            return IngredientPlatformHelper.get().custom(parent, ingredient.uuid);
        }
        return IngredientPlatformHelper.get().custom(parent, predicate);
    }

    public static Ingredient custom(Predicate<ItemStack> predicate) {
        return IngredientWrapper.custom(all, predicate);
    }

    public static Ingredient customNBT(Ingredient in, Predicate<CompoundTag> predicate) {
        return IngredientWrapper.custom(in, is -> is.m_41782_() && predicate.test(is.m_41783_()));
    }

    public static void registerCustomIngredientAction(String id, CustomIngredientActionCallback callback) {
        CustomIngredientAction.MAP.put(id, callback);
    }

    public static boolean isIngredient(@Nullable Object o) {
        return o instanceof Ingredient;
    }
}

