/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.shynieke.statues.items.StatueBlockItem;
import com.shynieke.statues.recipe.StatuesRecipes;
import com.shynieke.statues.recipe.UpgradeType;
import com.shynieke.statues.registry.StatueTags;
import com.shynieke.statues.util.UpgradeHelper;
import java.util.ArrayList;
import java.util.Locale;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import org.jetbrains.annotations.Nullable;

public class UpgradeRecipe
implements Recipe<Container> {
    protected final ResourceLocation id;
    protected final String group;
    protected final Ingredient center;
    protected final NonNullList<Ingredient> catalysts;
    protected final ItemStack result;
    protected final boolean requireCore;
    private final UpgradeType upgradeType;
    private final int tier;

    public UpgradeRecipe(ResourceLocation id, String group, Ingredient center, NonNullList<Ingredient> catalysts, ItemStack stack, boolean requireCore, UpgradeType upgradeType, int tier) {
        this.id = id;
        this.group = group;
        this.center = center;
        this.catalysts = catalysts;
        this.result = stack;
        this.requireCore = requireCore;
        this.upgradeType = upgradeType;
        this.tier = tier;
    }

    public NonNullList<Ingredient> m_7527_() {
        NonNullList nonnulllist = NonNullList.m_122779_();
        nonnulllist.add((Object)this.center);
        if (this.requireCore) {
            nonnulllist.add((Object)Ingredient.m_204132_(StatueTags.STATUE_CORE));
        }
        nonnulllist.addAll(this.catalysts);
        return nonnulllist;
    }

    public Ingredient getCenter() {
        return this.center;
    }

    public NonNullList<Ingredient> getCatalysts() {
        return this.catalysts;
    }

    public boolean requiresCore() {
        return this.requireCore;
    }

    public int getTier() {
        return this.tier;
    }

    public UpgradeType getUpgradeType() {
        return this.upgradeType;
    }

    public boolean m_5818_(Container container, Level level) {
        ItemStack coreStack;
        ItemStack statueStack = container.m_8020_(0);
        if (!this.center.test(statueStack)) {
            return false;
        }
        if (statueStack.m_41720_() instanceof StatueBlockItem) {
            CompoundTag compoundtag = statueStack.m_41737_("BlockEntityTag");
            if (this.upgradeType.requiresUpgrade() ? compoundtag == null || !compoundtag.m_128441_("statueUpgraded") || compoundtag.m_128451_("upgradeSlots") < 1 : this.upgradeType == UpgradeType.UPGRADE && compoundtag != null && compoundtag.m_128441_("statueUpgraded")) {
                return false;
            }
            if (this.tier != -1 && this.tier != UpgradeHelper.getUpgradeLevel(statueStack, this.upgradeType.name().toLowerCase(Locale.ROOT))) {
                return false;
            }
        }
        if (this.requireCore && !(coreStack = container.m_8020_(1)).m_204117_(StatueTags.STATUE_CORE)) {
            return false;
        }
        if (this.catalysts.isEmpty()) {
            for (int j = 2; j < 6; ++j) {
                ItemStack itemstack = container.m_8020_(j);
                if (itemstack.m_41619_()) continue;
                return false;
            }
            return true;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        int itemCount = 0;
        for (int j = 2; j < 6; ++j) {
            ItemStack itemstack = container.m_8020_(j);
            if (itemstack.m_41619_()) continue;
            ++itemCount;
            inputs.add(itemstack);
        }
        return itemCount == this.catalysts.size() && RecipeMatcher.findMatches(inputs, this.catalysts) != null;
    }

    public ItemStack m_5874_(Container container) {
        return this.m_8043_().m_41777_();
    }

    public boolean m_8004_(int x, int y) {
        return false;
    }

    public boolean m_5598_() {
        return true;
    }

    public ItemStack m_8043_() {
        return this.result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return (RecipeSerializer)StatuesRecipes.UPGRADE_SERIALIZER.get();
    }

    public RecipeType<?> m_6671_() {
        return (RecipeType)StatuesRecipes.UPGRADE_RECIPE.get();
    }

    public static class Serializer
    implements RecipeSerializer<UpgradeRecipe> {
        public UpgradeRecipe fromJson(ResourceLocation recipeID, JsonObject jsonObject) {
            ItemStack resultStack;
            String s = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            JsonArray jsonelement = GsonHelper.m_13885_((JsonObject)jsonObject, (String)"center") ? GsonHelper.m_13933_((JsonObject)jsonObject, (String)"center") : GsonHelper.m_13930_((JsonObject)jsonObject, (String)"center");
            Ingredient center = Ingredient.m_43917_((JsonElement)jsonelement);
            NonNullList<Ingredient> catalystList = Serializer.itemsFromJson(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"catalysts"));
            String type = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"upgradeType", (String)"crafting");
            UpgradeType upgradeType = UpgradeType.valueOf(type.toUpperCase());
            if (catalystList.isEmpty() && upgradeType != UpgradeType.UPGRADE) {
                throw new JsonParseException("No catalysts for upgrade recipe");
            }
            if (catalystList.size() > 4) {
                throw new JsonParseException("Too many catalysts for upgrade recipe. The maximum is 4");
            }
            if (jsonObject.has("result")) {
                if (jsonObject.get("result").isJsonObject()) {
                    resultStack = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
                } else {
                    String s1 = GsonHelper.m_13906_((JsonObject)jsonObject, (String)"result");
                    ResourceLocation resourcelocation = new ResourceLocation(s1);
                    resultStack = new ItemStack((ItemLike)Registry.f_122827_.m_6612_(resourcelocation).orElseThrow(() -> new IllegalStateException("Item: " + s1 + " does not exist")));
                }
            } else {
                resultStack = ItemStack.f_41583_;
            }
            boolean requireCore = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"requireCore", (boolean)false);
            int tier = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"tier", (int)-1);
            return new UpgradeRecipe(recipeID, s, center, catalystList, resultStack, requireCore, upgradeType, tier);
        }

        private static NonNullList<Ingredient> itemsFromJson(JsonArray jsonArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < jsonArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_43917_((JsonElement)jsonArray.get(i));
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        @Nullable
        public UpgradeRecipe fromNetwork(ResourceLocation recipeID, FriendlyByteBuf byteBuf) {
            String s = byteBuf.m_130136_(Short.MAX_VALUE);
            Ingredient center = Ingredient.m_43940_((FriendlyByteBuf)byteBuf);
            int i = byteBuf.m_130242_();
            NonNullList catalist = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < catalist.size(); ++j) {
                catalist.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)byteBuf));
            }
            ItemStack result = byteBuf.m_130267_();
            boolean requireCore = byteBuf.readBoolean();
            int type = byteBuf.m_130242_();
            UpgradeType upgradeType = UpgradeType.values()[type];
            int tier = byteBuf.m_130242_();
            return new UpgradeRecipe(recipeID, s, center, (NonNullList<Ingredient>)catalist, result, requireCore, upgradeType, tier);
        }

        public void toNetwork(FriendlyByteBuf byteBuf, UpgradeRecipe recipe) {
            byteBuf.m_130070_(recipe.group);
            recipe.center.m_43923_(byteBuf);
            byteBuf.m_130130_(recipe.catalysts.size());
            for (Ingredient ingredient : recipe.catalysts) {
                ingredient.m_43923_(byteBuf);
            }
            byteBuf.m_130055_(recipe.result);
            byteBuf.writeBoolean(recipe.requireCore);
            byteBuf.m_130130_(recipe.upgradeType.ordinal());
            byteBuf.m_130130_(recipe.tier);
        }
    }
}

