/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.handlers;

import com.shynieke.statues.blocks.AbstractStatueBase;
import com.shynieke.statues.blocks.statues.SheepStatueBlock;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.registry.StatueRegistry;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.animal.Bee;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.CatVariant;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Panda;
import net.minecraft.world.entity.animal.Rabbit;
import net.minecraft.world.entity.animal.Sheep;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.ElderGuardian;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.registries.RegistryObject;

public class DropHandler {
    private static final Random rand = new Random();

    @SubscribeEvent
    public void onLivingDrop(LivingDropsEvent event) {
        LivingEntity entity = event.getEntity();
        Entity source = event.getSource().m_7639_();
        if (entity instanceof Villager) {
            switch (entity.f_19853_.f_46441_.m_188503_(4)) {
                default: {
                    this.dropLootStatues((Entity)entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_BR_STATUE.get()), source, event);
                    break;
                }
                case 1: {
                    this.dropLootStatues((Entity)entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_WH_STATUE.get()), source, event);
                    break;
                }
                case 2: {
                    this.dropLootStatues((Entity)entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_PU_STATUE.get()), source, event);
                    break;
                }
                case 3: {
                    this.dropLootStatues((Entity)entity, new ItemStack((ItemLike)StatueRegistry.VILLAGER_GR_STATUE.get()), source, event);
                    break;
                }
            }
        } else if (entity instanceof Evoker) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.EVOKER_STATUE.get());
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Vindicator) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.VINDICATOR_STATUE.get());
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Sheep) {
            Sheep sheep = (Sheep)entity;
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.SHEEP_SHAVEN_STATUE.get());
            if (!sheep.m_29875_()) {
                itemStackToDrop = new ItemStack((ItemLike)SheepStatueBlock.getStatue(sheep.m_29874_()));
            }
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Bee) {
            Bee bee = (Bee)entity;
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BEE_STATUE.get());
            if (entity.f_19853_.f_46441_.m_188499_()) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.ANGRY_BEE_STATUE.get());
            }
            String trans = "Trans Bee";
            if (bee.m_5446_().getString().equalsIgnoreCase(trans)) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BEE_STATUE.get());
                itemStackToDrop.m_41714_((Component)Component.m_237113_((String)trans));
            }
            String tropi = "Tropibee";
            if (bee.m_5446_().getString().equalsIgnoreCase(trans)) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BEE_STATUE.get());
                itemStackToDrop.m_41714_((Component)Component.m_237113_((String)tropi));
            }
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Rabbit) {
            Rabbit rabbit = (Rabbit)entity;
            new ItemStack((ItemLike)StatueRegistry.RABBIT_BR_STATUE.get());
            itemStackToDrop = switch (rabbit.m_29719_()) {
                case 1 -> new ItemStack((ItemLike)StatueRegistry.RABBIT_WH_STATUE.get());
                case 2 -> new ItemStack((ItemLike)StatueRegistry.RABBIT_WS_STATUE.get());
                case 3 -> new ItemStack((ItemLike)StatueRegistry.RABBIT_BS_STATUE.get());
                case 4 -> new ItemStack((ItemLike)StatueRegistry.RABBIT_GO_STATUE.get());
                case 5 -> new ItemStack((ItemLike)StatueRegistry.RABBIT_BW_STATUE.get());
                default -> new ItemStack((ItemLike)StatueRegistry.RABBIT_BR_STATUE.get());
            };
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Panda) {
            Panda panda = (Panda)entity;
            new ItemStack((ItemLike)StatueRegistry.PANDA_NORMAL_STATUE.get());
            itemStackToDrop = switch (panda.m_29154_()) {
                case Panda.Gene.AGGRESSIVE -> new ItemStack((ItemLike)StatueRegistry.PANDA_ANGRY_STATUE.get());
                case Panda.Gene.BROWN -> new ItemStack((ItemLike)StatueRegistry.PANDA_BROWN_STATUE.get());
                case Panda.Gene.LAZY -> new ItemStack((ItemLike)StatueRegistry.PANDA_LAZY_STATUE.get());
                case Panda.Gene.PLAYFUL -> new ItemStack((ItemLike)StatueRegistry.PANDA_PLAYFUL_STATUE.get());
                case Panda.Gene.WEAK -> new ItemStack((ItemLike)StatueRegistry.PANDA_WEAK_STATUE.get());
                case Panda.Gene.WORRIED -> new ItemStack((ItemLike)StatueRegistry.PANDA_WORRIED_STATUE.get());
                default -> new ItemStack((ItemLike)StatueRegistry.PANDA_NORMAL_STATUE.get());
            };
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Cat) {
            Cat cat = (Cat)entity;
            itemStackToDrop = ItemStack.f_41583_;
            CatVariant variant = cat.m_218139_();
            itemStackToDrop = variant == CatVariant.f_218140_ ? new ItemStack((ItemLike)StatueRegistry.CAT_TABBY_STATUE.get()) : (variant == CatVariant.f_218141_ ? new ItemStack((ItemLike)StatueRegistry.CAT_TUXEDO_STATUE.get()) : (variant == CatVariant.f_218142_ ? new ItemStack((ItemLike)StatueRegistry.CAT_RED_STATUE.get()) : (variant == CatVariant.f_218143_ ? new ItemStack((ItemLike)StatueRegistry.CAT_SIAMESE_STATUE.get()) : (variant == CatVariant.f_218144_ ? new ItemStack((ItemLike)StatueRegistry.CAT_BRITISH_SHORTHAIR_STATUE.get()) : (variant == CatVariant.f_218145_ ? new ItemStack((ItemLike)StatueRegistry.CAT_CALICO_STATUE.get()) : (variant == CatVariant.f_218146_ ? new ItemStack((ItemLike)StatueRegistry.CAT_PERSIAN_STATUE.get()) : (variant == CatVariant.f_218147_ ? new ItemStack((ItemLike)StatueRegistry.CAT_RAGDOLL_STATUE.get()) : (variant == CatVariant.f_218148_ ? new ItemStack((ItemLike)StatueRegistry.CAT_WHITE_STATUE.get()) : (variant == CatVariant.f_218149_ ? new ItemStack((ItemLike)StatueRegistry.CAT_JELLIE_STATUE.get()) : (variant == CatVariant.f_218150_ ? new ItemStack((ItemLike)StatueRegistry.CAT_BLACK_STATUE.get()) : new ItemStack((ItemLike)StatueRegistry.CAT_TABBY_STATUE.get())))))))))));
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof ElderGuardian) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.ELDER_GUARDIAN_STATUE.get());
            this.dropBossStatue((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Ravager) {
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.RAVAGER_STATUE.get());
            if (rand.nextFloat() <= 0.25f) {
                this.dropBossStatue((Entity)entity, itemStackToDrop, source, event);
            }
        } else if (entity instanceof MushroomCow) {
            MushroomCow mooshroom = (MushroomCow)entity;
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.MOOSHROOM_STATUE.get());
            if (mooshroom.m_28955_() == MushroomCow.MushroomType.BROWN) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.BROWN_MOOSHROOM_STATUE.get());
            }
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else if (entity instanceof Fox) {
            Fox fox = (Fox)entity;
            itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.FOX_STATUE.get());
            if (fox.m_28554_() == Fox.Type.SNOW) {
                itemStackToDrop = new ItemStack((ItemLike)StatueRegistry.FOX_SNOW_STATUE.get());
            }
            this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
        } else {
            ArrayList<RegistryObject> matchingStatues = new ArrayList<RegistryObject>();
            for (RegistryObject block : StatueRegistry.BLOCKS.getEntries()) {
                AbstractStatueBase statue;
                Object object = block.get();
                if (!(object instanceof AbstractStatueBase) || !(statue = (AbstractStatueBase)((Object)object)).getEntity().equals((Object)entity.m_6095_()) || statue.isHiddenStatue()) continue;
                matchingStatues.add(block);
            }
            if (!matchingStatues.isEmpty()) {
                RegistryObject block = (RegistryObject)matchingStatues.get(rand.nextInt(matchingStatues.size()));
                AbstractStatueBase statue = (AbstractStatueBase)((Object)block.get());
                ItemStack itemStackToDrop = new ItemStack((ItemLike)statue);
                if (entity instanceof Mob) {
                    if (((Mob)entity).m_6162_() == statue.isBaby()) {
                        this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
                    }
                } else {
                    this.dropLootStatues((Entity)entity, itemStackToDrop, source, event);
                }
            }
        }
        if (((Boolean)StatuesConfig.COMMON.playerDropsStatue.get()).booleanValue() && entity instanceof Player) {
            Player player = (Player)entity;
            ItemStack playerStatueStack = new ItemStack((ItemLike)StatueRegistry.PLAYER_STATUE.get()).m_41714_(player.m_7755_());
            double random_drop = Math.random();
            double playerDropChance = (Double)StatuesConfig.COMMON.playerStatueDropChance.get();
            BlockPos entityPos = entity.m_20183_();
            switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.playerStatueKillSource.get())) {
                default: {
                    if (!(source instanceof ServerPlayer)) break;
                    ServerPlayer sourcePlayer = (ServerPlayer)source;
                    if (source instanceof FakePlayer) break;
                    List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                    if (!luckyPlayers.isEmpty()) {
                        for (String luckyName : luckyPlayers) {
                            String user = sourcePlayer.m_7755_().getString();
                            if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                            playerDropChance = (Double)StatuesConfig.COMMON.playerStatueDropChance.get() / 4.0;
                        }
                    }
                    if (!(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), playerStatueStack));
                    break;
                }
                case PLAYER_FAKEPLAYER: {
                    if (!(source instanceof ServerPlayer) || !(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), playerStatueStack));
                    break;
                }
                case ALL: {
                    if (!(random_drop <= playerDropChance)) break;
                    event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), playerStatueStack));
                }
            }
        }
    }

    public void dropBossStatue(Entity entity, ItemStack itemStackToDrop, Entity source, LivingDropsEvent event) {
        BlockPos entityPos = entity.m_20183_();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                if (!(source instanceof ServerPlayer) || source instanceof FakePlayer) break;
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof ServerPlayer)) break;
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
                break;
            }
            case ALL: {
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
            }
        }
    }

    public void dropLootStatues(Entity entity, ItemStack itemStackToDrop, Entity source, LivingDropsEvent event) {
        double random_drop = Math.random();
        double default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get();
        BlockPos entityPos = entity.m_20183_();
        switch ((StatuesConfig.EnumDeathSource)((Object)StatuesConfig.COMMON.statueKillSource.get())) {
            default: {
                if (!(source instanceof ServerPlayer)) break;
                ServerPlayer player = (ServerPlayer)source;
                if (source instanceof FakePlayer) break;
                List luckyPlayers = (List)StatuesConfig.COMMON.lucky_players.get();
                if (!luckyPlayers.isEmpty()) {
                    for (String luckyName : luckyPlayers) {
                        String user = player.m_7755_().getString();
                        if (luckyName.isEmpty() || !user.equals(luckyName)) continue;
                        default_drop_chance = (Double)StatuesConfig.COMMON.statueDropChance.get() / 4.0;
                    }
                }
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
                break;
            }
            case PLAYER_FAKEPLAYER: {
                if (!(source instanceof ServerPlayer) || !(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
                break;
            }
            case ALL: {
                if (!(random_drop <= default_drop_chance)) break;
                event.getDrops().add(new ItemEntity(entity.f_19853_, (double)entityPos.m_123341_(), (double)entityPos.m_123342_(), (double)entityPos.m_123343_(), itemStackToDrop));
            }
        }
    }
}

