/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.datagen.client;

import com.shynieke.statues.items.PlayerCompassItem;
import com.shynieke.statues.registry.StatueRegistry;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class StatueItemModelProvider
extends ItemModelProvider {
    public StatueItemModelProvider(DataGenerator gen, ExistingFileHelper helper) {
        super(gen, "statues", helper);
    }

    protected void registerModels() {
        for (RegistryObject registryObject : StatueRegistry.ITEMS.getEntries()) {
            if (registryObject.get() instanceof BlockItem) {
                this.withBlockParent(registryObject.getId());
                continue;
            }
            if (registryObject.get() instanceof PlayerCompassItem) {
                this.generateStatueCompass(registryObject.getId(), this.mcLoc("item/compass_16"));
                continue;
            }
            if (registryObject.get() instanceof SpawnEggItem) {
                this.withExistingParent(registryObject.getId().m_135815_(), new ResourceLocation("item/template_spawn_egg"));
                continue;
            }
            this.generatedItem(registryObject.getId());
        }
    }

    private void withBlockParent(ResourceLocation location) {
        this.withExistingParent(location.m_135815_(), this.modLoc("block/" + location.m_135815_()));
    }

    private void generatedItem(ResourceLocation location) {
        this.singleTexture(location.m_135815_(), new ResourceLocation("item/generated"), "layer0", new ResourceLocation("statues", "item/" + location.m_135815_()));
    }

    private void generateStatueCompass(ResourceLocation location, ResourceLocation textureLocation) {
        ResourceLocation angle = new ResourceLocation("angle");
        ((ItemModelBuilder)this.singleTexture(location.m_135815_(), new ResourceLocation("item/generated"), "layer0", textureLocation)).override().predicate(angle, 0.0f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass"), this.existingFileHelper)).end().override().predicate(angle, 0.015625f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_17"), this.existingFileHelper)).end().override().predicate(angle, 0.046875f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_18"), this.existingFileHelper)).end().override().predicate(angle, 0.078125f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_19"), this.existingFileHelper)).end().override().predicate(angle, 0.109375f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_20"), this.existingFileHelper)).end().override().predicate(angle, 0.140625f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_21"), this.existingFileHelper)).end().override().predicate(angle, 0.171875f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_22"), this.existingFileHelper)).end().override().predicate(angle, 0.203125f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_23"), this.existingFileHelper)).end().override().predicate(angle, 0.234375f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_24"), this.existingFileHelper)).end().override().predicate(angle, 0.265625f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_25"), this.existingFileHelper)).end().override().predicate(angle, 0.296875f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_26"), this.existingFileHelper)).end().override().predicate(angle, 0.328125f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_27"), this.existingFileHelper)).end().override().predicate(angle, 0.359375f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_28"), this.existingFileHelper)).end().override().predicate(angle, 0.390625f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_29"), this.existingFileHelper)).end().override().predicate(angle, 0.421875f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_30"), this.existingFileHelper)).end().override().predicate(angle, 0.453125f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_31"), this.existingFileHelper)).end().override().predicate(angle, 0.484375f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_00"), this.existingFileHelper)).end().override().predicate(angle, 0.515625f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_01"), this.existingFileHelper)).end().override().predicate(angle, 0.546875f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_02"), this.existingFileHelper)).end().override().predicate(angle, 0.578125f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_03"), this.existingFileHelper)).end().override().predicate(angle, 0.609375f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_04"), this.existingFileHelper)).end().override().predicate(angle, 0.640625f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_05"), this.existingFileHelper)).end().override().predicate(angle, 0.671875f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_06"), this.existingFileHelper)).end().override().predicate(angle, 0.703125f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_07"), this.existingFileHelper)).end().override().predicate(angle, 0.734375f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_08"), this.existingFileHelper)).end().override().predicate(angle, 0.765625f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_09"), this.existingFileHelper)).end().override().predicate(angle, 0.796875f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_10"), this.existingFileHelper)).end().override().predicate(angle, 0.828125f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_11"), this.existingFileHelper)).end().override().predicate(angle, 0.859375f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_12"), this.existingFileHelper)).end().override().predicate(angle, 0.890625f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_13"), this.existingFileHelper)).end().override().predicate(angle, 0.921875f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_14"), this.existingFileHelper)).end().override().predicate(angle, 0.953125f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass_15"), this.existingFileHelper)).end().override().predicate(angle, 0.984375f).model((ModelFile)new ItemModelBuilder(new ResourceLocation("item/compass"), this.existingFileHelper)).end();
    }
}

