/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.screen;

import com.mojang.blaze3d.vertex.PoseStack;
import com.shynieke.statues.client.screen.PlayerStatueData;
import com.shynieke.statues.client.screen.widget.DecimalNumberFieldBox;
import com.shynieke.statues.client.screen.widget.EnumCycleButton;
import com.shynieke.statues.client.screen.widget.NumberFieldBox;
import com.shynieke.statues.client.screen.widget.ToggleButton;
import com.shynieke.statues.config.StatuesConfig;
import com.shynieke.statues.entity.PlayerStatue;
import com.shynieke.statues.network.StatuesNetworking;
import com.shynieke.statues.network.message.PlayerStatueSyncMessage;
import java.util.Objects;
import net.minecraft.client.GameNarrator;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.FloatTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.PacketDistributor;

@OnlyIn(value=Dist.CLIENT)
public class PlayerPoseScreen
extends Screen {
    private final PlayerStatue playerStatueEntity;
    private final PlayerStatueData playerStatueData;
    private final String[] buttonLabels = new String[]{"small", "rotation", "y_offset", "locked", "name_visible", "gravity", "model_type"};
    private final String[] sliderLabels = new String[]{"head", "body", "left_leg", "right_leg", "left_arm", "right_arm", "position"};
    private NumberFieldBox rotationTextField;
    private DecimalNumberFieldBox YOffsetTextField;
    private ToggleButton smallButton;
    private ToggleButton lockButton;
    private ToggleButton nameVisibleButton;
    private ToggleButton noGravityButton;
    private EnumCycleButton forceModelType;
    private final NumberFieldBox[] poseTextFields = new NumberFieldBox[21];
    private final boolean allowScrolling;
    private Vec3 lastSendOffset = new Vec3(0.0, 0.0, 0.0);

    public PlayerPoseScreen(PlayerStatue playerStatue) {
        super(GameNarrator.f_93310_);
        int i;
        this.playerStatueEntity = playerStatue;
        this.playerStatueData = new PlayerStatueData();
        this.playerStatueData.readFromNBT(this.playerStatueEntity.m_20240_(new CompoundTag()));
        this.allowScrolling = (Boolean)StatuesConfig.CLIENT.allowScrolling.get();
        for (i = 0; i < this.buttonLabels.length; ++i) {
            this.buttonLabels[i] = I18n.m_118938_((String)String.format("%s.playerstatue.gui.label." + this.buttonLabels[i], "statues"), (Object[])new Object[0]);
        }
        for (i = 0; i < this.sliderLabels.length; ++i) {
            this.sliderLabels[i] = I18n.m_118938_((String)String.format("%s.playerstatue.gui.label." + this.sliderLabels[i], "statues"), (Object[])new Object[0]);
        }
    }

    public static void openScreen(PlayerStatue playerStatue) {
        Minecraft.m_91087_().m_91152_((Screen)new PlayerPoseScreen(playerStatue));
    }

    protected void m_7856_() {
        super.m_7856_();
        int offsetX = 110;
        int offsetY = 50;
        int rowOffset = 22;
        this.smallButton = new ToggleButton(offsetX, offsetY, 40, 20, this.playerStatueData.isSmall(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        });
        this.m_142416_((GuiEventListener)this.smallButton);
        this.rotationTextField = new NumberFieldBox(this.f_96547_, 1 + offsetX, 1 + offsetY + rowOffset, 38, 17, (Component)Component.m_237115_((String)"statues.playerstatue.gui.label.rotation"));
        this.rotationTextField.m_94144_(String.valueOf((int)this.playerStatueData.rotation));
        this.rotationTextField.m_94199_(4);
        this.m_7787_((GuiEventListener)this.rotationTextField);
        this.YOffsetTextField = new DecimalNumberFieldBox(this.f_96547_, 1 + offsetX, 1 + offsetY + rowOffset * 2, 38, 17, (Component)Component.m_237115_((String)"statues.playerstatue.gui.label.y_offset"));
        this.YOffsetTextField.m_94144_(String.valueOf(Mth.m_14036_((float)this.playerStatueData.yOffset, (float)-1.0f, (float)1.0f)));
        this.YOffsetTextField.m_94199_(5);
        this.m_7787_((GuiEventListener)this.YOffsetTextField);
        this.lockButton = (ToggleButton)this.m_142416_((GuiEventListener)new ToggleButton(offsetX, offsetY + rowOffset * 3, 40, 20, this.playerStatueData.isLocked(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        }));
        this.m_142416_((GuiEventListener)this.lockButton);
        this.nameVisibleButton = new ToggleButton(offsetX, offsetY + rowOffset * 4, 40, 20, this.playerStatueData.getNameVisible(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        });
        this.m_142416_((GuiEventListener)this.nameVisibleButton);
        this.noGravityButton = new ToggleButton(offsetX, offsetY + rowOffset * 5, 40, 20, this.playerStatueData.hasNoGravity(), button -> {
            ToggleButton toggleButton;
            toggleButton.setValue(!(toggleButton = (ToggleButton)button).getValue());
            this.textFieldUpdated();
        });
        this.m_142416_((GuiEventListener)this.noGravityButton);
        this.forceModelType = new EnumCycleButton(offsetX, offsetY + rowOffset * 6, 40, 20, "modeltype", this.playerStatueData.modelType, (Enum[])PlayerStatueData.MODEL_TYPE.values(), button -> {
            EnumCycleButton optionCycleButton = (EnumCycleButton)button;
            optionCycleButton.cycleValue();
            this.textFieldUpdated();
        });
        this.m_142416_((GuiEventListener)this.forceModelType);
        offsetX = this.f_96543_ - 20 - 100;
        for (int i = 0; i < this.poseTextFields.length; ++i) {
            int x = 1 + offsetX + i % 3 * 35;
            int y = 1 + offsetY + i / 3 * 22;
            int width = 28;
            int height = 17;
            String value = String.valueOf((int)this.playerStatueData.pose[i]);
            this.poseTextFields[i] = new NumberFieldBox(this.f_96547_, x, y, width, height, (Component)Component.m_237110_((String)"statues.playerstatue.gui.label.field.%s", (Object[])new Object[]{i}));
            this.poseTextFields[i].m_94144_(value);
            this.poseTextFields[i].m_94199_(4);
            if (i >= 18 && i < 21) {
                this.poseTextFields[i].scrollMultiplier = 0.01f;
                this.poseTextFields[i].modValue = 2.1474836E9f;
                this.poseTextFields[i].decimalPoints = 2;
                this.poseTextFields[i].m_94199_(6);
            }
            this.m_7787_((GuiEventListener)this.poseTextFields[i]);
        }
        offsetX = 20;
        offsetY = this.f_96544_ / 4 + 134 + 12;
        this.m_142416_((GuiEventListener)new Button(offsetX, offsetY, 64, 20, (Component)Component.m_237115_((String)"statues.playerstatue.gui.label.copy"), button -> {
            CompoundTag compound = this.writeFieldsToNBT();
            String clipboardData = compound.toString();
            if (this.f_96541_ != null) {
                this.f_96541_.f_91068_.m_90911_(clipboardData);
            }
        }));
        this.m_142416_((GuiEventListener)new Button(offsetX + 66, offsetY, 64, 20, (Component)Component.m_237115_((String)"statues.playerstatue.gui.label.paste"), button -> {
            try {
                String clipboardData = null;
                if (this.f_96541_ != null) {
                    clipboardData = this.f_96541_.f_91068_.m_90876_();
                }
                CompoundTag compound = TagParser.m_129359_(clipboardData);
                this.readFieldsFromNBT(compound);
                this.updateEntity(compound);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }));
        offsetX = this.f_96543_ - 20;
        this.m_142416_((GuiEventListener)new Button(offsetX - 194, offsetY, 96, 20, (Component)Component.m_237115_((String)"gui.done"), button -> {
            this.updateEntity(this.writeFieldsToNBT());
            this.f_96541_.m_91152_((Screen)null);
        }));
        this.m_142416_((GuiEventListener)new Button(offsetX - 96, offsetY, 96, 20, (Component)Component.m_237115_((String)"gui.cancel"), button -> {
            this.poseTextFields[18].m_94144_("0");
            this.poseTextFields[19].m_94144_("0");
            this.poseTextFields[20].m_94144_("0");
            this.textFieldUpdated();
            this.updateEntity(this.playerStatueData.writeToNBT());
            this.f_96541_.m_91152_((Screen)null);
        }));
    }

    public void m_7379_() {
        super.m_7379_();
        this.playerStatueEntity.clientLock = 0;
    }

    public void m_6305_(PoseStack poseStack, int mouseX, int mouseY, float partialTicks) {
        int y;
        int i;
        this.m_7333_(poseStack);
        PlayerPoseScreen.m_93208_((PoseStack)poseStack, (Font)this.f_96547_, (String)I18n.m_118938_((String)String.format("%s.playerstatue.gui.title", "statues"), (Object[])new Object[0]), (int)(this.f_96543_ / 2), (int)20, (int)0xFFFFFF);
        this.rotationTextField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        this.YOffsetTextField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        for (NumberFieldBox textField : this.poseTextFields) {
            if (textField == null) continue;
            textField.m_6305_(poseStack, mouseX, mouseY, partialTicks);
        }
        int offsetY = 50;
        int offsetX = 20;
        for (i = 0; i < this.buttonLabels.length; ++i) {
            int x = offsetX;
            Objects.requireNonNull(this.f_96547_);
            y = offsetY + i * 22 + (11 - 9 / 2);
            PlayerPoseScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.buttonLabels[i], (int)x, (int)y, (int)0xA0A0A0);
        }
        offsetX = this.f_96543_ - 20 - 100;
        PlayerPoseScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"X", (int)offsetX, (int)37, (int)0xA0A0A0);
        PlayerPoseScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Y", (int)(offsetX + 35), (int)37, (int)0xA0A0A0);
        PlayerPoseScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)"Z", (int)(offsetX + 70), (int)37, (int)0xA0A0A0);
        for (i = 0; i < this.sliderLabels.length; ++i) {
            int x = offsetX - this.f_96547_.m_92895_(this.sliderLabels[i]) - 10;
            Objects.requireNonNull(this.f_96547_);
            y = offsetY + i * 22 + (10 - 9 / 2);
            PlayerPoseScreen.m_93236_((PoseStack)poseStack, (Font)this.f_96547_, (String)this.sliderLabels[i], (int)x, (int)y, (int)0xA0A0A0);
        }
        super.m_6305_(poseStack, mouseX, mouseY, partialTicks);
    }

    public void m_86600_() {
        super.m_86600_();
        this.playerStatueEntity.clientLock = 5;
        this.rotationTextField.m_94120_();
        this.YOffsetTextField.m_94120_();
        for (NumberFieldBox textField : this.poseTextFields) {
            if (textField == null) continue;
            textField.m_94120_();
        }
    }

    public boolean m_5534_(char codePoint, int modifiers) {
        boolean typed = super.m_5534_(codePoint, modifiers);
        if (typed) {
            this.textFieldUpdated();
        }
        return typed;
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        block5: {
            float multiplier;
            block4: {
                float f = multiplier = Screen.m_96638_() ? 10.0f : 1.0f;
                if (!this.allowScrolling || !(delta > 0.0)) break block4;
                if (this.rotationTextField.m_93696_()) {
                    float nextValue = (this.rotationTextField.getFloat() + multiplier * this.rotationTextField.scrollMultiplier) % this.rotationTextField.modValue;
                    this.rotationTextField.m_94144_(String.valueOf(nextValue));
                    this.rotationTextField.m_94196_(0);
                    this.rotationTextField.m_94208_(0);
                    this.textFieldUpdated();
                    return true;
                }
                for (NumberFieldBox textField : this.poseTextFields) {
                    if (!textField.m_198029_()) continue;
                    float nextValue = (textField.getFloat() + multiplier * textField.scrollMultiplier) % textField.modValue;
                    textField.m_94144_(String.valueOf(nextValue));
                    textField.m_94196_(0);
                    textField.m_94208_(0);
                    this.textFieldUpdated();
                    return true;
                }
                break block5;
            }
            if (!this.allowScrolling || !(delta < 0.0)) break block5;
            if (this.rotationTextField.m_93696_()) {
                float previousValue = (this.rotationTextField.getFloat() - multiplier * this.rotationTextField.scrollMultiplier) % this.rotationTextField.modValue;
                this.rotationTextField.m_94144_(String.valueOf(previousValue));
                this.rotationTextField.m_94196_(0);
                this.rotationTextField.m_94208_(0);
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.m_198029_()) continue;
                float previousValue = (textField.getFloat() - multiplier * textField.scrollMultiplier) % textField.modValue;
                textField.m_94144_(String.valueOf(previousValue));
                textField.m_94196_(0);
                textField.m_94208_(0);
                this.textFieldUpdated();
                return true;
            }
        }
        return super.m_6050_(mouseX, mouseY, delta);
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 15) {
            for (int i = 0; i < this.poseTextFields.length; ++i) {
                if (!this.poseTextFields[i].m_93696_()) continue;
                this.textFieldUpdated();
                this.poseTextFields[i].m_94201_();
                this.poseTextFields[i].m_93692_(false);
                int j = !Screen.m_96638_() ? (i == this.poseTextFields.length - 1 ? 0 : i + 1) : (i == 0 ? this.poseTextFields.length - 1 : i - 1);
                this.poseTextFields[j].m_93692_(true);
                this.poseTextFields[j].m_94192_(0);
                this.poseTextFields[j].m_94208_(this.poseTextFields[j].m_94155_().length());
            }
        } else {
            if (this.rotationTextField.m_7933_(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            if (this.YOffsetTextField.m_7933_(keyCode, scanCode, modifiers)) {
                this.textFieldUpdated();
                return true;
            }
            for (NumberFieldBox textField : this.poseTextFields) {
                if (!textField.m_7933_(keyCode, scanCode, modifiers)) continue;
                return true;
            }
            this.textFieldUpdated();
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.rotationTextField.m_6375_(mouseX, mouseY, button);
        this.YOffsetTextField.m_6375_(mouseX, mouseY, button);
        for (NumberFieldBox textField : this.poseTextFields) {
            textField.m_6375_(mouseX, mouseY, button);
        }
        this.textFieldUpdated();
        return super.m_6375_(mouseX, mouseY, button);
    }

    protected void textFieldUpdated() {
        this.updateEntity(this.writeFieldsToNBT());
    }

    private CompoundTag writeFieldsToNBT() {
        CompoundTag compound = new CompoundTag();
        compound.m_128379_("Small", this.smallButton.getValue());
        compound.m_128379_("Locked", this.lockButton.getValue());
        compound.m_128379_("CustomNameVisible", this.nameVisibleButton.getValue());
        compound.m_128379_("NoGravity", this.noGravityButton.getValue());
        compound.m_128347_("yOffset", (double)this.YOffsetTextField.getFloat());
        compound.m_128359_("Model", ((Enum)this.forceModelType.getValue()).name());
        ListTag rotationTag = new ListTag();
        rotationTag.add((Object)FloatTag.m_128566_((float)this.rotationTextField.getFloat()));
        compound.m_128365_("Rotation", (Tag)rotationTag);
        CompoundTag poseTag = new CompoundTag();
        ListTag poseHeadTag = new ListTag();
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[0].getFloat()));
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[1].getFloat()));
        poseHeadTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[2].getFloat()));
        poseTag.m_128365_("Head", (Tag)poseHeadTag);
        ListTag poseBodyTag = new ListTag();
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[3].getFloat()));
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[4].getFloat()));
        poseBodyTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[5].getFloat()));
        poseTag.m_128365_("Body", (Tag)poseBodyTag);
        ListTag poseLeftLegTag = new ListTag();
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[6].getFloat()));
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[7].getFloat()));
        poseLeftLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[8].getFloat()));
        poseTag.m_128365_("LeftLeg", (Tag)poseLeftLegTag);
        ListTag poseRightLegTag = new ListTag();
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[9].getFloat()));
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[10].getFloat()));
        poseRightLegTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[11].getFloat()));
        poseTag.m_128365_("RightLeg", (Tag)poseRightLegTag);
        ListTag poseLeftArmTag = new ListTag();
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[12].getFloat()));
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[13].getFloat()));
        poseLeftArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[14].getFloat()));
        poseTag.m_128365_("LeftArm", (Tag)poseLeftArmTag);
        ListTag poseRightArmTag = new ListTag();
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[15].getFloat()));
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[16].getFloat()));
        poseRightArmTag.add((Object)FloatTag.m_128566_((float)this.poseTextFields[17].getFloat()));
        poseTag.m_128365_("RightArm", (Tag)poseRightArmTag);
        float offsetX = this.poseTextFields[18].getFloat();
        float offsetY = this.poseTextFields[19].getFloat();
        float offsetZ = this.poseTextFields[20].getFloat();
        double offsetXDiff = (double)offsetX - this.lastSendOffset.f_82479_;
        double offsetYDiff = (double)offsetY - this.lastSendOffset.f_82480_;
        double offsetZDiff = (double)offsetZ - this.lastSendOffset.f_82481_;
        ListTag positionOffset = new ListTag();
        positionOffset.add((Object)DoubleTag.m_128500_((double)offsetXDiff));
        positionOffset.add((Object)DoubleTag.m_128500_((double)offsetYDiff));
        positionOffset.add((Object)DoubleTag.m_128500_((double)offsetZDiff));
        compound.m_128365_("Move", (Tag)positionOffset);
        this.lastSendOffset = new Vec3((double)offsetX, (double)offsetY, (double)offsetZ);
        compound.m_128365_("Pose", (Tag)poseTag);
        return compound;
    }

    private void readFieldsFromNBT(CompoundTag compound) {
        PlayerStatueData statueData = new PlayerStatueData();
        statueData.readFromNBT(compound);
        this.smallButton.setValue(statueData.small);
        this.lockButton.setValue(statueData.locked);
        this.nameVisibleButton.setValue(statueData.nameVisible);
        this.noGravityButton.setValue(statueData.noGravity);
        this.YOffsetTextField.m_94144_(String.valueOf((double)statueData.yOffset));
        this.rotationTextField.m_94144_(String.valueOf((int)statueData.rotation));
        this.forceModelType.setValue(this.forceModelType.findValue(statueData.modelType));
        for (int i = 0; i < this.poseTextFields.length; ++i) {
            this.poseTextFields[i].m_94144_(String.valueOf((int)statueData.pose[i]));
        }
    }

    private void updateEntity(CompoundTag compound) {
        CompoundTag CompoundTag2 = this.playerStatueEntity.m_20240_(new CompoundTag()).m_6426_();
        CompoundTag2.m_128391_(compound);
        this.playerStatueEntity.clientLock = 0;
        this.playerStatueEntity.m_20258_(CompoundTag2);
        this.playerStatueEntity.clientLock = 5;
        StatuesNetworking.CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new PlayerStatueSyncMessage(this.playerStatueEntity.m_20148_(), compound));
    }

    public boolean m_7043_() {
        return false;
    }
}

