/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.client.render;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftProfileTexture;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Vector3f;
import com.shynieke.statues.blockentities.PlayerBlockEntity;
import com.shynieke.statues.blocks.statues.PlayerStatueBlock;
import com.shynieke.statues.client.ClientHandler;
import com.shynieke.statues.client.model.StatuePlayerTileModel;
import java.util.Map;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.core.Direction;
import net.minecraft.core.UUIDUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class PlayerBER
implements BlockEntityRenderer<PlayerBlockEntity> {
    private final StatuePlayerTileModel model;
    private final StatuePlayerTileModel slimModel;
    public static final ResourceLocation defaultTexture = DefaultPlayerSkin.m_118626_();

    public PlayerBER(BlockEntityRendererProvider.Context context) {
        this.model = new StatuePlayerTileModel(context.m_173582_(ClientHandler.PLAYER_STATUE), false);
        this.slimModel = new StatuePlayerTileModel(context.m_173582_(ClientHandler.PLAYER_STATUE_SLIM), true);
    }

    public void render(PlayerBlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLightIn, int combinedOverlayIn) {
        BlockState blockstate = blockEntity.m_58900_();
        boolean flag = blockstate.m_60734_() instanceof PlayerStatueBlock;
        Direction direction = flag ? (Direction)blockstate.m_61143_((Property)PlayerStatueBlock.FACING) : Direction.UP;
        GameProfile profile = blockEntity.getPlayerProfile();
        this.render(direction, profile, blockEntity.isSlim(), poseStack, bufferSource, combinedLightIn, partialTicks);
    }

    public void render(@Nullable Direction direction, @Nullable GameProfile profile, boolean isSlim, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, float partialTicks) {
        poseStack.m_85837_(0.5, 0.25, 0.5);
        poseStack.m_85836_();
        if (direction != null) {
            switch (direction) {
                case NORTH: {
                    break;
                }
                case SOUTH: {
                    poseStack.m_85845_(Vector3f.f_122225_.m_122240_(180.0f));
                    break;
                }
                case WEST: {
                    poseStack.m_85845_(Vector3f.f_122225_.m_122240_(90.0f));
                    break;
                }
                default: {
                    poseStack.m_85845_(Vector3f.f_122225_.m_122240_(270.0f));
                }
            }
        }
        poseStack.m_85841_(-1.0f, -1.0f, 1.0f);
        poseStack.m_85837_(0.0, -1.25, 0.0);
        boolean isSupporter = false;
        if (profile != null) {
            String s = ChatFormatting.m_126649_((String)profile.getName());
            if ("Dinnerbone".equalsIgnoreCase(s) || "Grumm".equalsIgnoreCase(s)) {
                poseStack.m_85837_(0.0, (double)1.85f, 0.0);
                poseStack.m_85845_(Vector3f.f_122227_.m_122240_(180.0f));
            }
            isSupporter = ClientHandler.SUPPORTER.contains(profile.getId());
        }
        int light = isSupporter ? 0xF000F0 : combinedLight;
        VertexConsumer vertexConsumer = bufferSource.m_6299_(PlayerBER.getRenderType(profile));
        StatuePlayerTileModel playerModel = isSlim ? this.slimModel : this.model;
        playerModel.m_7695_(poseStack, vertexConsumer, light, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        poseStack.m_85849_();
    }

    public static RenderType getRenderType(@Nullable GameProfile gameProfileIn) {
        if (gameProfileIn == null || !gameProfileIn.isComplete()) {
            return RenderType.m_110458_((ResourceLocation)defaultTexture);
        }
        Minecraft minecraft = Minecraft.m_91087_();
        Map map = minecraft.m_91109_().m_118815_(gameProfileIn);
        if (map.containsKey(MinecraftProfileTexture.Type.SKIN)) {
            return RenderType.m_110473_((ResourceLocation)minecraft.m_91109_().m_118825_((MinecraftProfileTexture)map.get(MinecraftProfileTexture.Type.SKIN), MinecraftProfileTexture.Type.SKIN));
        }
        return RenderType.m_110458_((ResourceLocation)DefaultPlayerSkin.m_118627_((UUID)UUIDUtil.m_235875_((GameProfile)gameProfileIn)));
    }
}

