/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blocks.statues.fish;

import com.shynieke.statues.blockentities.TropicalFishBlockEntity;
import com.shynieke.statues.blocks.AbstractStatueBase;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class FishStatueBlock
extends AbstractStatueBase {
    private static final VoxelShape SHAPE = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)4.0, (double)11.0);
    private static final VoxelShape SHAPE_BIG = Block.m_49796_((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)9.0, (double)11.0);
    private final int size;

    public FishStatueBlock(BlockBehaviour.Properties builder, int size) {
        super(builder.m_60918_(SoundType.f_56742_));
        this.size = size;
    }

    @Override
    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (this.size == 1) {
            return SHAPE_BIG;
        }
        return SHAPE;
    }

    @Override
    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player playerIn, InteractionHand handIn, BlockHitResult result) {
        ItemStack stack = playerIn.m_21120_(InteractionHand.MAIN_HAND);
        if (stack.m_41720_() == Items.f_41903_) {
            TropicalFishBlockEntity fishBlockEntity = this.getFishTE((BlockGetter)level, pos);
            fishBlockEntity.scrambleColors();
            level.m_7260_(pos, state, state, 6);
            level.m_5594_(null, pos, SoundEvents.f_12470_, SoundSource.NEUTRAL, 1.0f, 1.0f);
            if (!playerIn.m_150110_().f_35937_) {
                stack.m_41774_(1);
                if (!playerIn.m_150109_().m_36054_(new ItemStack((ItemLike)Items.f_41902_))) {
                    ItemEntity itemEntity = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_() + 0.5, (double)pos.m_123343_(), stack);
                    level.m_7967_((Entity)itemEntity);
                }
            }
        }
        return super.m_6227_(state, level, pos, playerIn, handIn, result);
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.hasTileEntity(state) ? new TropicalFishBlockEntity(pos, state) : null;
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    @Override
    public EntityType<?> getEntity() {
        return EntityType.f_20489_;
    }

    @Override
    public SoundEvent getSound(BlockState state) {
        return SoundEvents.f_12528_;
    }

    public TropicalFishBlockEntity getFishTE(BlockGetter getter, BlockPos pos) {
        return getter.m_7702_(pos) instanceof TropicalFishBlockEntity ? (TropicalFishBlockEntity)getter.m_7702_(pos) : null;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        TropicalFishBlockEntity fishBlockEntity = this.getFishTE((BlockGetter)level, pos);
        if (fishBlockEntity != null) {
            fishBlockEntity.scrambleColors();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int getColor(BlockState state, BlockGetter getter, BlockPos pos, int tintIndex) {
        BlockEntity blockEntity;
        if (pos != null && (blockEntity = getter.m_7702_(pos)) instanceof TropicalFishBlockEntity) {
            TropicalFishBlockEntity tropicalFishBlockEntity = (TropicalFishBlockEntity)blockEntity;
            return tintIndex == 1 ? FishStatueBlock.fromColor(tropicalFishBlockEntity.getMainColor()) : (tintIndex == 2 ? FishStatueBlock.fromColor(tropicalFishBlockEntity.getSecondaryColor()) : -1);
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int fromColor(int color) {
        return DyeColor.m_41053_((int)color).m_41071_();
    }
}

