/*
 * Decompiled with CFR 0.152.
 */
package com.shynieke.statues.blockentities;

import com.shynieke.statues.blockentities.StatueBlockEntity;
import com.shynieke.statues.menu.ShulkerStatueMenu;
import com.shynieke.statues.registry.StatueBlockEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShulkerStatueBlockEntity
extends StatueBlockEntity
implements MenuProvider {
    public final ItemStackHandler handler = new ItemStackHandler(18){

        public boolean isItemValid(int slot, @NotNull ItemStack stack) {
            return super.isItemValid(slot, stack) && !(Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock) && !(Block.m_49814_((Item)stack.m_41720_()) instanceof ShulkerBoxBlock) && stack.m_41720_().m_142095_();
        }

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            ShulkerStatueBlockEntity.this.refreshClient();
        }
    };
    private LazyOptional<IItemHandler> stackHolder = LazyOptional.of(() -> this.handler);

    public ShulkerStatueBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)StatueBlockEntities.SHULKER_STATUE.get(), pos, state);
    }

    @Override
    public void onSpecialInteract(Level level, BlockPos pos, BlockState state, Player player, InteractionHand handIn, BlockHitResult result) {
        if (!level.f_46443_ && !player.m_6047_()) {
            NetworkHooks.openScreen((ServerPlayer)((ServerPlayer)player), (MenuProvider)this, (BlockPos)pos);
        }
    }

    @Override
    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        compound.m_128365_("ItemStackHandler", (Tag)this.handler.serializeNBT());
    }

    @Override
    public void m_183515_(CompoundTag compound) {
        super.m_183515_(compound);
        this.handler.deserializeNBT(compound.m_128469_("ItemStackHandler"));
    }

    public Component m_5446_() {
        return Component.m_237115_((String)"statues.container.shulker_statue");
    }

    public boolean stillValid(Player player) {
        if (!this.hasSpecialInteraction()) {
            return false;
        }
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return !(player.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) > 64.0);
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int id, Inventory inventory, Player player) {
        return new ShulkerStatueMenu(id, inventory, this);
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, Direction facing) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && this.hasSpecialInteraction()) {
            return this.stackHolder.cast();
        }
        return super.getCapability(capability, facing);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        if (this.hasSpecialInteraction()) {
            this.stackHolder.invalidate();
        }
    }

    public void reviveCaps() {
        super.reviveCaps();
        if (this.hasSpecialInteraction()) {
            this.stackHolder = LazyOptional.of(() -> this.handler);
        }
    }
}

