/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.item.armor;

import earth.terrarium.ad_astra.common.config.SpaceSuitConfig;
import earth.terrarium.ad_astra.common.item.FluidContainingItem;
import earth.terrarium.ad_astra.common.item.armor.ModArmourItem;
import earth.terrarium.ad_astra.common.registry.ModItems;
import earth.terrarium.ad_astra.common.registry.ModTags;
import earth.terrarium.botarium.api.fluid.FluidHolder;
import earth.terrarium.botarium.api.fluid.FluidHooks;
import earth.terrarium.botarium.api.item.ItemStackHolder;
import java.util.List;
import java.util.function.BiPredicate;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DyeableArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluid;
import org.apache.commons.lang3.Range;
import org.jetbrains.annotations.NotNull;

public class SpaceSuit
extends DyeableArmorItem
implements FluidContainingItem,
ModArmourItem {
    public SpaceSuit(ArmorMaterial material, EquipmentSlot slot, Item.Properties properties) {
        super(material, slot, properties);
    }

    public static boolean hasFullSet(LivingEntity entity) {
        int slotCount = 0;
        int armorCount = 0;
        for (ItemStack stack : entity.m_6168_()) {
            ++slotCount;
            if (!(stack.m_41720_() instanceof SpaceSuit)) continue;
            ++armorCount;
        }
        return slotCount > 0 && armorCount == slotCount;
    }

    public static boolean hasOxygenatedSpaceSuit(LivingEntity entity) {
        ItemStack chest = entity.m_6844_(EquipmentSlot.CHEST);
        Item item = chest.m_41720_();
        if (item instanceof SpaceSuit) {
            SpaceSuit suit = (SpaceSuit)item;
            return suit.getFluidAmount(chest) > 0L;
        }
        return false;
    }

    public static void consumeSpaceSuitOxygen(LivingEntity entity, long amount) {
        ItemStackHolder chest = new ItemStackHolder(entity.m_6844_(EquipmentSlot.CHEST));
        Item item = chest.getStack().m_41720_();
        if (item instanceof SpaceSuit) {
            SpaceSuit suit = (SpaceSuit)item;
            suit.extract(chest, FluidHooks.newFluidHolder((Fluid)suit.getFluid(chest.getStack()), (long)amount, null));
            if (chest.isDirty()) {
                entity.m_8061_(EquipmentSlot.CHEST, chest.getStack());
            }
        }
    }

    public void m_7373_(ItemStack stack, Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag context) {
        if (stack.m_150930_((Item)ModItems.SPACE_SUIT.get()) || stack.m_150930_((Item)ModItems.NETHERITE_SPACE_SUIT.get()) || stack.m_150930_((Item)ModItems.JET_SUIT.get())) {
            long oxygen = FluidHooks.toMillibuckets((long)FluidHooks.getItemFluidManager((ItemStack)stack).getFluidInTank(0).getFluidAmount());
            tooltip.add((Component)Component.m_237110_((String)"tooltip.ad_astra.space_suit", (Object[])new Object[]{oxygen, FluidHooks.toMillibuckets((long)this.getTankSize())}).m_6270_(Style.f_131099_.m_131140_(oxygen > 0L ? ChatFormatting.GREEN : ChatFormatting.RED)));
        }
    }

    @Override
    public long getTankSize() {
        return SpaceSuitConfig.spaceSuitTankSize;
    }

    @Override
    public BiPredicate<Integer, FluidHolder> getFilter() {
        return (i, f) -> f.getFluid().m_205067_(ModTags.OXYGEN);
    }

    public Range<Integer> getTemperatureThreshold() {
        return Range.between((Comparable)Integer.valueOf(-300), (Comparable)Integer.valueOf(60));
    }

    public int m_41121_(@NotNull ItemStack stack) {
        int colour = super.m_41121_(stack);
        return colour == 10511680 ? 0xFFFFFF : colour;
    }

    @Override
    public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
        return new ResourceLocation("ad_astra", "textures/entity/armour/space_suit.png").toString();
    }
}

