/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.common.block.flag;

import com.mojang.authlib.GameProfile;
import dev.architectury.injectables.annotations.PlatformOnly;
import earth.terrarium.ad_astra.common.registry.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.SkullBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FlagBlockEntity
extends BlockEntity {
    @Nullable
    private GameProfile owner;
    @Nullable
    private String id;

    public FlagBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)ModBlockEntityTypes.FLAG.get(), pos, state);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (this.owner != null) {
            CompoundTag compound = new CompoundTag();
            NbtUtils.m_129230_((CompoundTag)compound, (GameProfile)this.owner);
            tag.m_128365_("flagOwner", (Tag)compound);
        }
        if (this.id != null) {
            tag.m_128359_("FlagUrl", this.id);
        }
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        if (tag.m_128425_("flagOwner", 10)) {
            this.setOwner(NbtUtils.m_129228_((CompoundTag)tag.m_128469_("flagOwner")));
        }
        if (tag.m_128425_("FlagUrl", 8)) {
            this.setId(tag.m_128461_("FlagUrl"));
        }
    }

    @Nullable
    public GameProfile getOwner() {
        return this.owner;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOwner(GameProfile profile) {
        FlagBlockEntity flagBlockEntity = this;
        synchronized (flagBlockEntity) {
            this.owner = profile;
        }
        this.loadOwnerProperties();
    }

    private void loadOwnerProperties() {
        SkullBlockEntity.m_155738_((GameProfile)this.owner, owner -> {
            this.owner = owner;
            this.m_6596_();
        });
    }

    @Nullable
    public String getUrl() {
        if (this.id == null) {
            return null;
        }
        return "https://i.imgur.com/" + this.id + ".png";
    }

    public void setId(@Nullable String id) {
        this.id = id;
    }

    @Nullable
    public Packet<ClientGamePacketListener> m_58483_() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    @NotNull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    @PlatformOnly(value={"forge"})
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_()).m_82400_(2.0);
    }
}

