/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.ad_astra.client.screen.util;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Vector3f;
import com.teamresourceful.resourcefullib.common.color.Color;
import earth.terrarium.ad_astra.client.screen.util.PlanetSelectionScreen;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiComponent;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ScreenUtils {
    public static Component createText(String text) {
        return Component.m_237115_((String)("gui.ad_astra.text." + text));
    }

    public static Component createText(ResourceLocation text) {
        return Component.m_237115_((String)("gui." + text.m_135827_() + ".text." + text.m_135815_()));
    }

    public static void addTexture(PoseStack poseStack, int x, int y, int width, int height, ResourceLocation texture) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)texture);
        GuiComponent.m_93133_((PoseStack)poseStack, (int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (int)width, (int)height);
    }

    public static void addRotatingTexture(PlanetSelectionScreen screen, PoseStack poseStack, int x, int y, int width, int height, ResourceLocation texture, float speed) {
        double scale = (double)Minecraft.m_91087_().m_91268_().m_85446_() / 400.0;
        x = (int)((double)x * scale);
        y = (int)((double)y * scale);
        ++x;
        ++y;
        width = (int)((double)width * scale);
        height = (int)((double)height * scale);
        poseStack.m_85836_();
        poseStack.m_85837_((double)((float)screen.f_96543_ / 2.0f), (double)((float)screen.f_96544_ / 2.0f), 0.0);
        poseStack.m_85845_(Vector3f.f_122227_.m_122240_(screen.getGuiTime() * (speed / 3.0f)));
        ScreenUtils.addTexture(poseStack, x, y, width, height, texture);
        poseStack.m_85849_();
    }

    public static void drawCircle(double x, double y, double radius, int sides, Color ringColour) {
        double width;
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        double scale = (double)Minecraft.m_91087_().m_91268_().m_85446_() / 400.0;
        for (double i = width = (radius *= scale) - 0.6; i < radius - 0.5 + 1.0; i += 0.1) {
            bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
            for (int j = 0; j <= sides; ++j) {
                double angle = Math.PI * 2 * (double)j / (double)sides + Math.toRadians(180.0);
                bufferBuilder.m_5483_(x + Math.sin(angle) * i, y + Math.cos(angle) * i, 0.0).m_6122_(ringColour.getIntRed(), ringColour.getIntGreen(), ringColour.getIntBlue(), ringColour.getIntAlpha()).m_5752_();
            }
            tessellator.m_85914_();
        }
    }

    public static void drawLine(int x1, int x2, int y1, int y2, int colour) {
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder bufferBuilder = tessellator.m_85915_();
        RenderSystem.m_157427_(GameRenderer::m_172811_);
        bufferBuilder.m_166779_(VertexFormat.Mode.DEBUG_LINE_STRIP, DefaultVertexFormat.f_85815_);
        bufferBuilder.m_5483_((double)x1, (double)y1, 0.0).m_85950_((float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, 1.0f).m_5752_();
        bufferBuilder.m_5483_((double)x2, (double)y2, 0.0).m_85950_((float)(colour >> 16 & 0xFF) / 255.0f, (float)(colour >> 8 & 0xFF) / 255.0f, (float)(colour & 0xFF) / 255.0f, 1.0f).m_5752_();
        tessellator.m_85914_();
    }
}

