/*
 * Decompiled with CFR 0.152.
 */
package gripe._90.megacells.integration.appmek.datagen;

import appeng.core.AppEng;
import appeng.core.definitions.ItemDefinition;
import gripe._90.megacells.integration.appmek.AppMekItems;
import gripe._90.megacells.util.Utils;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;

public class AppMekItemModelProvider
extends ItemModelProvider {
    static final ResourceLocation STORAGE_CELL_LED = AppEng.makeId((String)"item/storage_cell_led");
    static final ResourceLocation PORTABLE_CELL_LED = AppEng.makeId((String)"item/portable_cell_led");
    static final ResourceLocation DRIVE_CELL = AppEng.makeId((String)"block/drive/drive_cell");

    public AppMekItemModelProvider(DataGenerator gen, ExistingFileHelper efh) {
        super(gen, "megacells", efh);
        efh.trackGenerated(STORAGE_CELL_LED, (ExistingFileHelper.IResourceType)TEXTURE);
        efh.trackGenerated(PORTABLE_CELL_LED, (ExistingFileHelper.IResourceType)TEXTURE);
        efh.trackGenerated(DRIVE_CELL, (ExistingFileHelper.IResourceType)MODEL);
    }

    protected void registerModels() {
        this.flatSingleLayer(AppMekItems.MEGA_CHEMICAL_CELL_HOUSING);
        for (ItemDefinition<?> storage : AppMekItems.getCells()) {
            this.cell(storage);
        }
        for (ItemDefinition<?> portable : AppMekItems.getPortables()) {
            this.portable(portable);
        }
        this.flatSingleLayer(AppMekItems.RADIOACTIVE_CELL_COMPONENT);
        this.cell(AppMekItems.RADIOACTIVE_CHEMICAL_CELL);
        this.driveCell("mega_chemical_cell");
        this.driveCell("radioactive_chemical_cell");
    }

    private void driveCell(String texture) {
        ((ItemModelBuilder)this.withExistingParent("block/drive/cells/" + texture, DRIVE_CELL)).texture("cell", Utils.makeId("block/drive/cells/" + texture));
    }

    private void cell(ItemDefinition<?> cell) {
        this.flatSingleLayer(cell, "cell/standard/").texture("layer1", STORAGE_CELL_LED);
    }

    private void portable(ItemDefinition<?> cell) {
        this.flatSingleLayer(cell, "cell/portable/").texture("layer1", PORTABLE_CELL_LED);
    }

    private void flatSingleLayer(ItemDefinition<?> item) {
        this.flatSingleLayer(item, "");
    }

    private ItemModelBuilder flatSingleLayer(ItemDefinition<?> item, String subfolder) {
        String path = item.id().m_135815_();
        return (ItemModelBuilder)this.singleTexture(path, this.mcLoc("item/generated"), "layer0", Utils.makeId("item/" + subfolder + path));
    }

    @NotNull
    public String m_6055_() {
        return super.m_6055_() + "/appmek";
    }
}

