/*
 * Decompiled with CFR 0.152.
 */
package artifacts.common.item.curio.belt;

import artifacts.common.capability.SwimHandler;
import artifacts.common.config.ModConfig;
import artifacts.common.init.ModSoundEvents;
import artifacts.common.item.curio.CurioItem;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.MovementInputUpdateEvent;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fluids.FluidType;
import top.theillusivec4.curios.api.SlotContext;
import top.theillusivec4.curios.api.type.capability.ICurio;

public class HeliumFlamingoItem
extends CurioItem {
    public HeliumFlamingoItem() {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.addListener(this::onPlayerTick);
    }

    @Nonnull
    public ICurio.SoundInfo getEquipSound(SlotContext slotContext, ItemStack stack) {
        return new ICurio.SoundInfo((SoundEvent)ModSoundEvents.POP.get(), 1.0f, 0.7f);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag flags) {
        if (ModConfig.server != null && ModConfig.server.isCosmetic(this)) {
            super.m_7373_(stack, world, tooltip, flags);
        } else if (((Boolean)ModConfig.client.showTooltips.get()).booleanValue()) {
            tooltip.add((Component)Component.m_237115_((String)(this.m_5524_() + ".tooltip.0")).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)(this.m_5524_() + ".tooltip.1"), (Object[])new Object[]{Minecraft.m_91087_().f_91066_.f_92091_.m_90863_()}).m_130940_(ChatFormatting.GRAY));
        }
    }

    private void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.START) {
            return;
        }
        event.player.getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
            int maxFlightTime = (Integer)ModConfig.server.heliumFlamingo.maxFlightTime.get();
            int rechargeTime = (Integer)ModConfig.server.heliumFlamingo.rechargeTime.get();
            if (handler.isSwimming()) {
                if (!this.isEquippedBy((LivingEntity)event.player) || handler.getSwimTime() > maxFlightTime || event.player.m_20069_() && !event.player.m_6069_() && !handler.isSinking() || (!event.player.m_20069_() || handler.isSinking()) && event.player.m_20096_()) {
                    handler.setSwimming(false);
                    if (!event.player.m_20096_() && !event.player.m_20069_()) {
                        event.player.m_5496_((SoundEvent)ModSoundEvents.POP.get(), 0.5f, 0.75f);
                    }
                }
                if (this.isEquippedBy((LivingEntity)event.player) && !event.player.isEyeInFluidType((FluidType)ForgeMod.WATER_TYPE.get())) {
                    if (event.player.f_19797_ % 20 == 0) {
                        this.damageEquippedStacks((LivingEntity)event.player);
                    }
                    if (!event.player.m_150110_().f_35934_ && maxFlightTime > 0) {
                        handler.setSwimTime(handler.getSwimTime() + 1);
                    }
                }
            } else if (handler.getSwimTime() < 0) {
                handler.setSwimTime(handler.getSwimTime() < -rechargeTime ? -rechargeTime : handler.getSwimTime() + 1);
            }
        });
    }

    private class ClientEventHandler {
        private boolean wasSprintKeyDown;
        private boolean wasSprintingOnGround;
        private boolean hasTouchedGround;

        private ClientEventHandler() {
        }

        @OnlyIn(value=Dist.CLIENT)
        @SubscribeEvent
        public void onInputUpdate(MovementInputUpdateEvent event) {
            if (ModConfig.server.isCosmetic(HeliumFlamingoItem.this)) {
                return;
            }
            Player player = event.getEntity();
            boolean isSprintKeyDown = Minecraft.m_91087_().f_91066_.f_92091_.m_90857_();
            player.getCapability(SwimHandler.CAPABILITY).ifPresent(handler -> {
                if (!handler.isSwimming()) {
                    if (player.m_20096_()) {
                        this.hasTouchedGround = true;
                    } else if (!(handler.isSwimming() || handler.getSwimTime() < 0 || !HeliumFlamingoItem.this.isEquippedBy((LivingEntity)player) || !player.m_6069_() && (!isSprintKeyDown || this.wasSprintKeyDown || this.wasSprintingOnGround || !this.hasTouchedGround || player.m_20096_() || player.m_20069_() && !handler.isSinking() || player.m_21255_() || player.m_150110_().f_35935_ || player.m_20159_()))) {
                        handler.setSwimming(true);
                        handler.syncSwimming();
                        this.hasTouchedGround = false;
                    }
                } else if (player.m_150110_().f_35935_) {
                    handler.setSwimming(false);
                    handler.syncSwimming();
                    this.hasTouchedGround = true;
                }
            });
            this.wasSprintKeyDown = isSprintKeyDown;
            if (!isSprintKeyDown) {
                this.wasSprintingOnGround = false;
            } else if (player.m_20096_()) {
                this.wasSprintingOnGround = true;
            }
        }
    }
}

