/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import com.mowmaster.mowlib.api.IColorable;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.ItemTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class MowLibColorReference
implements IColorable {
    public static final int DEFAULTCOLOR = 0xFFFFFF;
    public static final List<Integer> DEFAULTCOLORLIST = Arrays.asList(3, 3, 3);
    public static List<Integer> ALL_COLORS = Arrays.asList(0x2A2A2A, 85, 170, 255, 21760, 21845, 21930, 22015, 43520, 43605, 43690, 43775, 65280, 65365, 65450, 65535, 0x550000, 0x550055, 0x5500AA, 0x5500FF, 0x555500, 0x555555, 0x5555AA, 0x5555FF, 0x55AA00, 0x55AA55, 0x55AAAA, 0x55AAFF, 0x55FF00, 0x55FF55, 0x55FFAA, 0x55FFFF, 0xAA0000, 0xAA0055, 0xAA00AA, 0xAA00FF, 0xAA5500, 0xAA5555, 0xAA55AA, 0xAA55FF, 0xAAAA00, 0xAAAA55, 0xAAAAAA, 0xAAAAFF, 0xAAFF00, 0xAAFF55, 0xAAFFAA, 0xAAFFFF, 0xFF0000, 0xFF0055, 0xFF00AA, 0xFF00FF, 0xFF5500, 0xFF5555, 0xFF55AA, 0xFF55FF, 0xFFAA00, 0xFFAA55, 0xFFAAAA, 0xFFAAFF, 0xFFFF00, 0xFFFF55, 0xFFFFAA, 0xFFFFFF);

    public static int getColor(List<Integer> listRGB) {
        Random rand = new Random();
        List<Integer> listedRGB = listRGB.equals(Arrays.asList(-1, -1, -1)) ? Arrays.asList(rand.nextInt(3), rand.nextInt(3), rand.nextInt(3)) : listRGB;
        Map COLORS_REFERENCE = Map.ofEntries(Map.entry(Arrays.asList(0, 0, 0), 0x2A2A2A), Map.entry(Arrays.asList(0, 0, 1), 85), Map.entry(Arrays.asList(0, 0, 2), 170), Map.entry(Arrays.asList(0, 0, 3), 255), Map.entry(Arrays.asList(0, 1, 0), 21760), Map.entry(Arrays.asList(0, 1, 1), 21845), Map.entry(Arrays.asList(0, 1, 2), 21930), Map.entry(Arrays.asList(0, 1, 3), 22015), Map.entry(Arrays.asList(0, 2, 0), 43520), Map.entry(Arrays.asList(0, 2, 1), 43605), Map.entry(Arrays.asList(0, 2, 2), 43690), Map.entry(Arrays.asList(0, 2, 3), 43775), Map.entry(Arrays.asList(0, 3, 0), 65280), Map.entry(Arrays.asList(0, 3, 1), 65365), Map.entry(Arrays.asList(0, 3, 2), 65450), Map.entry(Arrays.asList(0, 3, 3), 65535), Map.entry(Arrays.asList(1, 0, 0), 0x550000), Map.entry(Arrays.asList(1, 0, 1), 0x550055), Map.entry(Arrays.asList(1, 0, 2), 0x5500AA), Map.entry(Arrays.asList(1, 0, 3), 0x5500FF), Map.entry(Arrays.asList(1, 1, 0), 0x555500), Map.entry(Arrays.asList(1, 1, 1), 0x555555), Map.entry(Arrays.asList(1, 1, 2), 0x5555AA), Map.entry(Arrays.asList(1, 1, 3), 0x5555FF), Map.entry(Arrays.asList(1, 2, 0), 0x55AA00), Map.entry(Arrays.asList(1, 2, 1), 0x55AA55), Map.entry(Arrays.asList(1, 2, 2), 0x55AAAA), Map.entry(Arrays.asList(1, 2, 3), 0x55AAFF), Map.entry(Arrays.asList(1, 3, 0), 0x55FF00), Map.entry(Arrays.asList(1, 3, 1), 0x55FF55), Map.entry(Arrays.asList(1, 3, 2), 0x55FFAA), Map.entry(Arrays.asList(1, 3, 3), 0x55FFFF), Map.entry(Arrays.asList(2, 0, 0), 0xAA0000), Map.entry(Arrays.asList(2, 0, 1), 0xAA0055), Map.entry(Arrays.asList(2, 0, 2), 0xAA00AA), Map.entry(Arrays.asList(2, 0, 3), 0xAA00FF), Map.entry(Arrays.asList(2, 1, 0), 0xAA5500), Map.entry(Arrays.asList(2, 1, 1), 0xAA5555), Map.entry(Arrays.asList(2, 1, 2), 0xAA55AA), Map.entry(Arrays.asList(2, 1, 3), 0xAA55FF), Map.entry(Arrays.asList(2, 2, 0), 0xAAAA00), Map.entry(Arrays.asList(2, 2, 1), 0xAAAA55), Map.entry(Arrays.asList(2, 2, 2), 0xAAAAAA), Map.entry(Arrays.asList(2, 2, 3), 0xAAAAFF), Map.entry(Arrays.asList(2, 3, 0), 0xAAFF00), Map.entry(Arrays.asList(2, 3, 1), 0xAAFF55), Map.entry(Arrays.asList(2, 3, 2), 0xAAFFAA), Map.entry(Arrays.asList(2, 3, 3), 0xAAFFFF), Map.entry(Arrays.asList(3, 0, 0), 0xFF0000), Map.entry(Arrays.asList(3, 0, 1), 0xFF0055), Map.entry(Arrays.asList(3, 0, 2), 0xFF00AA), Map.entry(Arrays.asList(3, 0, 3), 0xFF00FF), Map.entry(Arrays.asList(3, 1, 0), 0xFF5500), Map.entry(Arrays.asList(3, 1, 1), 0xFF5555), Map.entry(Arrays.asList(3, 1, 2), 0xFF55AA), Map.entry(Arrays.asList(3, 1, 3), 0xFF55FF), Map.entry(Arrays.asList(3, 2, 0), 0xFFAA00), Map.entry(Arrays.asList(3, 2, 1), 0xFFAA55), Map.entry(Arrays.asList(3, 2, 2), 0xFFAAAA), Map.entry(Arrays.asList(3, 2, 3), 0xFFAAFF), Map.entry(Arrays.asList(3, 3, 0), 0xFFFF00), Map.entry(Arrays.asList(3, 3, 1), 0xFFFF55), Map.entry(Arrays.asList(3, 3, 2), 0xFFFFAA), Map.entry(Arrays.asList(3, 3, 3), 0xFFFFFF));
        return COLORS_REFERENCE.getOrDefault(listedRGB, 0xFFFFFF);
    }

    public static List<Integer> getIntColor(int color) {
        Random rand = new Random();
        Map COLORS_INT_REFERENCE = Map.ofEntries(Map.entry(0x2A2A2A, Arrays.asList(0, 0, 0)), Map.entry(85, Arrays.asList(0, 0, 1)), Map.entry(170, Arrays.asList(0, 0, 2)), Map.entry(255, Arrays.asList(0, 0, 3)), Map.entry(21760, Arrays.asList(0, 1, 0)), Map.entry(21845, Arrays.asList(0, 1, 1)), Map.entry(21930, Arrays.asList(0, 1, 2)), Map.entry(22015, Arrays.asList(0, 1, 3)), Map.entry(43520, Arrays.asList(0, 2, 0)), Map.entry(43605, Arrays.asList(0, 2, 1)), Map.entry(43690, Arrays.asList(0, 2, 2)), Map.entry(43775, Arrays.asList(0, 2, 3)), Map.entry(65280, Arrays.asList(0, 3, 0)), Map.entry(65365, Arrays.asList(0, 3, 1)), Map.entry(65450, Arrays.asList(0, 3, 2)), Map.entry(65535, Arrays.asList(0, 3, 3)), Map.entry(0x550000, Arrays.asList(1, 0, 0)), Map.entry(0x550055, Arrays.asList(1, 0, 1)), Map.entry(0x5500AA, Arrays.asList(1, 0, 2)), Map.entry(0x5500FF, Arrays.asList(1, 0, 3)), Map.entry(0x555500, Arrays.asList(1, 1, 0)), Map.entry(0x555555, Arrays.asList(1, 1, 1)), Map.entry(0x5555AA, Arrays.asList(1, 1, 2)), Map.entry(0x5555FF, Arrays.asList(1, 1, 3)), Map.entry(0x55AA00, Arrays.asList(1, 2, 0)), Map.entry(0x55AA55, Arrays.asList(1, 2, 1)), Map.entry(0x55AAAA, Arrays.asList(1, 2, 2)), Map.entry(0x55AAFF, Arrays.asList(1, 2, 3)), Map.entry(0x55FF00, Arrays.asList(1, 3, 0)), Map.entry(0x55FF55, Arrays.asList(1, 3, 1)), Map.entry(0x55FFAA, Arrays.asList(1, 3, 2)), Map.entry(0x55FFFF, Arrays.asList(1, 3, 3)), Map.entry(0xAA0000, Arrays.asList(2, 0, 0)), Map.entry(0xAA0055, Arrays.asList(2, 0, 1)), Map.entry(0xAA00AA, Arrays.asList(2, 0, 2)), Map.entry(0xAA00FF, Arrays.asList(2, 0, 3)), Map.entry(0xAA5500, Arrays.asList(2, 1, 0)), Map.entry(0xAA5555, Arrays.asList(2, 1, 1)), Map.entry(0xAA55AA, Arrays.asList(2, 1, 2)), Map.entry(0xAA55FF, Arrays.asList(2, 1, 3)), Map.entry(0xAAAA00, Arrays.asList(2, 2, 0)), Map.entry(0xAAAA55, Arrays.asList(2, 2, 1)), Map.entry(0xAAAAAA, Arrays.asList(2, 2, 2)), Map.entry(0xAAAAFF, Arrays.asList(2, 2, 3)), Map.entry(0xAAFF00, Arrays.asList(2, 3, 0)), Map.entry(0xAAFF55, Arrays.asList(2, 3, 1)), Map.entry(0xAAFFAA, Arrays.asList(2, 3, 2)), Map.entry(0xAAFFFF, Arrays.asList(2, 3, 3)), Map.entry(0xFF0000, Arrays.asList(3, 0, 0)), Map.entry(0xFF0055, Arrays.asList(3, 0, 1)), Map.entry(0xFF00AA, Arrays.asList(3, 0, 2)), Map.entry(0xFF00FF, Arrays.asList(3, 0, 3)), Map.entry(0xFF5500, Arrays.asList(3, 1, 0)), Map.entry(0xFF5555, Arrays.asList(3, 1, 1)), Map.entry(0xFF55AA, Arrays.asList(3, 1, 2)), Map.entry(0xFF55FF, Arrays.asList(3, 1, 3)), Map.entry(0xFFAA00, Arrays.asList(3, 2, 0)), Map.entry(0xFFAA55, Arrays.asList(3, 2, 1)), Map.entry(0xFFAAAA, Arrays.asList(3, 2, 2)), Map.entry(0xFFAAFF, Arrays.asList(3, 2, 3)), Map.entry(0xFFFF00, Arrays.asList(3, 3, 0)), Map.entry(0xFFFF55, Arrays.asList(3, 3, 1)), Map.entry(0xFFFFAA, Arrays.asList(3, 3, 2)), Map.entry(0xFFFFFF, Arrays.asList(3, 3, 3)));
        return color == -1 ? Arrays.asList(rand.nextInt(3), rand.nextInt(3), rand.nextInt(3)) : COLORS_INT_REFERENCE.getOrDefault(color, DEFAULTCOLORLIST);
    }

    public static String getColorName(int color) {
        Random rand = new Random();
        Map COLORS_INT_REFERENCE = Map.ofEntries(Map.entry(0x2A2A2A, "mowlib_colorName000"), Map.entry(85, "mowlib_colorName001"), Map.entry(170, "mowlib_colorName002"), Map.entry(255, "mowlib_colorName003"), Map.entry(21760, "mowlib_colorName010"), Map.entry(21845, "mowlib_colorName011"), Map.entry(21930, "mowlib_colorName012"), Map.entry(22015, "mowlib_colorName013"), Map.entry(43520, "mowlib_colorName020"), Map.entry(43605, "mowlib_colorName021"), Map.entry(43690, "mowlib_colorName022"), Map.entry(43775, "mowlib_colorName023"), Map.entry(65280, "mowlib_colorName030"), Map.entry(65365, "mowlib_colorName031"), Map.entry(65450, "mowlib_colorName032"), Map.entry(65535, "mowlib_colorName033"), Map.entry(0x550000, "mowlib_colorName100"), Map.entry(0x550055, "mowlib_colorName101"), Map.entry(0x5500AA, "mowlib_colorName102"), Map.entry(0x5500FF, "mowlib_colorName103"), Map.entry(0x555500, "mowlib_colorName110"), Map.entry(0x555555, "mowlib_colorName111"), Map.entry(0x5555AA, "mowlib_colorName112"), Map.entry(0x5555FF, "mowlib_colorName113"), Map.entry(0x55AA00, "mowlib_colorName120"), Map.entry(0x55AA55, "mowlib_colorName121"), Map.entry(0x55AAAA, "mowlib_colorName122"), Map.entry(0x55AAFF, "mowlib_colorName123"), Map.entry(0x55FF00, "mowlib_colorName130"), Map.entry(0x55FF55, "mowlib_colorName131"), Map.entry(0x55FFAA, "mowlib_colorName132"), Map.entry(0x55FFFF, "mowlib_colorName133"), Map.entry(0xAA0000, "mowlib_colorName200"), Map.entry(0xAA0055, "mowlib_colorName201"), Map.entry(0xAA00AA, "mowlib_colorName202"), Map.entry(0xAA00FF, "mowlib_colorName203"), Map.entry(0xAA5500, "mowlib_colorName210"), Map.entry(0xAA5555, "mowlib_colorName211"), Map.entry(0xAA55AA, "mowlib_colorName212"), Map.entry(0xAA55FF, "mowlib_colorName213"), Map.entry(0xAAAA00, "mowlib_colorName220"), Map.entry(0xAAAA55, "mowlib_colorName221"), Map.entry(0xAAAAAA, "mowlib_colorName222"), Map.entry(0xAAAAFF, "mowlib_colorName223"), Map.entry(0xAAFF00, "mowlib_colorName230"), Map.entry(0xAAFF55, "mowlib_colorName231"), Map.entry(0xAAFFAA, "mowlib_colorName232"), Map.entry(0xAAFFFF, "mowlib_colorName233"), Map.entry(0xFF0000, "mowlib_colorName300"), Map.entry(0xFF0055, "mowlib_colorName301"), Map.entry(0xFF00AA, "mowlib_colorName302"), Map.entry(0xFF00FF, "mowlib_colorName303"), Map.entry(0xFF5500, "mowlib_colorName310"), Map.entry(0xFF5555, "mowlib_colorName311"), Map.entry(0xFF55AA, "mowlib_colorName312"), Map.entry(0xFF55FF, "mowlib_colorName313"), Map.entry(0xFFAA00, "mowlib_colorName320"), Map.entry(0xFFAA55, "mowlib_colorName321"), Map.entry(0xFFAAAA, "mowlib_colorName322"), Map.entry(0xFFAAFF, "mowlib_colorName323"), Map.entry(0xFFFF00, "mowlib_colorName330"), Map.entry(0xFFFF55, "mowlib_colorName331"), Map.entry(0xFFFFAA, "mowlib_colorName332"), Map.entry(0xFFFFFF, "mowlib_colorName333"));
        return COLORS_INT_REFERENCE.getOrDefault(color, (String)COLORS_INT_REFERENCE.get(MowLibColorReference.getColor(Arrays.asList(rand.nextInt(3), rand.nextInt(3), rand.nextInt(3)))));
    }

    public static ItemStack addColorToItemStack(ItemStack stackIn, int r, int g, int b) {
        CompoundTag blockColors = stackIn.m_41784_();
        blockColors.m_128405_("mowlib_color", MowLibColorReference.getColor(Arrays.asList(r, g, b)));
        stackIn.m_41751_(blockColors);
        return stackIn;
    }

    public static ItemStack addColorToItemStack(ItemStack stackIn, int color) {
        CompoundTag blockColors = stackIn.m_41784_();
        blockColors.m_128405_("mowlib_color", color);
        stackIn.m_41751_(blockColors);
        return stackIn;
    }

    public static ItemStack addSecondColorToItemStack(ItemStack stackIn, int color) {
        CompoundTag blockColors = stackIn.m_41784_();
        blockColors.m_128405_("mowlib_colorTwo", color);
        stackIn.m_41751_(blockColors);
        return stackIn;
    }

    public static BlockState addColorToBlockState(BlockState stateIn, int color) {
        List<Integer> getColor = MowLibColorReference.getIntColor(color);
        BlockState newState = (BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)COLOR_RED, (Comparable)getColor.get(0))).m_61124_((Property)COLOR_GREEN, (Comparable)getColor.get(1))).m_61124_((Property)COLOR_BLUE, (Comparable)getColor.get(2));
        return newState;
    }

    public static BlockState addColorToBlockState(BlockState stateIn, int red, int green, int blue) {
        BlockState newState = (BlockState)((BlockState)((BlockState)stateIn.m_61124_((Property)COLOR_RED, (Comparable)Integer.valueOf(red))).m_61124_((Property)COLOR_GREEN, (Comparable)Integer.valueOf(green))).m_61124_((Property)COLOR_BLUE, (Comparable)Integer.valueOf(blue));
        return newState;
    }

    public static int getColorFromStateInt(BlockState state) {
        return MowLibColorReference.getColor(MowLibColorReference.getColorFromStateList(state));
    }

    public static List<Integer> getColorFromStateList(BlockState state) {
        int r = 0;
        int g = 0;
        int b = 0;
        if (state.m_61138_((Property)COLOR_RED) && state.m_61138_((Property)COLOR_GREEN) && state.m_61138_((Property)COLOR_BLUE)) {
            if (state.m_61138_((Property)COLOR_RED)) {
                r = (Integer)state.m_61143_((Property)COLOR_RED);
            }
            if (state.m_61138_((Property)COLOR_GREEN)) {
                g = (Integer)state.m_61143_((Property)COLOR_GREEN);
            }
            if (state.m_61138_((Property)COLOR_BLUE)) {
                b = (Integer)state.m_61143_((Property)COLOR_BLUE);
            }
        }
        return Arrays.asList(r, g, b);
    }

    public static boolean isColorItem(ItemStack stackIn) {
        CompoundTag blockColors = stackIn.m_41784_();
        return blockColors.m_128441_("mowlib_color");
    }

    public static int getColorFromItemStackInt(ItemStack stackIn) {
        CompoundTag blockColors = stackIn.m_41784_();
        if (blockColors.m_128441_("mowlib_color")) {
            int color = blockColors.m_128451_("mowlib_color");
            return color;
        }
        return 0xFFFFFF;
    }

    public static int getSecondColorFromItemStackInt(ItemStack stackIn) {
        CompoundTag blockColors = stackIn.m_41784_();
        if (blockColors.m_128441_("mowlib_colorTwo")) {
            int color = blockColors.m_128451_("mowlib_colorTwo");
            return color;
        }
        return 0xFFFFFF;
    }

    public static int getColorFromTag(CompoundTag tag) {
        CompoundTag blockColors = tag;
        if (blockColors.m_128441_("mowlib_color")) {
            int color = blockColors.m_128451_("mowlib_color");
            return color;
        }
        return 0xFFFFFF;
    }

    public static List<Integer> getColorFromItemStackRGBList(ItemStack stackIn) {
        return MowLibColorReference.getIntColor(MowLibColorReference.getColorFromItemStackInt(stackIn));
    }

    public static List<Integer> mixColorsList(int r1, int g1, int b1, int r2, int g2, int b2) {
        int green;
        int red;
        int B;
        int G;
        int R;
        double greenIntensity;
        double redIntensity;
        boolean is000;
        boolean is333;
        Random rand = new Random();
        int luck = rand.nextInt(10);
        int luckR = rand.nextInt(10);
        int luckG = rand.nextInt(10);
        int luckB = rand.nextInt(10);
        int luckRR = rand.nextInt(10);
        int luckGG = rand.nextInt(10);
        int luckBB = rand.nextInt(10);
        boolean bl = r1 + g1 + b1 == 9 || r2 + g2 + b2 == 9 ? luck >= 5 : (is333 = false);
        boolean bl2 = r1 + g1 + b1 == 0 || r2 + g2 + b2 == 0 ? luck >= 5 : (is000 = false);
        double d = is333 || is000 ? (double)(r1 + g1 + b1 == 9 || r1 + g1 + b1 == 0 ? r2 / 3 : r1 / 3) : (redIntensity = (double)(r1 == 0 || r2 == 0 ? (r1 >= r2 && !is333 ? r1 / 3 : r2 / 3) : (r1 + r2) / 6));
        double d2 = is333 || is000 ? (double)(r1 + g1 + b1 == 9 || r1 + g1 + b1 == 0 ? g2 / 3 : g1 / 3) : (greenIntensity = (double)(g1 == 0 || g2 == 0 ? (g1 >= g2 && !is333 ? g1 / 3 : g2 / 3) : (g1 + g2) / 6));
        double blueIntensity = is333 || is000 ? (double)(r1 + g1 + b1 == 9 || r1 + g1 + b1 == 0 ? b2 / 3 : b1 / 3) : (double)(b1 == 0 || b2 == 0 ? (b1 >= b2 && !is333 ? b1 / 3 : b2 / 3) : (b1 + b2) / 6);
        double totalIntensity = (double)(r1 + g1 + b1 + r2 + g2 + b2) / 18.0;
        int n = g1 == 3 && g2 == 3 || b1 == 3 && b2 == 3 ? (int)Math.round(redIntensity * 3.0 * totalIntensity + (luckRR >= 5 ? -0.1 : 0.1)) : (R = (int)Math.round(redIntensity * 3.0));
        int n2 = r1 == 3 && r2 == 3 || b1 == 3 && b2 == 3 ? (int)Math.round(greenIntensity * 3.0 * totalIntensity + (luckGG >= 5 ? -0.1 : 0.1)) : (G = (int)Math.round(greenIntensity * 3.0));
        int n3 = g1 == 3 && g2 == 3 || r1 == 3 && r2 == 3 ? (int)Math.round(blueIntensity * 3.0 * totalIntensity + (luckBB >= 5 ? -0.1 : 0.1)) : (B = (int)Math.round(blueIntensity * 3.0));
        int n4 = R > 3 ? 3 : (red = R < 0 ? 0 : (R += (is333 ? (luckR >= 5 ? 1 : 0) : 0) + (is000 ? (luckR >= 5 ? -1 : 0) : 0)));
        int n5 = G > 3 ? 3 : (green = G < 0 ? 0 : (G += (is333 ? (luckG >= 5 ? 1 : 0) : 0) + (is000 ? (luckG >= 5 ? -1 : 0) : 0)));
        int blue = B > 3 ? 3 : (B < 0 ? 0 : (B += (is333 ? (luckB >= 5 ? 1 : 0) : 0) + (is000 ? (luckB >= 5 ? -1 : 0) : 0)));
        return Arrays.asList(red, green, blue);
    }

    public static List<Integer> mixColorsList(int color1, int color2) {
        List<Integer> color1List = MowLibColorReference.getIntColor(color1);
        List<Integer> color2List = MowLibColorReference.getIntColor(color2);
        return MowLibColorReference.mixColorsList(color1List.get(0), color1List.get(1), color1List.get(2), color2List.get(0), color2List.get(1), color2List.get(2));
    }

    public static int mixColorsInt(int r1, int g1, int b1, int r2, int g2, int b2) {
        return MowLibColorReference.getColor(MowLibColorReference.mixColorsList(r1, g1, b1, r2, g2, b2));
    }

    public static int mixColorsInt(int color1, int color2) {
        List<Integer> color1List = MowLibColorReference.getIntColor(color1);
        List<Integer> color2List = MowLibColorReference.getIntColor(color2);
        List<Integer> colorOutput = MowLibColorReference.mixColorsList(color1List.get(0), color1List.get(1), color1List.get(2), color2List.get(0), color2List.get(1), color2List.get(2));
        return MowLibColorReference.getColor(colorOutput);
    }

    public static List<Integer> getTrueColorFromInt(int color) {
        int red = Math.floorDiv(color / 65536 % 256, 1);
        int green = Math.floorDiv(color / 256 % 256, 1);
        int blue = Math.floorDiv(color % 256, 1);
        return Arrays.asList(red, green, blue);
    }

    public static List<Integer> getColorFromDyeArray(ItemStack itemStack) {
        List WHITE_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/white"))).stream().toList();
        List ORANGE_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/orange"))).stream().toList();
        List MAGENTA_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/magenta"))).stream().toList();
        List LBLUE_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/light_blue"))).stream().toList();
        List YELLOW_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/yellow"))).stream().toList();
        List LIME_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/lime"))).stream().toList();
        List PINK_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/pink"))).stream().toList();
        List GRAY_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/gray"))).stream().toList();
        List LGRAY_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/light_gray"))).stream().toList();
        List CYAN_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/cyan"))).stream().toList();
        List PURPLE_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/purple"))).stream().toList();
        List BLUE_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/blue"))).stream().toList();
        List BROWN_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/brown"))).stream().toList();
        List GREEN_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/green"))).stream().toList();
        List RED_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/red"))).stream().toList();
        List BLACK_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/black"))).stream().toList();
        if (WHITE_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(3, 3, 3);
        }
        if (ORANGE_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(3, 2, 0);
        }
        if (MAGENTA_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(3, 1, 3);
        }
        if (LBLUE_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(0, 2, 3);
        }
        if (YELLOW_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(3, 3, 0);
        }
        if (LIME_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(1, 2, 0);
        }
        if (PINK_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(3, 1, 2);
        }
        if (GRAY_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(0, 0, 0);
        }
        if (LGRAY_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(2, 2, 2);
        }
        if (CYAN_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(0, 2, 2);
        }
        if (PURPLE_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(2, 0, 3);
        }
        if (BLUE_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(1, 1, 3);
        }
        if (BROWN_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(1, 1, 0);
        }
        if (GREEN_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(1, 2, 0);
        }
        if (RED_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(2, 0, 0);
        }
        if (BLACK_DYE.contains(itemStack.m_41720_())) {
            return Arrays.asList(0, 0, 0);
        }
        return Arrays.asList(3, 3, 3);
    }

    public static int getColorFromDyeInt(ItemStack itemStack) {
        List WHITE_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/white"))).stream().toList();
        List ORANGE_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/orange"))).stream().toList();
        List MAGENTA_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/magenta"))).stream().toList();
        List LBLUE_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/light_blue"))).stream().toList();
        List YELLOW_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/yellow"))).stream().toList();
        List LIME_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/lime"))).stream().toList();
        List PINK_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/pink"))).stream().toList();
        List GRAY_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/gray"))).stream().toList();
        List LGRAY_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/light_gray"))).stream().toList();
        List CYAN_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/cyan"))).stream().toList();
        List PURPLE_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/purple"))).stream().toList();
        List BLUE_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/blue"))).stream().toList();
        List BROWN_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/brown"))).stream().toList();
        List GREEN_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/green"))).stream().toList();
        List RED_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/red"))).stream().toList();
        List BLACK_DYE = ForgeRegistries.ITEMS.tags().getTag(ItemTags.create((ResourceLocation)new ResourceLocation("forge", "dyes/black"))).stream().toList();
        if (WHITE_DYE.contains(itemStack.m_41720_())) {
            return 0xFFFFFF;
        }
        if (ORANGE_DYE.contains(itemStack.m_41720_())) {
            return 0xFFAA00;
        }
        if (MAGENTA_DYE.contains(itemStack.m_41720_())) {
            return 0xFF55FF;
        }
        if (LBLUE_DYE.contains(itemStack.m_41720_())) {
            return 43775;
        }
        if (YELLOW_DYE.contains(itemStack.m_41720_())) {
            return 0xFFFF00;
        }
        if (LIME_DYE.contains(itemStack.m_41720_())) {
            return 0x55AA00;
        }
        if (PINK_DYE.contains(itemStack.m_41720_())) {
            return 0xFF55AA;
        }
        if (GRAY_DYE.contains(itemStack.m_41720_())) {
            return 0x2A2A2A;
        }
        if (LGRAY_DYE.contains(itemStack.m_41720_())) {
            return 0xAAAAAA;
        }
        if (CYAN_DYE.contains(itemStack.m_41720_())) {
            return 43690;
        }
        if (PURPLE_DYE.contains(itemStack.m_41720_())) {
            return 0xAA00FF;
        }
        if (BLUE_DYE.contains(itemStack.m_41720_())) {
            return 0x5555FF;
        }
        if (BROWN_DYE.contains(itemStack.m_41720_())) {
            return 0x555500;
        }
        if (GREEN_DYE.contains(itemStack.m_41720_())) {
            return 0x55AA00;
        }
        if (RED_DYE.contains(itemStack.m_41720_())) {
            return 0xAA0000;
        }
        if (BLACK_DYE.contains(itemStack.m_41720_())) {
            return 0x2A2A2A;
        }
        return 0xFFFFFF;
    }
}

