/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.MowLibUtils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class MowLibBlockPosUtils {
    public BlockPos getPosOfBlockBelow(Level level, BlockPos posOfPedestal, int numBelow) {
        BlockState state = level.m_8055_(posOfPedestal);
        Direction enumfacing = state.m_61138_((Property)BlockStateProperties.f_61372_) ? (Direction)state.m_61143_((Property)BlockStateProperties.f_61372_) : Direction.UP;
        BlockPos blockBelow = posOfPedestal;
        switch (enumfacing) {
            case UP: {
                return blockBelow.m_7918_(0, -numBelow, 0);
            }
            case DOWN: {
                return blockBelow.m_7918_(0, numBelow, 0);
            }
            case NORTH: {
                return blockBelow.m_7918_(0, 0, numBelow);
            }
            case SOUTH: {
                return blockBelow.m_7918_(0, 0, -numBelow);
            }
            case EAST: {
                return blockBelow.m_7918_(-numBelow, 0, 0);
            }
            case WEST: {
                return blockBelow.m_7918_(numBelow, 0, 0);
            }
        }
        return blockBelow;
    }

    public static boolean addBlockPosToList(String ModID, String identifier, ItemStack upgrade, BlockPos posOfBlock) {
        List<BlockPos> currentList = MowLibBlockPosUtils.readBlockPosListFromNBT(ModID, identifier, upgrade);
        if (currentList.contains(posOfBlock)) {
            currentList.remove(posOfBlock);
            MowLibBlockPosUtils.saveBlockPosListCustomToNBT(ModID, identifier, upgrade, currentList);
            return false;
        }
        currentList.add(posOfBlock);
        MowLibBlockPosUtils.saveBlockPosListCustomToNBT(ModID, identifier, upgrade, currentList);
        return true;
    }

    public static List<BlockPos> readBlockPosListFromNBT(String ModID, String identifier, ItemStack upgrade) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        if (upgrade.m_41782_()) {
            String tagX = ModID + identifier + "_X";
            String tagY = ModID + identifier + "_Y";
            String tagZ = ModID + identifier + "_Z";
            CompoundTag getCompound = upgrade.m_41783_();
            if (upgrade.m_41783_().m_128441_(tagX) && upgrade.m_41783_().m_128441_(tagY) && upgrade.m_41783_().m_128441_(tagZ)) {
                int[] storedIX = getCompound.m_128465_(tagX);
                int[] storedIY = getCompound.m_128465_(tagY);
                int[] storedIZ = getCompound.m_128465_(tagZ);
                for (int i = 0; i < storedIX.length; ++i) {
                    BlockPos gotPos = new BlockPos(storedIX[i], storedIY[i], storedIZ[i]);
                    posList.add(gotPos);
                }
            }
        }
        return posList;
    }

    public static void saveBlockPosListCustomToNBT(String ModID, String identifier, ItemStack upgrade, List<BlockPos> posListToSave) {
        CompoundTag compound = new CompoundTag();
        if (upgrade.m_41782_()) {
            compound = upgrade.m_41783_();
        }
        ArrayList<Integer> storedX = new ArrayList<Integer>();
        ArrayList<Integer> storedY = new ArrayList<Integer>();
        ArrayList<Integer> storedZ = new ArrayList<Integer>();
        for (int i = 0; i < posListToSave.size(); ++i) {
            storedX.add(posListToSave.get(i).m_123341_());
            storedY.add(posListToSave.get(i).m_123342_());
            storedZ.add(posListToSave.get(i).m_123343_());
        }
        compound.m_128408_(ModID + identifier + "_X", storedX);
        compound.m_128408_(ModID + identifier + "_Y", storedY);
        compound.m_128408_(ModID + identifier + "_Z", storedZ);
        upgrade.m_41751_(compound);
    }

    public static List<BlockPos> readBlockPosListCustomFromNBT(String ModID, String identifier, ItemStack upgrade) {
        ArrayList<BlockPos> posList = new ArrayList<BlockPos>();
        if (upgrade.m_41782_()) {
            String tagX = ModID + identifier + "_X";
            String tagY = ModID + identifier + "_Y";
            String tagZ = ModID + identifier + "_Z";
            CompoundTag getCompound = upgrade.m_41783_();
            if (upgrade.m_41783_().m_128441_(tagX) && upgrade.m_41783_().m_128441_(tagY) && upgrade.m_41783_().m_128441_(tagZ)) {
                int[] storedIX = getCompound.m_128465_(tagX);
                int[] storedIY = getCompound.m_128465_(tagY);
                int[] storedIZ = getCompound.m_128465_(tagZ);
                for (int i = 0; i < storedIX.length; ++i) {
                    BlockPos gotPos = new BlockPos(storedIX[i], storedIY[i], storedIZ[i]);
                    posList.add(gotPos);
                }
            }
        }
        return posList;
    }

    public void removeBlockListCustomNBTTags(String ModID, String identifier, ItemStack upgrade) {
        String tagX = ModID + identifier + "_X";
        String tagY = ModID + identifier + "_Y";
        String tagZ = ModID + identifier + "_Z";
        CompoundTag getTags = upgrade.m_41783_();
        if (getTags.m_128441_(tagX)) {
            getTags.m_128473_(tagX);
        }
        if (getTags.m_128441_(tagY)) {
            getTags.m_128473_(tagY);
        }
        if (getTags.m_128441_(tagZ)) {
            getTags.m_128473_(tagZ);
        }
        upgrade.m_41751_(getTags);
    }

    public boolean hasBlockListCustomNBTTags(String ModID, String identifier, ItemStack upgrade) {
        String tagX = ModID + identifier + "_X";
        String tagY = ModID + identifier + "_Y";
        String tagZ = ModID + identifier + "_Z";
        CompoundTag getTags = upgrade.m_41783_();
        return getTags.m_128441_(tagX) && getTags.m_128441_(tagY) && getTags.m_128441_(tagZ);
    }

    public static void saveBlockPosToNBT(String ModID, String identifier, ItemStack upgrade, int num, BlockPos posToSave) {
        CompoundTag compound = new CompoundTag();
        if (upgrade.m_41782_()) {
            compound = upgrade.m_41783_();
        }
        ArrayList<Integer> listed = new ArrayList<Integer>();
        listed.add(posToSave.m_123341_());
        listed.add(posToSave.m_123342_());
        listed.add(posToSave.m_123343_());
        compound.m_128408_(ModID + identifier + num, listed);
        upgrade.m_41751_(compound);
    }

    public static BlockPos readBlockPosFromNBT(String ModID, String identifier, ItemStack upgrade, int num) {
        if (upgrade.m_41782_()) {
            int[] listed;
            String tag = ModID + identifier + num;
            CompoundTag getCompound = upgrade.m_41783_();
            if (upgrade.m_41783_().m_128441_(tag) && (listed = getCompound.m_128465_(tag)).length >= 3) {
                return new BlockPos(listed[0], listed[1], listed[2]);
            }
        }
        return BlockPos.f_121853_;
    }

    public static BlockPos getBlockPosOnUpgrade(String ModID, String identifier, ItemStack stack, int num) {
        return MowLibBlockPosUtils.readBlockPosFromNBT(ModID, identifier, stack, num);
    }
}

