/*
 * Decompiled with CFR 0.152.
 */
package com.mowmaster.mowlib.BlockEntities;

import com.google.common.collect.Maps;
import com.mowmaster.mowlib.BlockEntities.BaseBuiltMachineBlockEntity;
import com.mowmaster.mowlib.BlockEntities.MowLibBaseBlock;
import com.mowmaster.mowlib.Items.BaseRepairNote;
import com.mowmaster.mowlib.Items.ColorApplicator;
import com.mowmaster.mowlib.MowLibUtils.MowLibColorReference;
import com.mowmaster.mowlib.MowLibUtils.MowLibContainerUtils;
import com.mowmaster.mowlib.MowLibUtils.MowLibMessageUtils;
import com.mowmaster.mowlib.Recipes.MachineBlockRepairItemsHintRecipe;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

public class BaseBuiltMachineBlock
extends MowLibBaseBlock {
    public BaseBuiltMachineBlock(BlockBehaviour.Properties p_152915_) {
        super(p_152915_);
        this.m_49959_(MowLibColorReference.addColorToBlockState(this.m_49966_(), 0xFFFFFF));
    }

    @Nullable
    public MachineBlockRepairItemsHintRecipe getRecipe(Level level, ItemStack stackIn) {
        Container cont = MowLibContainerUtils.getContainer(1);
        cont.m_6836_(-1, stackIn);
        List recipes = level.m_7465_().m_44056_((RecipeType)MachineBlockRepairItemsHintRecipe.Type.INSTANCE, cont, level);
        return recipes.size() > 0 ? (MachineBlockRepairItemsHintRecipe)level.m_7465_().m_44056_((RecipeType)MachineBlockRepairItemsHintRecipe.Type.INSTANCE, cont, level).get(0) : null;
    }

    public String getProcessResultTitle(MachineBlockRepairItemsHintRecipe recipe) {
        return recipe == null ? "" : recipe.getResultTitle();
    }

    public String getProcessResultDescription(MachineBlockRepairItemsHintRecipe recipe) {
        return recipe == null ? "" : recipe.getResultDescription();
    }

    public boolean getProcessResultIsLocalized(MachineBlockRepairItemsHintRecipe recipe) {
        return recipe == null ? false : recipe.getResultLocalized();
    }

    @Override
    public InteractionResult m_6227_(BlockState p_60503_, Level p_60504_, BlockPos p_60505_, Player p_60506_, InteractionHand p_60507_, BlockHitResult p_60508_) {
        if (!p_60504_.m_5776_()) {
            BaseBuiltMachineBlockEntity table;
            ItemStack itemInHand = p_60506_.m_21120_(p_60507_);
            ItemStack itemInMainHand = p_60506_.m_21205_();
            ItemStack itemInOffHand = p_60506_.m_21206_();
            if (itemInMainHand.m_41720_() instanceof ColorApplicator) {
                int getColor = MowLibColorReference.getColorFromItemStackInt(itemInMainHand);
                BlockState newState = MowLibColorReference.addColorToBlockState(p_60503_, getColor);
                p_60504_.m_7731_(p_60505_, newState, 3);
                return InteractionResult.SUCCESS;
            }
            if (itemInOffHand.m_41720_() instanceof ColorApplicator) {
                int getColor = MowLibColorReference.getColorFromItemStackInt(itemInOffHand);
                BlockState newState = MowLibColorReference.addColorToBlockState(p_60503_, getColor);
                p_60504_.m_7731_(p_60505_, newState, 3);
                return InteractionResult.SUCCESS;
            }
            BlockEntity getColor = p_60504_.m_7702_(p_60505_);
            if (getColor instanceof BaseBuiltMachineBlockEntity && !(table = (BaseBuiltMachineBlockEntity)getColor).isFullyRepaired()) {
                Item newState = itemInMainHand.m_41720_();
                if (newState instanceof BaseRepairNote) {
                    BaseRepairNote scroll = (BaseRepairNote)newState;
                    scroll.setMachineBlock(itemInMainHand, this);
                    scroll.setRepairItem(itemInMainHand, table.getNextRepairItem());
                    if (!scroll.getRepairItem(itemInMainHand).m_41619_()) {
                        ItemStack repairItemOnScroll = scroll.getRepairItem(itemInMainHand);
                        MachineBlockRepairItemsHintRecipe recipe = this.getRecipe(p_60504_, repairItemOnScroll);
                        String title = this.getProcessResultTitle(recipe);
                        String description = this.getProcessResultDescription(recipe);
                        boolean isLocalized = this.getProcessResultIsLocalized(recipe);
                        scroll.setHintTitle(itemInMainHand, title);
                        scroll.setHintDescription(itemInMainHand, description);
                        scroll.setHintLocalization(itemInMainHand, isLocalized);
                        if (scroll.getItemFound(itemInMainHand)) {
                            scroll.setItemFound(itemInMainHand, false);
                        }
                        MowLibMessageUtils.messagePopup(p_60506_, ChatFormatting.GOLD, "mowlib.hint.scroll_made");
                    }
                    return InteractionResult.SUCCESS;
                }
                if (table.isValidItem(itemInMainHand) && table.addRepairItem(p_60506_, itemInMainHand, false)) {
                    itemInMainHand.m_41774_(1);
                    Inventory inv = p_60506_.m_150109_();
                    ItemStack itemFound = ItemStack.f_41583_;
                    itemFound = IntStream.range(0, inv.m_6643_()).mapToObj(arg_0 -> ((Inventory)inv).m_8020_(arg_0)).filter(itemStack -> itemStack.m_41720_() instanceof BaseRepairNote).findFirst().orElse(ItemStack.f_41583_);
                    if (!itemFound.m_41619_()) {
                        for (int i = 0; i < inv.m_6643_(); ++i) {
                            if (!inv.m_8020_(i).m_41720_().equals(itemFound.m_41720_())) continue;
                            ItemStack stackie = inv.m_8020_(i);
                            BaseRepairNote scroll = (BaseRepairNote)stackie.m_41720_();
                            scroll.setMachineBlock(stackie, Blocks.f_50016_);
                            scroll.setRepairItem(stackie, ItemStack.f_41583_);
                            scroll.setHintTitle(stackie, "");
                            scroll.setHintDescription(stackie, "");
                            scroll.setHintLocalization(stackie, false);
                            LinkedHashMap enchantsNone = Maps.newLinkedHashMap();
                            EnchantmentHelper.m_44865_((Map)enchantsNone, (ItemStack)stackie);
                            inv.m_6836_(i, stackie);
                            break;
                        }
                    }
                    if (table.isFullyRepaired()) {
                        MowLibMessageUtils.messagePopup(p_60506_, ChatFormatting.GREEN, "mowlib.hint.repair_finished");
                    } else {
                        MowLibMessageUtils.messagePopup(p_60506_, ChatFormatting.GOLD, "mowlib.hint.repair_made");
                    }
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState p_60515_, Level p_60516_, BlockPos p_60517_, BlockState p_60518_, boolean p_60519_) {
        if (p_60515_.m_60734_() != p_60518_.m_60734_()) {
            BlockEntity blockEntity = p_60516_.m_7702_(p_60517_);
            if (blockEntity instanceof BaseBuiltMachineBlockEntity) {
                BaseBuiltMachineBlockEntity t1blockentity = (BaseBuiltMachineBlockEntity)blockEntity;
                t1blockentity.dropInventoryItems(p_60516_, p_60517_);
            }
            super.m_6810_(p_60515_, p_60516_, p_60517_, p_60518_, p_60519_);
        }
    }

    @Override
    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return null;
    }
}

