/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.tiles;

import dev.architectury.injectables.annotations.PlatformOnly;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluid;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidRegistry;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.supplementaries.common.block.blocks.FaucetBlock;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetBlockTarget;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetFluidSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetItemSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetTileSource;
import net.mehvahdjukaar.supplementaries.common.block.faucet.IFaucetTileTarget;
import net.mehvahdjukaar.supplementaries.common.utils.ItemsUtil;
import net.mehvahdjukaar.supplementaries.reg.ModRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FaucetBlockTile
extends BlockEntity {
    private static final List<IFaucetBlockSource> BLOCK_INTERACTIONS = new ArrayList<IFaucetBlockSource>();
    private static final List<IFaucetTileSource> TILE_INTERACTIONS = new ArrayList<IFaucetTileSource>();
    private static final List<IFaucetFluidSource> FLUID_INTERACTIONS = new ArrayList<IFaucetFluidSource>();
    private static final List<IFaucetItemSource> ITEM_INTERACTIONS = new ArrayList<IFaucetItemSource>();
    private static final List<IFaucetBlockTarget> TARGET_BLOCK_INTERACTIONS = new ArrayList<IFaucetBlockTarget>();
    private static final List<IFaucetTileTarget> TARGET_TILE_INTERACTIONS = new ArrayList<IFaucetTileTarget>();
    public static final int COOLDOWN = 20;
    private int transferCooldown = 0;
    public final SoftFluidTank tempFluidHolder = SoftFluidTank.create((int)5);

    public FaucetBlockTile(BlockPos pos, BlockState state) {
        super(ModRegistry.FAUCET_TILE.get(), pos, state);
    }

    public void updateLight() {
        if (this.f_58857_ == null) {
            return;
        }
        int light = this.tempFluidHolder.getFluid().getLuminosity();
        if (light != 0) {
            light = (int)Mth.m_14036_((float)((float)light / 2.0f), (float)1.0f, (float)7.0f);
        }
        if (light != (Integer)this.m_58900_().m_61143_((Property)FaucetBlock.LIGHT_LEVEL)) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)this.m_58900_().m_61124_((Property)FaucetBlock.LIGHT_LEVEL, (Comparable)Integer.valueOf(light)), 2);
        }
    }

    @PlatformOnly(value={"forge"})
    public AABB getRenderBoundingBox() {
        return new AABB(this.m_58899_().m_7918_(0, -1, 0), this.m_58899_().m_7918_(1, 1, 1));
    }

    public static void tick(Level pLevel, BlockPos pPos, BlockState pState, FaucetBlockTile tile) {
        if (tile.transferCooldown > 0) {
            --tile.transferCooldown;
        } else if (tile.isOpen()) {
            int cooldown = tile.tryExtract(pLevel, pPos, pState, true);
            tile.transferCooldown += cooldown;
        }
    }

    public boolean updateContainedFluidVisuals(Level level, BlockPos pos, BlockState state) {
        FluidState fluidState = level.m_6425_(pos.m_121945_(((Direction)state.m_61143_((Property)FaucetBlock.FACING)).m_122424_()));
        if (!fluidState.m_76178_() && fluidState.m_76170_()) {
            SoftFluid f = SoftFluidRegistry.fromForgeFluid((Fluid)fluidState.m_76152_());
            if (f != null) {
                this.tempFluidHolder.fill(f);
                this.updateLight();
                return true;
            }
            boolean bl = true;
        }
        boolean r = this.tryExtract(level, pos, state, false) != 0;
        this.updateLight();
        return r;
    }

    private int tryExtract(Level level, BlockPos pos, BlockState state, boolean doTransfer) {
        BlockEntity tileBack;
        Direction dir = (Direction)state.m_61143_((Property)FaucetBlock.FACING);
        BlockPos behind = pos.m_121945_(dir.m_122424_());
        BlockState backState = level.m_8055_(behind);
        this.tempFluidHolder.clear();
        if (backState.m_60795_()) {
            return 0;
        }
        FillAction fillAction = doTransfer ? this::tryFillingBlockBelow : null;
        for (IFaucetBlockSource iFaucetBlockSource : BLOCK_INTERACTIONS) {
            InteractionResult res = iFaucetBlockSource.tryDrain(level, this.tempFluidHolder, behind, backState, fillAction);
            if (res == InteractionResult.PASS) continue;
            if (res == InteractionResult.SUCCESS) {
                return iFaucetBlockSource.getTransferCooldown();
            }
            if (res == InteractionResult.CONSUME) break;
            if (res != InteractionResult.FAIL) continue;
            return 0;
        }
        if (!this.isConnectedBelow()) {
            for (IFaucetItemSource iFaucetItemSource : ITEM_INTERACTIONS) {
                ItemStack removed = iFaucetItemSource.tryExtractItem(level, behind, backState);
                if (removed.m_41619_()) continue;
                FaucetBlockTile.drop(level, pos, removed);
                return 20;
            }
        }
        if ((tileBack = level.m_7702_(behind)) != null) {
            for (IFaucetTileSource bi : TILE_INTERACTIONS) {
                InteractionResult res = bi.tryDrain(level, this.tempFluidHolder, behind, tileBack, dir, fillAction);
                if (res == InteractionResult.PASS) continue;
                if (res == InteractionResult.SUCCESS) {
                    return bi.getTransferCooldown();
                }
                if (res == InteractionResult.CONSUME) break;
                if (res != InteractionResult.FAIL) continue;
                return 0;
            }
            if (!doTransfer) {
                return !this.tempFluidHolder.isEmpty() ? 20 : 0;
            }
            return this.spillItemsFromInventory(level, pos, dir, tileBack);
        }
        FluidState fluidState = level.m_6425_(behind);
        for (IFaucetFluidSource bi : FLUID_INTERACTIONS) {
            InteractionResult res = bi.tryDrain(level, this.tempFluidHolder, behind, fluidState, fillAction);
            if (res == InteractionResult.PASS) continue;
            if (res == InteractionResult.SUCCESS) {
                return bi.getTransferCooldown();
            }
            if (res == InteractionResult.CONSUME) break;
            if (res != InteractionResult.FAIL) continue;
            return 0;
        }
        if (!doTransfer) {
            return !this.tempFluidHolder.isEmpty() ? 20 : 0;
        }
        return 0;
    }

    private boolean tryFillingBlockBelow() {
        BlockEntity tileBelow;
        SoftFluid softFluid = this.tempFluidHolder.getFluid();
        if (softFluid.isEmpty()) {
            return false;
        }
        BlockPos below = this.f_58858_.m_7495_();
        BlockState belowState = this.f_58857_.m_8055_(below);
        for (IFaucetBlockTarget bi : TARGET_BLOCK_INTERACTIONS) {
            InteractionResult res = bi.tryFill(this.f_58857_, this.tempFluidHolder, below, belowState);
            if (res == InteractionResult.PASS) continue;
            if (res == InteractionResult.SUCCESS) {
                return true;
            }
            if (res == InteractionResult.CONSUME) break;
            if (res != InteractionResult.FAIL) continue;
            return false;
        }
        if ((tileBelow = this.f_58857_.m_7702_(below)) != null) {
            for (IFaucetTileTarget bi : TARGET_TILE_INTERACTIONS) {
                InteractionResult res = bi.tryFill(this.f_58857_, this.tempFluidHolder, below, tileBelow);
                if (res == InteractionResult.PASS) continue;
                if (res == InteractionResult.SUCCESS) {
                    return true;
                }
                if (res == InteractionResult.CONSUME) break;
                if (res != InteractionResult.FAIL) continue;
                return false;
            }
        }
        return false;
    }

    public boolean isOpen() {
        return (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61448_) ^ (Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61431_);
    }

    public boolean hasWater() {
        return (Boolean)this.m_58900_().m_61143_((Property)FaucetBlock.HAS_WATER);
    }

    public boolean isConnectedBelow() {
        return (Boolean)this.m_58900_().m_61143_((Property)FaucetBlock.HAS_JAR);
    }

    public int spillItemsFromInventory(Level level, BlockPos pos, Direction dir, BlockEntity tile) {
        ItemStack removed;
        if (!this.isConnectedBelow() && (removed = ItemsUtil.removeFirstStackFromInventory(level, pos, dir, tile)) != ItemStack.f_41583_) {
            FaucetBlockTile.drop(level, pos, removed);
            return 20;
        }
        return 0;
    }

    private static void drop(Level level, BlockPos pos, ItemStack extracted) {
        ItemEntity drop = new ItemEntity(level, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, extracted);
        drop.m_20256_(new Vec3(0.0, 0.0, 0.0));
        level.m_7967_((Entity)drop);
        float f = (level.f_46441_.m_188501_() - 0.5f) / 4.0f;
        level.m_5594_(null, pos, SoundEvents.f_11752_, SoundSource.BLOCKS, 0.3f, 0.5f + f);
    }

    public void m_142466_(CompoundTag compound) {
        super.m_142466_(compound);
        this.transferCooldown = compound.m_128451_("TransferCooldown");
        this.tempFluidHolder.load(compound);
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        tag.m_128405_("TransferCooldown", this.transferCooldown);
        this.tempFluidHolder.save(tag);
    }

    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public static void registerInteraction(Object interaction) {
        Object bs;
        boolean success = false;
        if (interaction instanceof IFaucetBlockSource) {
            bs = (IFaucetBlockSource)interaction;
            BLOCK_INTERACTIONS.add((IFaucetBlockSource)bs);
            success = true;
        }
        if (interaction instanceof IFaucetTileSource) {
            IFaucetTileSource ts = (IFaucetTileSource)interaction;
            TILE_INTERACTIONS.add(ts);
            success = true;
        }
        if (interaction instanceof IFaucetFluidSource) {
            bs = (IFaucetFluidSource)interaction;
            FLUID_INTERACTIONS.add((IFaucetFluidSource)bs);
            success = true;
        }
        if (interaction instanceof IFaucetBlockTarget) {
            IFaucetBlockTarget tb = (IFaucetBlockTarget)interaction;
            TARGET_BLOCK_INTERACTIONS.add(tb);
            success = true;
        }
        if (interaction instanceof IFaucetTileTarget) {
            IFaucetTileTarget tt = (IFaucetTileTarget)interaction;
            TARGET_TILE_INTERACTIONS.add(tt);
            success = true;
        }
        if (interaction instanceof IFaucetItemSource) {
            IFaucetItemSource is = (IFaucetItemSource)interaction;
            ITEM_INTERACTIONS.add(is);
            success = true;
        }
        if (!success) {
            throw new UnsupportedOperationException("Unsupported faucet interaction class: " + interaction.getClass().getSimpleName());
        }
    }

    public static <T> void removeDataInteractions(Collection<T> interactions) {
        for (T v : interactions) {
            if (v instanceof IFaucetBlockSource) {
                IFaucetBlockSource fs = (IFaucetBlockSource)v;
                BLOCK_INTERACTIONS.remove(fs);
                continue;
            }
            if (!(v instanceof IFaucetItemSource)) continue;
            IFaucetItemSource fs = (IFaucetItemSource)v;
            ITEM_INTERACTIONS.remove(fs);
        }
    }

    @FunctionalInterface
    public static interface FillAction {
        public boolean tryExecute();
    }
}

