/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.block.hourglass;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class HourglassTimeData {
    public static final HourglassTimeData EMPTY = new HourglassTimeData((HolderSet<Item>)HolderSet.m_205809_((Holder[])new Holder[0]), 0, 0, Optional.empty(), 99);
    public static final Codec<HourglassTimeData> REGISTRY_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)RegistryCodecs.m_206277_((ResourceKey)Registry.f_122904_).fieldOf("items").forGetter(p -> p.dusts), (App)ExtraCodecs.f_144629_.fieldOf("duration").forGetter(p -> p.duration), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(p -> p.light), (App)ResourceLocation.f_135803_.optionalFieldOf("texture").forGetter(p -> p.texture), (App)ExtraCodecs.f_144629_.optionalFieldOf("ordering", (Object)0).forGetter(p -> p.ordering)).apply((Applicative)instance, HourglassTimeData::new));
    public static final Codec<HourglassTimeData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.f_135803_.listOf().fieldOf("items").forGetter(p -> p.dusts.m_203614_().map(h -> ((ResourceKey)h.m_203543_().get()).m_135782_()).toList()), (App)ExtraCodecs.f_144629_.fieldOf("duration").forGetter(p -> p.duration), (App)Codec.intRange((int)0, (int)15).optionalFieldOf("light_level", (Object)0).forGetter(p -> p.light), (App)ResourceLocation.f_135803_.optionalFieldOf("texture").forGetter(p -> p.texture), (App)ExtraCodecs.f_144629_.optionalFieldOf("ordering", (Object)0).forGetter(p -> p.ordering)).apply((Applicative)instance, HourglassTimeData::createSafe));
    private final HolderSet<Item> dusts;
    private final int duration;
    private final int light;
    private final Optional<ResourceLocation> texture;
    private final int ordering;

    private static HourglassTimeData createSafe(List<ResourceLocation> dusts, int dur, int light, Optional<ResourceLocation> texture, int order) {
        ArrayList holders = new ArrayList();
        dusts.forEach(r -> Registry.f_122827_.m_203636_(ResourceKey.m_135785_((ResourceKey)Registry.f_122904_, (ResourceLocation)r)).ifPresent(holders::add));
        return new HourglassTimeData((HolderSet<Item>)HolderSet.m_205800_(holders), dur, light, texture, order);
    }

    public HourglassTimeData(HolderSet<Item> owner, int duration, int light, Optional<ResourceLocation> texture, int priority) {
        this.dusts = owner;
        this.duration = duration;
        this.light = light;
        this.texture = texture;
        this.ordering = priority;
    }

    @OnlyIn(value=Dist.CLIENT)
    public TextureAtlasSprite computeSprite(ItemStack i, Level world) {
        Minecraft mc = Minecraft.m_91087_();
        if (this.texture.isEmpty()) {
            ItemRenderer itemRenderer = mc.m_91291_();
            BakedModel model = itemRenderer.m_174264_(i, world, null, 0);
            return model.m_6160_();
        }
        return (TextureAtlasSprite)mc.m_91258_(TextureAtlas.f_118259_).apply(this.texture.get());
    }

    public Stream<Holder<Item>> getItems() {
        return this.dusts.m_203614_();
    }

    public int getLight() {
        return this.light;
    }

    public int getOrdering() {
        return this.ordering;
    }

    public boolean isEmpty() {
        return this == EMPTY;
    }

    public float getIncrement() {
        return 1.0f / (float)this.duration;
    }
}

