/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.detail;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.redstonepen.blocks.RedstoneTrack;
import wile.redstonepen.libmc.Auxiliaries;

public class ModRenderers {

    @OnlyIn(value=Dist.CLIENT)
    public static class TrackTer
    implements BlockEntityRenderer<RedstoneTrack.TrackBlockEntity> {
        private static final ModelResourceLocation[] model_rls = new ModelResourceLocation[24];
        private static final ModelResourceLocation[] modelm_rls = new ModelResourceLocation[6];
        private static final ModelResourceLocation[] modelc_rls = new ModelResourceLocation[6];
        private static final ArrayList<Vec3> power_rgb = new ArrayList();
        private static int tesr_error_counter = 4;
        private final BlockEntityRendererProvider.Context renderer_;

        public static List<ModelResourceLocation> registerModels() {
            ArrayList<ModelResourceLocation> resources_to_register = new ArrayList<ModelResourceLocation>();
            RedstoneTrack.defs.models.STATE_WIRE_MAPPING.entrySet().forEach(kv -> {
                ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation("redstonepen", (String)kv.getValue()), "inventory");
                for (int i = 0; i < 24; ++i) {
                    if (((Long)kv.getKey() & 1L << 0 + i) == 0L) continue;
                    TrackTer.model_rls[i] = mrl;
                    break;
                }
                resources_to_register.add(mrl);
            });
            RedstoneTrack.defs.models.STATE_CONNECT_MAPPING.entrySet().forEach(kv -> {
                ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation("redstonepen", (String)kv.getValue()), "inventory");
                for (int i = 0; i < 6; ++i) {
                    if (((Long)kv.getKey() & 1L << 24 + i) == 0L) continue;
                    TrackTer.modelc_rls[i] = mrl;
                    break;
                }
                resources_to_register.add(mrl);
            });
            RedstoneTrack.defs.models.STATE_CNTWIRE_MAPPING.entrySet().forEach(kv -> {
                ModelResourceLocation mrl = new ModelResourceLocation(new ResourceLocation("redstonepen", (String)kv.getValue()), "inventory");
                for (int i = 0; i < 6; ++i) {
                    if (((Long)kv.getKey() & 1L << 24 + i) == 0L) continue;
                    TrackTer.modelm_rls[i] = mrl;
                    break;
                }
                resources_to_register.add(mrl);
            });
            power_rgb.clear();
            for (int i = 0; i <= 15; ++i) {
                float f;
                power_rgb.add(new Vec3((double)Mth.m_14036_((float)(f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f)), (float)0.0f, (float)1.0f), (double)Mth.m_14036_((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f), (double)Mth.m_14036_((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f)));
            }
            return resources_to_register;
        }

        private static Vec3 getPowerRGB(int p) {
            return power_rgb.get(p & 0xF);
        }

        public TrackTer(BlockEntityRendererProvider.Context renderer) {
            this.renderer_ = renderer;
        }

        public void render(RedstoneTrack.TrackBlockEntity te, float unused1, PoseStack mxs, MultiBufferSource buf, int combinedLightIn, int combinedOverlayIn) {
            block7: {
                if (tesr_error_counter <= 0) {
                    return;
                }
                try {
                    BlockState block_state = te.m_58900_();
                    VertexConsumer vxb = buf.m_6299_(ItemBlockRenderTypes.m_109284_((BlockState)block_state, (boolean)false));
                    combinedOverlayIn = OverlayTexture.m_118093_((int)0, (int)0);
                    mxs.m_85836_();
                    int wirfl = te.getWireFlags();
                    int wirfc = te.getWireFlagCount();
                    long flag = 1L;
                    int i = 0;
                    while (i < wirfc) {
                        if (((long)wirfl & flag) != 0L) {
                            Vec3 rgb = TrackTer.getPowerRGB(te.getSidePower(RedstoneTrack.defs.connections.CONNECTION_BIT_ORDER[i / 4]));
                            BakedModel model = Minecraft.m_91087_().m_91304_().m_119422_(model_rls[i]);
                            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(mxs.m_85850_(), vxb, null, model, (float)rgb.m_7096_(), (float)rgb.m_7098_(), (float)rgb.m_7094_(), combinedLightIn, combinedOverlayIn);
                        }
                        ++i;
                        flag <<= 1;
                    }
                    wirfl = te.getWireFlags();
                    int confl = te.getConnectionFlags();
                    int confc = te.getConnectionFlagCount();
                    long wir = 15L;
                    long con = 1L;
                    int i2 = 0;
                    while (i2 < confc) {
                        if (((long)wirfl & wir) != 0L || ((long)confl & con) != 0L) {
                            Vec3 rgb = TrackTer.getPowerRGB(te.getSidePower(RedstoneTrack.defs.connections.CONNECTION_BIT_ORDER[i2]));
                            BakedModel model = ((long)confl & con) == 0L ? Minecraft.m_91087_().m_91304_().m_119422_(modelm_rls[i2]) : Minecraft.m_91087_().m_91304_().m_119422_(modelc_rls[i2]);
                            Minecraft.m_91087_().m_91289_().m_110937_().m_111067_(mxs.m_85850_(), vxb, null, model, (float)rgb.m_7096_(), (float)rgb.m_7098_(), (float)rgb.m_7094_(), combinedLightIn, combinedOverlayIn);
                        }
                        ++i2;
                        con <<= 1;
                        wir <<= 4;
                    }
                    mxs.m_85849_();
                }
                catch (Throwable e) {
                    if (--tesr_error_counter > 0) break block7;
                    Auxiliaries.logError("TER was disabled because broken, exception was: " + e.getMessage());
                    Auxiliaries.logError(String.join((CharSequence)"\n", Arrays.stream(e.getStackTrace()).map(StackTraceElement::toString).toList()));
                }
            }
        }
    }
}

