/*
 * Decompiled with CFR 0.152.
 */
package wile.redstonepen.blocks;

import com.google.common.collect.ImmutableMap;
import com.mojang.math.Vector3f;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.util.Tuple;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.piston.MovingPistonBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import wile.redstonepen.ModContent;
import wile.redstonepen.items.RedstonePenItem;
import wile.redstonepen.libmc.Auxiliaries;
import wile.redstonepen.libmc.Networking;
import wile.redstonepen.libmc.StandardBlocks;

public class RedstoneTrack {

    public static class TrackBlockEntity
    extends BlockEntity
    implements Networking.IPacketTileNotifyReceiver {
        private long state_flags_ = 0L;
        private final List<TrackNet> nets_ = new ArrayList<TrackNet>();
        private final Block[] block_change_tracking_ = new Block[]{Blocks.f_50016_, Blocks.f_50016_, Blocks.f_50016_, Blocks.f_50016_, Blocks.f_50016_, Blocks.f_50016_};
        private boolean trace_ = false;
        private static final List<Vec3i> updatepower_order = new ArrayList<Vec3i>();

        public TrackBlockEntity(BlockPos pos, BlockState state) {
            super(ModContent.getBlockEntityTypeOfBlock(state.m_60734_()), pos, state);
        }

        public CompoundTag readnbt(CompoundTag nbt) {
            this.state_flags_ = nbt.m_128454_("sflags");
            this.nets_.clear();
            if (nbt.m_128425_("nets", 9)) {
                ListTag lst = nbt.m_128437_("nets", 10);
                try {
                    for (int i = 0; i < lst.size(); ++i) {
                        CompoundTag route_nbt = lst.m_128728_(i);
                        this.nets_.add(new TrackNet(Arrays.stream(route_nbt.m_128467_("npos")).mapToObj(BlockPos::m_122022_).collect(Collectors.toList()), Arrays.stream(route_nbt.m_128465_("nsid")).mapToObj(Direction::m_122376_).collect(Collectors.toList()), Arrays.stream(route_nbt.m_128465_("ifac")).mapToObj(Direction::m_122376_).collect(Collectors.toList()), Arrays.stream(route_nbt.m_128465_("pfac")).mapToObj(Direction::m_122376_).collect(Collectors.toList()), route_nbt.m_128451_("power")));
                    }
                }
                catch (Throwable ex) {
                    this.nets_.clear();
                    Auxiliaries.logError("Dropped invalid NBT for Redstone Track at pos " + this.m_58899_());
                }
            }
            return nbt;
        }

        private CompoundTag writenbt(CompoundTag nbt) {
            return this.writenbt(nbt, false);
        }

        private CompoundTag writenbt(CompoundTag nbt, boolean sync_packet) {
            nbt.m_128356_("sflags", this.state_flags_);
            if (sync_packet) {
                return nbt;
            }
            if (!this.nets_.isEmpty()) {
                ListTag lst = new ListTag();
                for (TrackNet net : this.nets_) {
                    CompoundTag route_nbt = new CompoundTag();
                    route_nbt.m_128405_("power", net.power);
                    route_nbt.m_128365_("npos", (Tag)new LongArrayTag(net.neighbour_positions.stream().map(BlockPos::m_121878_).collect(Collectors.toList())));
                    route_nbt.m_128365_("nsid", (Tag)new IntArrayTag(net.neighbour_sides.stream().map(Direction::m_122411_).collect(Collectors.toList())));
                    route_nbt.m_128365_("ifac", (Tag)new IntArrayTag(net.internal_sides.stream().map(Direction::m_122411_).collect(Collectors.toList())));
                    route_nbt.m_128365_("pfac", (Tag)new IntArrayTag(net.power_sides.stream().map(Direction::m_122411_).collect(Collectors.toList())));
                    lst.add((Object)route_nbt);
                }
                nbt.m_128365_("nets", (Tag)lst);
            }
            return nbt;
        }

        public void m_142466_(CompoundTag nbt) {
            super.m_142466_(nbt);
            this.readnbt(nbt);
        }

        protected void m_183515_(CompoundTag nbt) {
            super.m_183515_(nbt);
            this.writenbt(nbt);
        }

        public CompoundTag m_5995_() {
            CompoundTag nbt = super.m_5995_();
            this.writenbt(nbt, true);
            return nbt;
        }

        @Nullable
        public ClientboundBlockEntityDataPacket getUpdatePacket() {
            return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
        }

        public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
            super.onDataPacket(net, pkt);
            this.readnbt(pkt.m_131708_());
        }

        @Override
        public void onServerPacketReceived(CompoundTag nbt) {
            this.readnbt(nbt);
        }

        @OnlyIn(value=Dist.CLIENT)
        public double getViewDistance() {
            return 64.0;
        }

        public boolean sync(boolean schedule) {
            if (this.f_58857_.m_5776_()) {
                return true;
            }
            this.m_6596_();
            if (schedule && !this.m_58904_().m_183326_().m_183582_(this.m_58899_(), (Object)ModContent.references.TRACK_BLOCK)) {
                this.m_58904_().m_186460_(this.m_58899_(), (Block)ModContent.references.TRACK_BLOCK, 1);
            } else {
                Networking.PacketTileNotifyServerToClient.sendToPlayers(this, this.writenbt(new CompoundTag(), true));
            }
            return true;
        }

        public long getStateFlags() {
            return this.state_flags_;
        }

        public int addWireFlags(long flags) {
            int n_added = 0;
            for (int i = 0; i < this.getWireFlagCount(); ++i) {
                long mask = 1L << i;
                if ((flags & mask) == 0L || (this.state_flags_ & mask) != 0L) continue;
                this.state_flags_ |= mask;
                ++n_added;
            }
            return n_added;
        }

        public int getWireFlags() {
            return (int)((this.state_flags_ & 0xFFFFFFL) >> 0);
        }

        public boolean getWireFlag(int index) {
            return (this.state_flags_ & 1L << 0 + index) != 0L;
        }

        public int getWireFlagCount() {
            return 24;
        }

        public int getConnectionFlags() {
            return (int)((this.state_flags_ & 0x3F000000L) >> 24);
        }

        public boolean getConnectionFlag(int index) {
            return (this.state_flags_ & 1L << 24 + index) != 0L;
        }

        public int getConnectionFlagCount() {
            return 6;
        }

        public int getSidePower(Direction side) {
            int shift = 32 + 4 * (Integer)defs.connections.CONNECTION_BIT_ORDER_REV.getOrDefault((Object)side, (Object)0);
            return (int)(this.state_flags_ >> shift & 0xFL);
        }

        public void setSidePower(Direction side, int p) {
            int shift = 32 + 4 * (Integer)defs.connections.CONNECTION_BIT_ORDER_REV.getOrDefault((Object)side, (Object)0);
            this.state_flags_ = this.state_flags_ & (15L << shift ^ 0xFFFFFFFFFFFFFFFFL) | (long)(p & 0xF) << shift;
        }

        public boolean hasVanillaRedstoneConnection(Direction side) {
            return defs.connections.hasVanillaWireConnection(this.getStateFlags(), side) || (this.state_flags_ & defs.connections.getBulkConnectorBit(side)) != 0L;
        }

        public int getRedstonePower(Direction redstone_side, boolean weak) {
            Direction own_side = redstone_side.m_122424_();
            int p = 0;
            for (TrackNet net : this.nets_) {
                if (!net.power_sides.contains(own_side) || (p = Math.max(p, net.power)) < 15) continue;
                break;
            }
            int n = p = p <= 0 || !this.m_58904_().m_8055_(this.m_58899_().m_121945_(own_side)).m_60713_(Blocks.f_50088_) ? p : p - 1;
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("POWR: %12s(%s)==%d", this.posstr(this.m_58899_()), redstone_side, p));
            }
            return p;
        }

        public int getRedstoneDustCount() {
            int i;
            int n = 0;
            int rem = this.getWireFlags();
            for (i = 0; rem != 0 && i < 24; rem >>= 1, ++i) {
                if (((long)rem & 1L) == 0L) continue;
                ++n;
            }
            rem = this.getConnectionFlags();
            for (i = 0; rem != 0 && i < 6; rem >>= 1, ++i) {
                if (((long)rem & 1L) == 0L) continue;
                ++n;
            }
            return n;
        }

        public void toggle_trace(@Nullable Player player) {
            boolean bl = this.trace_ = !this.trace_;
            if (player != null) {
                Auxiliaries.playerChatMessage(player, "Trace: " + this.trace_);
            }
        }

        public int handleActivation(BlockPos pos, Player player, InteractionHand hand, Direction clicked_face, Vec3 hitvec, boolean remove_only) {
            ItemStack used_stack = player.m_21120_(hand);
            if (!used_stack.m_41619_() && used_stack.m_41720_() != Items.f_42451_ && !RedstonePenItem.isPen(used_stack)) {
                return 0;
            }
            Direction face = clicked_face.m_122424_();
            Vec3 hit_r = hitvec.m_82546_(Vec3.m_82512_((Vec3i)pos));
            Vec3 hit = switch (clicked_face) {
                case Direction.EAST, Direction.WEST -> hit_r.m_82542_(0.0, 1.0, 1.0);
                case Direction.NORTH, Direction.SOUTH -> hit_r.m_82542_(1.0, 1.0, 0.0);
                default -> hit_r.m_82542_(1.0, 0.0, 1.0);
            };
            Direction[] dir = Direction.m_122366_((double)hit.m_7096_(), (double)hit.m_7098_(), (double)hit.m_7094_());
            long flip_mask = hit.m_82553_() < 0.12 && (!remove_only || this.getConnectionFlags() != 0) ? (((long)this.getWireFlags() & defs.connections.getAllElementsOnFace(face)) != 0L ? defs.connections.getBulkConnectorBit(face) : defs.connections.getWireBit(face, (Direction)dir)) : defs.connections.getWireBit(face, (Direction)dir);
            int material_use = 0;
            if ((this.state_flags_ & flip_mask) != 0L) {
                this.state_flags_ &= flip_mask ^ 0xFFFFFFFFFFFFFFFFL;
                --material_use;
                long bc = defs.connections.getBulkConnectorBit(face);
                if ((this.state_flags_ & defs.connections.getAllElementsOnFace(face)) == bc) {
                    this.state_flags_ &= bc ^ 0xFFFFFFFFFFFFFFFFL;
                    --material_use;
                }
                if (this.getWireFlags() == 0) {
                    material_use -= this.getRedstoneDustCount();
                    this.state_flags_ = 0L;
                }
            } else if (!used_stack.m_41619_() && !remove_only) {
                boolean can_place = false;
                for (Direction side : Direction.values()) {
                    if ((defs.connections.getAllElementsOnFace(side) & flip_mask) == 0L) continue;
                    can_place = true;
                    break;
                }
                if (can_place) {
                    this.state_flags_ |= flip_mask;
                    ++material_use;
                }
            }
            if (material_use != 0) {
                int initial_side_power = this.getSidePower(face);
                this.setSidePower(face, 0);
                Map<BlockPos, BlockPos> change_notifications_before = this.updateAllPowerValuesFromAdjacent();
                Set net_neighbours_before = this.nets_.stream().filter(net -> net.internal_sides.contains(face)).map(net -> net.neighbour_positions).findFirst().map(HashSet::new).orElse(new HashSet());
                this.updateConnections(1);
                this.setSidePower(face, 0);
                Map<BlockPos, BlockPos> change_notifications_after = this.updateAllPowerValuesFromAdjacent();
                List<BlockPos> disconnected = change_notifications_before.keySet().stream().filter(p -> !change_notifications_after.containsKey(p)).collect(Collectors.toList());
                List<BlockPos> connected = change_notifications_after.keySet().stream().filter(p -> !change_notifications_before.containsKey(p)).collect(Collectors.toList());
                if (connected.isEmpty() && disconnected.isEmpty() && defs.connections.hasBulkConnection(this.getStateFlags(), face)) {
                    Set net_neighbours_after = this.nets_.stream().filter(net -> net.internal_sides.contains(face)).map(net -> net.neighbour_positions).findFirst().map(HashSet::new).orElse(new HashSet());
                    for (BlockPos p2 : net_neighbours_after) {
                        if (net_neighbours_before.contains(p2)) continue;
                        connected.add(p2);
                    }
                    for (BlockPos p2 : net_neighbours_before) {
                        if (net_neighbours_after.contains(p2)) continue;
                        disconnected.add(p2);
                    }
                }
                if (connected.isEmpty() && disconnected.isEmpty()) {
                    this.setSidePower(face, initial_side_power);
                } else {
                    this.setSidePower(face, 0);
                    this.nets_.forEach(net -> {
                        if (net.internal_sides.contains(face)) {
                            net.power = 0;
                        }
                    });
                    disconnected.forEach(p -> {
                        BlockEntity te = this.m_58904_().m_7702_(p);
                        this.m_58904_().m_8055_(p).m_60690_(this.m_58904_(), p, (Block)this.getBlock(), pos, false);
                        if (te instanceof TrackBlockEntity) {
                            ((TrackBlockEntity)te).updateConnections(1);
                        }
                    });
                    connected.forEach(p -> {
                        BlockEntity te = this.m_58904_().m_7702_(p);
                        if (te instanceof TrackBlockEntity) {
                            ((TrackBlockEntity)te).updateConnections(1);
                        }
                        this.m_58904_().m_8055_(p).m_60690_(this.m_58904_(), p, (Block)this.getBlock(), pos, false);
                        this.getBlock().m_6861_(this.m_58900_(), this.m_58904_(), this.m_58899_(), this.getBlock(), (BlockPos)p, false);
                    });
                }
                this.sync(true);
            }
            return material_use;
        }

        public Map<BlockPos, BlockPos> updateAllPowerValuesFromAdjacent() {
            if (updatepower_order.isEmpty()) {
                for (Direction side : Direction.values()) {
                    updatepower_order.add(new Vec3i(0, 0, 0).m_5484_(side, 1));
                }
                for (int x = -1; x <= 1; ++x) {
                    for (int y = -1; y <= 1; ++y) {
                        for (int z = -1; z <= 1; ++z) {
                            if (Math.abs(x) + Math.abs(y) + Math.abs(z) != 2) continue;
                            updatepower_order.add(new Vec3i(x, y, z));
                        }
                    }
                }
            }
            HashMap<BlockPos, BlockPos> all_change_notifications = new HashMap<BlockPos, BlockPos>();
            for (Vec3i ofs : updatepower_order) {
                this.handleNeighborChanged(this.m_58899_().m_121955_(ofs)).forEach(all_change_notifications::putIfAbsent);
            }
            return all_change_notifications;
        }

        private void spawnRedsoneItems(int count) {
            if (count <= 0) {
                return;
            }
            ItemEntity e = new ItemEntity(this.m_58904_(), (double)this.m_58899_().m_123341_() + 0.5, (double)this.m_58899_().m_123342_() + 0.5, (double)this.m_58899_().m_123343_() + 0.5, new ItemStack((ItemLike)Items.f_42451_, count));
            e.m_32060_();
            e.m_20256_(new Vec3(this.m_58904_().m_213780_().m_188500_() - 0.5, this.m_58904_().m_213780_().m_188500_() - 0.5, this.m_58904_().m_213780_().m_188500_()).m_82490_(0.1));
            this.m_58904_().m_7967_((Entity)e);
        }

        private RedstoneTrackBlock getBlock() {
            return ModContent.references.TRACK_BLOCK;
        }

        public boolean handlePostPlacement(Direction facing, BlockState facingState, BlockPos fromPos) {
            if (!RedstoneTrackBlock.canBePlacedOnFace(facingState, this.m_58904_(), fromPos, facing.m_122424_())) {
                long to_remove = defs.connections.getAllElementsOnFace(facing);
                long new_flags = this.state_flags_ & (to_remove ^ 0xFFFFFFFFFFFFFFFFL);
                boolean update_connections = false;
                if (new_flags != this.state_flags_) {
                    int count = this.getRedstoneDustCount();
                    this.state_flags_ = new_flags;
                    this.spawnRedsoneItems(count -= this.getRedstoneDustCount());
                    update_connections = true;
                } else if (this.block_change_tracking_[facing.m_122411_()] != facingState.m_60734_()) {
                    this.block_change_tracking_[facing.m_122411_()] = facingState.m_60734_();
                    update_connections = true;
                }
                if (update_connections) {
                    this.updateConnections();
                    this.handleNeighborChanged(fromPos);
                }
            }
            return this.getWireFlags() != 0;
        }

        private int getNonWireSignal(Level world, BlockPos pos, Direction redstone_side) {
            int p_in;
            Direction rs_side;
            BlockPos side_pos;
            BlockState side_state;
            int p;
            this.getBlock().disablePower(true);
            BlockState state = world.m_8055_(pos);
            int n = p = !state.m_60713_(Blocks.f_50088_) && !state.m_60713_((Block)this.getBlock()) ? state.m_60746_((BlockGetter)world, pos, redstone_side) : 0;
            if (!state.shouldCheckWeakPower((LevelReader)world, pos, redstone_side)) {
                this.getBlock().disablePower(false);
                return p;
            }
            Direction[] directionArray = Direction.values();
            int n2 = directionArray.length;
            for (int i = 0; i < n2 && ((side_state = world.m_8055_(side_pos = pos.m_121945_(rs_side = directionArray[i]))).m_60713_(Blocks.f_50088_) || side_state.m_60713_((Block)this.getBlock()) || (p_in = side_state.m_60775_((BlockGetter)world, side_pos, rs_side)) <= p || (p = p_in) < 15); ++i) {
            }
            this.getBlock().disablePower(false);
            return p;
        }

        public Map<BlockPos, BlockPos> handleNeighborChanged(BlockPos fromPos) {
            HashMap<BlockPos, BlockPos> change_notifications = new HashMap<BlockPos, BlockPos>();
            boolean power_changed = false;
            for (TrackNet net : this.nets_) {
                if (!net.neighbour_positions.contains(fromPos)) continue;
                int pmax = 0;
                for (int i = 0; i < net.neighbour_positions.size(); ++i) {
                    BlockPos ext_pos = net.neighbour_positions.get(i);
                    change_notifications.put(ext_pos, this.m_58899_());
                    Direction ext_side = net.neighbour_sides.get(i);
                    BlockState ext_state = this.f_58857_.m_8055_(ext_pos);
                    if (ext_state.m_60713_(Blocks.f_50088_)) {
                        if (pmax >= 15) continue;
                        int p_vanilla_wire = Math.max(0, (Integer)ext_state.m_61143_((Property)RedStoneWireBlock.f_55500_) - 1);
                        pmax = Math.max(pmax, p_vanilla_wire);
                        continue;
                    }
                    if (ext_state.m_60713_((Block)this.getBlock())) {
                        if (pmax >= 15) continue;
                        int p_track = RedstoneTrackBlock.tile((BlockGetter)this.m_58904_(), ext_pos).map(te -> Math.max(0, te.getSidePower(ext_side) - 1)).orElse(0);
                        pmax = Math.max(pmax, p_track);
                        continue;
                    }
                    Direction eside = ext_side.m_122424_();
                    int p_nowire = this.getNonWireSignal(this.m_58904_(), ext_pos, eside);
                    pmax = Math.max(pmax, p_nowire);
                    if (ext_state.m_60803_() || p_nowire != 0) continue;
                    if (ext_side != Direction.DOWN) {
                        change_notifications.putIfAbsent(ext_pos.m_121945_(Direction.DOWN), ext_pos);
                    }
                    if (ext_side != Direction.UP) {
                        change_notifications.putIfAbsent(ext_pos.m_121945_(Direction.UP), ext_pos);
                    }
                    if (ext_side != Direction.NORTH) {
                        change_notifications.putIfAbsent(ext_pos.m_121945_(Direction.NORTH), ext_pos);
                    }
                    if (ext_side != Direction.SOUTH) {
                        change_notifications.putIfAbsent(ext_pos.m_121945_(Direction.SOUTH), ext_pos);
                    }
                    if (ext_side != Direction.EAST) {
                        change_notifications.putIfAbsent(ext_pos.m_121945_(Direction.EAST), ext_pos);
                    }
                    if (ext_side == Direction.WEST) continue;
                    change_notifications.putIfAbsent(ext_pos.m_121945_(Direction.WEST), ext_pos);
                }
                if (net.power != pmax) {
                    net.power = pmax;
                    power_changed = true;
                }
                for (Direction side : net.internal_sides) {
                    if (this.getSidePower(side) == pmax) continue;
                    this.setSidePower(side, pmax);
                    power_changed = true;
                }
            }
            if (power_changed) {
                if (this.trace_ && change_notifications.size() > 0) {
                    Auxiliaries.logWarn(String.format("CHNF (%s) updates: [%s]", this.posstr(this.m_58899_()), change_notifications.entrySet().stream().map(kv -> this.posstr((BlockPos)kv.getKey()) + ">" + this.posstr((BlockPos)kv.getValue())).collect(Collectors.joining(" ; "))));
                }
                this.sync(true);
                return change_notifications;
            }
            return Collections.emptyMap();
        }

        private String posstr(BlockPos pos) {
            return "[" + pos.m_123341_() + "," + pos.m_123342_() + "," + pos.m_123343_() + "]";
        }

        private boolean isRedstoneInsulator(BlockState state) {
            return state.m_60767_() == Material.f_76275_;
        }

        private void updateConnections() {
            this.updateConnections(1);
        }

        private void updateConnections(int recursion_left) {
            int[] current_side_powers = new int[]{0, 0, 0, 0, 0, 0};
            this.nets_.forEach(net -> net.internal_sides.forEach(ps -> {
                current_side_powers[ps.ordinal()] = net.power;
            }));
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON %s SIDPW: [%01x %01x %01x %01x %01x %01x]", this.posstr(this.m_58899_()), current_side_powers[0], current_side_powers[1], current_side_powers[2], current_side_powers[3], current_side_powers[4], current_side_powers[5]));
            }
            this.nets_.clear();
            HashSet<TrackBlockEntity> track_connection_updates = new HashSet<TrackBlockEntity>();
            long[] internal_connected_sides = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
            long[] external_connected_routes = new long[]{0L, 0L, 0L, 0L, 0L, 0L};
            long external_connection_flags = this.getStateFlags() & 0x3FFFFFFFL;
            for (Map.Entry kv : defs.connections.INTERNAL_EDGE_CONNECTION_MAPPING.entrySet()) {
                long wire_bit_pair = (Long)kv.getKey();
                if ((this.getStateFlags() & wire_bit_pair) != wire_bit_pair) continue;
                external_connection_flags &= wire_bit_pair ^ 0xFFFFFFFFFFFFFFFFL;
                for (int i = 0; i < 6; ++i) {
                    if ((15L << 4 * i & wire_bit_pair) == 0L) continue;
                    int n = i;
                    internal_connected_sides[n] = internal_connected_sides[n] | wire_bit_pair;
                }
            }
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON %s CONFL: ext:%08x | int:[%08x %08x %08x %08x %08x %08x]", this.posstr(this.m_58899_()), external_connection_flags, internal_connected_sides[0], internal_connected_sides[1], internal_connected_sides[2], internal_connected_sides[3], internal_connected_sides[4], internal_connected_sides[5]));
            }
            for (int k = 0; k < 2; ++k) {
                for (int i = 0; i < 6; ++i) {
                    if (internal_connected_sides[i] == 0L) continue;
                    for (int j = i + 1; j < 6; ++j) {
                        if ((internal_connected_sides[i] & internal_connected_sides[j]) == 0L) continue;
                        int n = i;
                        internal_connected_sides[n] = internal_connected_sides[n] | internal_connected_sides[j];
                        internal_connected_sides[j] = 0L;
                    }
                }
            }
            for (int i = 0; i < 6; ++i) {
                if (internal_connected_sides[i] != 0L) {
                    for (int j = i; j < 6; ++j) {
                        long mask = 15L << 4 * j;
                        if ((internal_connected_sides[i] & mask) == 0L) continue;
                        long bulk = 1L << 24 + j;
                        int n = i;
                        external_connected_routes[n] = external_connected_routes[n] | external_connection_flags & (mask | bulk);
                        external_connection_flags &= (mask | bulk) ^ 0xFFFFFFFFFFFFFFFFL;
                    }
                    continue;
                }
                long mask = 15L << 4 * i;
                long bulk = 1L << 24 + i;
                int n = i;
                external_connected_routes[n] = external_connected_routes[n] | external_connection_flags & (mask | bulk);
                external_connection_flags &= (mask | bulk) ^ 0xFFFFFFFFFFFFFFFFL;
            }
            if (this.trace_) {
                Auxiliaries.logWarn(String.format("UCON: %s CONSD: ext:%08x | int:[%08x %08x %08x %08x %08x %08x]", this.posstr(this.m_58899_()), external_connection_flags, internal_connected_sides[0], internal_connected_sides[1], internal_connected_sides[2], internal_connected_sides[3], internal_connected_sides[4], internal_connected_sides[5]));
                Auxiliaries.logWarn(String.format("UCON: %s CONRT: ext:%08x | ext:[%08x %08x %08x %08x %08x %08x]", this.posstr(this.m_58899_()), external_connection_flags, external_connected_routes[0], external_connected_routes[1], external_connected_routes[2], external_connected_routes[3], external_connected_routes[4], external_connected_routes[5]));
            }
            HashSet used_sides = new HashSet();
            for (int i = 0; i < 6; ++i) {
                if (external_connected_routes[i] == 0L) continue;
                HashSet<Direction> power_sides = new HashSet<Direction>();
                HashSet<Direction> internal_sides = new HashSet<Direction>();
                ArrayList<BlockPos> block_positions = new ArrayList<BlockPos>(6);
                ArrayList<Direction> block_sides = new ArrayList<Direction>(6);
                for (int j = 0; j < 6; ++j) {
                    long mask = 15L << 4 * j;
                    long bulk = 1L << 24 + j;
                    Direction side2 = defs.connections.CONNECTION_BIT_ORDER[j];
                    if ((internal_connected_sides[i] & mask) != 0L) {
                        internal_sides.add(side2);
                    }
                    if ((external_connected_routes[i] & mask) != 0L) {
                        for (int k = 0; k < 4; ++k) {
                            long wire_bit = 1L << 4 * j + k;
                            if ((external_connected_routes[i] & wire_bit) == 0L) continue;
                            Tuple<Direction, Direction> side_dir = defs.connections.getWireBitSideAndDirection(wire_bit);
                            Direction tsid = (Direction)side_dir.m_14418_();
                            Direction tdir = (Direction)side_dir.m_14419_();
                            BlockPos wire_pos = this.m_58899_().m_121945_(tdir);
                            BlockState wire_state = this.m_58904_().m_8055_(wire_pos);
                            boolean diagonal_check = false;
                            if (wire_state.m_60713_((Block)this.getBlock())) {
                                long adjacent_mask = defs.connections.getWireBit(tsid, tdir.m_122424_());
                                TrackBlockEntity adj_te = RedstoneTrackBlock.tile((BlockGetter)this.m_58904_(), wire_pos).orElse(null);
                                if (adj_te == null || (adj_te.getStateFlags() & adjacent_mask) != adjacent_mask) {
                                    diagonal_check = true;
                                } else {
                                    block_positions.add(wire_pos);
                                    block_sides.add(tsid);
                                    internal_sides.add(side2);
                                    power_sides.add(tdir);
                                    track_connection_updates.add(adj_te);
                                    continue;
                                }
                            }
                            if (!diagonal_check && wire_state.m_60713_(Blocks.f_50088_)) {
                                if (side2 != Direction.DOWN) {
                                    diagonal_check = true;
                                } else {
                                    block_positions.add(wire_pos);
                                    block_sides.add(tdir.m_122424_());
                                    internal_sides.add(side2);
                                    power_sides.add(tdir);
                                    continue;
                                }
                            }
                            if (!diagonal_check && wire_state.m_60803_()) {
                                block_positions.add(wire_pos);
                                block_sides.add(tdir.m_122424_());
                                internal_sides.add(side2);
                                power_sides.add(tdir);
                                continue;
                            }
                            BlockPos track_pos = wire_pos.m_121945_(tsid);
                            BlockState track_state = this.m_58904_().m_8055_(track_pos);
                            if (track_state.m_60713_((Block)this.getBlock())) {
                                long adjacent_mask = defs.connections.getWireBit(tdir.m_122424_(), tsid.m_122424_());
                                TrackBlockEntity adj_te = RedstoneTrackBlock.tile((BlockGetter)this.m_58904_(), track_pos).orElse(null);
                                if (adj_te == null || (adj_te.getStateFlags() & adjacent_mask) != adjacent_mask) continue;
                                block_positions.add(track_pos);
                                block_sides.add(tdir.m_122424_());
                                power_sides.add(tdir);
                                internal_sides.add(side2);
                                track_connection_updates.add(adj_te);
                                continue;
                            }
                            if (this.isRedstoneInsulator(wire_state)) continue;
                            block_positions.add(wire_pos);
                            block_sides.add(tdir.m_122424_());
                            internal_sides.add(side2);
                            power_sides.add(tdir);
                        }
                    }
                    if ((external_connected_routes[i] & bulk) == 0L) continue;
                    BlockPos bulk_pos = this.m_58899_().m_121945_(side2);
                    BlockState bulk_state = this.m_58904_().m_8055_(bulk_pos);
                    if (this.isRedstoneInsulator(bulk_state)) continue;
                    block_positions.add(bulk_pos);
                    block_sides.add(side2.m_122424_());
                    internal_sides.add(side2);
                    power_sides.add(side2);
                }
                if (block_positions.isEmpty()) continue;
                TrackNet net2 = new TrackNet(block_positions, block_sides, new ArrayList<Direction>(internal_sides), new ArrayList<Direction>(power_sides));
                net2.power = net2.internal_sides.stream().mapToInt(side -> current_side_powers[side.ordinal()]).max().orElse(0);
                this.nets_.add(net2);
                used_sides.addAll(internal_sides);
            }
            Arrays.stream(Direction.values()).filter(side -> !used_sides.contains(side)).forEach(side -> this.setSidePower((Direction)side, 0));
            this.m_6596_();
            if (this.trace_) {
                String poss = this.posstr(this.m_58899_());
                for (TrackNet net3 : this.nets_) {
                    ArrayList<CallSite> ss = new ArrayList<CallSite>();
                    for (int i = 0; i < net3.neighbour_positions.size(); ++i) {
                        ss.add((CallSite)((Object)(this.posstr(net3.neighbour_positions.get(i)) + ":" + net3.neighbour_sides.get(i).toString())));
                    }
                    String int_sides = net3.internal_sides.stream().map(Direction::toString).collect(Collectors.joining(","));
                    String pwr_sides = net3.power_sides.stream().map(Direction::toString).collect(Collectors.joining(","));
                    Auxiliaries.logWarn(String.format("UCON %s: adj:%s | ints:%s | pwrs:%s", poss, String.join((CharSequence)", ", ss), int_sides, pwr_sides));
                }
            }
            if (recursion_left > 0) {
                for (TrackBlockEntity te : track_connection_updates) {
                    if (this.trace_) {
                        Auxiliaries.logWarn(String.format("UCON %s: UPDATE NET OF %s", this.posstr(this.m_58899_()), this.posstr(te.m_58899_())));
                    }
                    te.updateConnections(recursion_left - 1);
                }
            }
        }

        public static class TrackNet {
            public final List<BlockPos> neighbour_positions;
            public final List<Direction> neighbour_sides;
            public final List<Direction> internal_sides;
            public final List<Direction> power_sides;
            public int power;

            public TrackNet(List<BlockPos> positions, List<Direction> ext_sides, List<Direction> int_sides, List<Direction> pwr_sides) {
                this.neighbour_positions = positions;
                this.neighbour_sides = ext_sides;
                this.internal_sides = int_sides;
                this.power_sides = pwr_sides;
                this.power = 0;
            }

            public TrackNet(List<BlockPos> positions, List<Direction> ext_sides, List<Direction> int_sides, List<Direction> pwr_sides, int power_setval) {
                this.neighbour_positions = positions;
                this.neighbour_sides = ext_sides;
                this.internal_sides = int_sides;
                this.power_sides = pwr_sides;
                this.power = power_setval;
            }
        }
    }

    public static class RedstoneTrackBlock
    extends StandardBlocks.WaterLoggable
    implements EntityBlock {
        private boolean can_provide_power_ = true;

        public RedstoneTrackBlock(long config, BlockBehaviour.Properties builder) {
            super(config, builder);
        }

        public static Optional<TrackBlockEntity> tile(BlockGetter world, BlockPos pos) {
            BlockEntity te = world.m_7702_(pos);
            return te instanceof TrackBlockEntity && !te.m_58901_() ? Optional.of((TrackBlockEntity)te) : Optional.empty();
        }

        public static boolean canBePlacedOnFace(BlockState state, Level world, BlockPos pos, Direction face) {
            if (state.m_60734_() instanceof PistonBaseBlock) {
                Direction pface = (Direction)state.m_61143_((Property)PistonBaseBlock.f_52588_);
                return face != pface;
            }
            if (state.m_60734_() instanceof MovingPistonBlock) {
                return true;
            }
            if (state.m_60713_(Blocks.f_50332_)) {
                return face == Direction.UP;
            }
            return state.m_60783_((BlockGetter)world, pos, face);
        }

        @Override
        protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
            super.m_7926_(builder);
        }

        public BlockEntity m_142194_(BlockPos pos, BlockState state) {
            return new TrackBlockEntity(pos, state);
        }

        @Override
        public boolean hasDynamicDropList() {
            return true;
        }

        @Override
        public List<ItemStack> dropList(BlockState state, Level world, @Nullable BlockEntity te, boolean explosion) {
            if (!(te instanceof TrackBlockEntity)) {
                return Collections.emptyList();
            }
            int num_connections = ((TrackBlockEntity)te).getRedstoneDustCount();
            if (num_connections <= 0) {
                return Collections.emptyList();
            }
            return Collections.singletonList(new ItemStack((ItemLike)Items.f_42451_, num_connections));
        }

        @Override
        @Nullable
        public BlockState m_5573_(BlockPlaceContext context) {
            return context.m_43725_().m_8055_(context.m_8083_()).m_60629_(context) ? super.m_5573_(context) : null;
        }

        public Item m_5456_() {
            return Items.f_42451_;
        }

        @Override
        public boolean m_7357_(BlockState state, BlockGetter world, BlockPos pos, PathComputationType type) {
            return true;
        }

        @Override
        public VoxelShape m_5940_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            int wires = RedstoneTrackBlock.tile(world, pos).map(TrackBlockEntity::getWireFlags).orElse(0);
            int faces = ((wires & 0xF) != 0 ? 1 : 0) | ((wires & 0xF0) != 0 ? 2 : 0) | ((wires & 0xF00) != 0 ? 4 : 0) | ((wires & 0xF000) != 0 ? 8 : 0) | ((wires & 0xF0000) != 0 ? 16 : 0) | ((wires & 0xF00000) != 0 ? 32 : 0);
            return defs.shape.get(faces);
        }

        @Override
        public VoxelShape m_5939_(BlockState state, BlockGetter world, BlockPos pos, CollisionContext context) {
            return Shapes.m_83040_();
        }

        @Override
        public boolean m_7420_(BlockState state, BlockGetter reader, BlockPos pos) {
            return (Boolean)state.m_61143_((Property)WATERLOGGED) == false;
        }

        @Override
        public PushReaction m_5537_(BlockState state) {
            return PushReaction.DESTROY;
        }

        public boolean m_7923_(BlockState state) {
            return true;
        }

        @Deprecated
        public int m_7753_(BlockState state, BlockGetter worldIn, BlockPos pos) {
            return 0;
        }

        @Deprecated
        public RenderShape m_7514_(BlockState state) {
            return RenderShape.ENTITYBLOCK_ANIMATED;
        }

        public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
            return true;
        }

        @Deprecated
        public boolean canConnectRedstone(BlockState state, BlockGetter world, BlockPos pos, @Nullable Direction side) {
            return side != null && RedstoneTrackBlock.tile(world, pos).map(te -> te.hasVanillaRedstoneConnection(side.m_122424_())).orElse(false) != false;
        }

        public boolean m_7899_(BlockState state) {
            return this.can_provide_power_;
        }

        public boolean m_7278_(BlockState state) {
            return false;
        }

        @Deprecated
        public int m_6782_(BlockState state, Level world, BlockPos pos) {
            return 0;
        }

        @Deprecated
        public int m_6378_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return this.can_provide_power_ ? RedstoneTrackBlock.tile(world, pos).map(te -> te.getRedstonePower(redstone_side, true)).orElse(0) : 0;
        }

        @Deprecated
        public int m_6376_(BlockState state, BlockGetter world, BlockPos pos, Direction redstone_side) {
            return this.can_provide_power_ ? RedstoneTrackBlock.tile(world, pos).map(te -> te.getRedstonePower(redstone_side, false)).orElse(0) : 0;
        }

        public boolean shouldCheckWeakPower(BlockState state, LevelReader world, BlockPos pos, Direction side) {
            return false;
        }

        public void m_213897_(BlockState state, ServerLevel world, BlockPos pos, RandomSource rnd) {
            if (!RedstoneTrackBlock.tile((BlockGetter)world, pos).map(te -> te.sync(false)).orElse(false).booleanValue()) {
                world.m_7471_(pos, false);
            }
        }

        @Override
        public BlockState m_7417_(BlockState state, Direction facing, BlockState facingState, LevelAccessor world, BlockPos pos, BlockPos facingPos) {
            if (!world.m_5776_()) {
                if (RedstoneTrackBlock.tile((BlockGetter)world, pos).map(te -> te.handlePostPlacement(facing, facingState, facingPos)).orElse(true).booleanValue()) {
                    world.m_186460_(pos, (Block)this, 1);
                } else {
                    world.m_7471_(pos, false);
                }
            }
            return super.m_7417_(state, facing, facingState, world, pos, facingPos);
        }

        public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
            if (oldState.m_60713_(state.m_60734_()) || world.m_5776_()) {
                return;
            }
            RedstoneTrackBlock.tile((BlockGetter)world, pos).ifPresent(TrackBlockEntity::updateConnections);
            this.updateNeighbourShapes(state, world, pos);
            this.notifyAdjacent(world, pos);
        }

        @Override
        public void m_6810_(BlockState state, Level world, BlockPos pos, BlockState newState, boolean isMoving) {
            if (isMoving || state.m_60713_(newState.m_60734_())) {
                return;
            }
            super.m_6810_(state, world, pos, newState, isMoving);
            if (world.m_5776_()) {
                return;
            }
            this.notifyAdjacent(world, pos);
        }

        public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rtr) {
            if (player.m_21120_(hand).m_150930_(Items.f_42751_)) {
                if (world.f_46443_) {
                    return InteractionResult.SUCCESS;
                }
                BlockEntity blockEntity = world.m_7702_(pos);
                if (blockEntity instanceof TrackBlockEntity) {
                    TrackBlockEntity te = (TrackBlockEntity)blockEntity;
                    te.toggle_trace(player);
                }
                return InteractionResult.CONSUME;
            }
            return this.onBlockActivated(state, world, pos, player, hand, rtr, false);
        }

        public InteractionResult onBlockActivated(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rtr, boolean remove_only) {
            TrackBlockEntity te;
            ItemStack stack = player.m_21120_(hand);
            if (!stack.m_41619_() && stack.m_41720_() != Items.f_42451_ && !RedstonePenItem.isPen(stack)) {
                BlockPos behind_pos = pos.m_121945_(rtr.m_82434_());
                BlockState behind_state = world.m_8055_(behind_pos);
                if (behind_state.m_60796_((BlockGetter)world, behind_pos)) {
                    return behind_state.m_60734_().m_6227_(behind_state, world, behind_pos, player, hand, rtr);
                }
                return InteractionResult.PASS;
            }
            if (world.m_5776_()) {
                return InteractionResult.SUCCESS;
            }
            if (!RedstonePenItem.hasEnoughRedstone(player.m_21120_(hand), 1, player)) {
                remove_only = true;
            }
            if ((te = (TrackBlockEntity)RedstoneTrackBlock.tile((BlockGetter)world, pos).orElse(null)) == null) {
                return InteractionResult.FAIL;
            }
            int redstone_use = te.handleActivation(pos, player, hand, rtr.m_82434_(), rtr.m_82450_(), remove_only);
            if (redstone_use == 0) {
                return InteractionResult.PASS;
            }
            if (redstone_use < 0) {
                RedstonePenItem.pushRedstone(player.m_21120_(hand), -redstone_use, player);
                if (te.getWireFlags() == 0) {
                    world.m_7731_(pos, state.m_60819_().m_76188_(), 3);
                } else {
                    Map<BlockPos, BlockPos> blocks_to_update = te.updateAllPowerValuesFromAdjacent();
                    for (Map.Entry<BlockPos, BlockPos> update_pos : blocks_to_update.entrySet()) {
                        world.m_46586_(update_pos.getKey(), (Block)this, update_pos.getValue());
                    }
                }
                world.m_5594_(null, pos, SoundEvents.f_12016_, SoundSource.BLOCKS, 0.4f, 2.0f);
            } else {
                RedstonePenItem.popRedstone(player.m_21120_(hand), redstone_use, player, hand);
                world.m_5594_(null, pos, SoundEvents.f_12065_, SoundSource.BLOCKS, 0.4f, 2.4f);
            }
            this.updateNeighbourShapes(state, world, pos);
            this.notifyAdjacent(world, pos);
            return InteractionResult.CONSUME;
        }

        public void m_6861_(BlockState state, Level world, BlockPos pos, Block fromBlock, BlockPos fromPos, boolean isMoving) {
            block5: {
                if (world.m_5776_()) {
                    return;
                }
                Map blocks_to_update = RedstoneTrackBlock.tile((BlockGetter)world, pos).map(te -> te.handleNeighborChanged(fromPos)).orElse(Collections.emptyMap());
                if (blocks_to_update.isEmpty()) {
                    return;
                }
                try {
                    for (Map.Entry update_pos : blocks_to_update.entrySet()) {
                        world.m_46586_((BlockPos)update_pos.getKey(), (Block)this, (BlockPos)update_pos.getValue());
                    }
                }
                catch (Throwable ex) {
                    Auxiliaries.logger().error("Track neighborChanged recursion detected, dropping!");
                    int num_redstone = RedstoneTrackBlock.tile((BlockGetter)world, pos).map(TrackBlockEntity::getRedstoneDustCount).orElse(0);
                    if (num_redstone <= 0) break block5;
                    Vec3 p = Vec3.m_82512_((Vec3i)pos);
                    world.m_7967_((Entity)new ItemEntity(world, p.f_82479_, p.f_82480_, p.f_82481_, new ItemStack((ItemLike)Items.f_42451_, num_redstone)));
                    world.m_7731_(pos, world.m_8055_(pos).m_60819_().m_76188_(), 18);
                }
            }
        }

        public void m_7742_(BlockState state, LevelAccessor worldIn, BlockPos pos, int flags, int recursionLeft) {
        }

        @OnlyIn(value=Dist.CLIENT)
        private void spawnPoweredParticle(Level world, RandomSource rand, BlockPos pos, Vec3 color, Direction from, Direction to, float minChance, float maxChance) {
            float f = maxChance - minChance;
            if (rand.m_188501_() < 0.3f * f) {
                double c1 = 0.4375;
                double c2 = minChance + f * rand.m_188501_();
                double p0 = 0.5 + c1 * (double)from.m_122429_() + c2 * 0.4 * (double)to.m_122429_();
                double p1 = 0.5 + c1 * (double)from.m_122430_() + c2 * 0.4 * (double)to.m_122430_();
                double p2 = 0.5 + c1 * (double)from.m_122431_() + c2 * 0.4 * (double)to.m_122431_();
                world.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(color), 1.0f), (double)pos.m_123341_() + p0, (double)pos.m_123342_() + p1, (double)pos.m_123343_() + p2, 0.0, 0.0, 0.0);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        public void m_214162_(BlockState state, Level world, BlockPos pos, RandomSource rand) {
            if ((double)rand.m_188501_() > 0.4) {
                return;
            }
            TrackBlockEntity te = RedstoneTrackBlock.tile((BlockGetter)world, pos).orElse(null);
            if (te == null || (te.getStateFlags() & 0xFFFFFF00000000L) == 0L) {
                return;
            }
            Vec3 color = new Vec3((double)0.6f, 0.0, 0.0);
            for (Direction side : Direction.values()) {
                int p = te.getSidePower(side);
                if (p == 0) continue;
                this.spawnPoweredParticle(world, rand, pos, color, side, side.m_122424_(), -0.5f, 0.5f);
            }
        }

        public void checkSmartPlacement(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult rtr) {
            Direction odir;
            BlockPos opos;
            BlockState ostate;
            if (world.m_5776_()) {
                return;
            }
            ItemStack pen = player.m_21120_(hand);
            if (!RedstonePenItem.hasEnoughRedstone(pen, 2, player)) {
                return;
            }
            TrackBlockEntity te = RedstoneTrackBlock.tile((BlockGetter)world, pos).orElse(null);
            if (te == null) {
                return;
            }
            Tuple<Direction, Direction> side_dir = defs.connections.getWireBitSideAndDirection(te.getWireFlags());
            Direction face = (Direction)side_dir.m_14418_();
            Direction dir = (Direction)side_dir.m_14419_();
            if (face == Direction.DOWN && dir == Direction.DOWN) {
                return;
            }
            int num_placed = 0;
            long flags_to_add = 0L;
            for (Direction d : Direction.values()) {
                TrackBlockEntity ote;
                BlockState ostate2;
                if (!RedstonePenItem.hasEnoughRedstone(pen, num_placed, player)) {
                    return;
                }
                if (d == face || d == face.m_122424_() || d == dir || !(ostate2 = world.m_8055_(pos.m_121945_(d))).m_60713_((Block)this) || (ote = (TrackBlockEntity)RedstoneTrackBlock.tile((BlockGetter)world, pos.m_121945_(d)).orElse(null)) == null) continue;
                int oflags = ote.getWireFlags();
                if ((defs.connections.getWireBit(face, d.m_122424_()) & (long)oflags) == 0L) continue;
                flags_to_add |= defs.connections.getWireBit(face, d);
                ++num_placed;
            }
            if (num_placed == 0 && !(ostate = world.m_8055_(opos = pos.m_121945_(odir = dir.m_122424_()))).m_60803_() && !ostate.m_60803_()) {
                flags_to_add |= defs.connections.getWireBit(face, odir);
                ++num_placed;
            }
            if (num_placed > 0) {
                int n_added = te.addWireFlags(flags_to_add);
                te.sync(true);
                RedstonePenItem.popRedstone(pen, n_added, player, hand);
                te.updateConnections(2);
                te.updateAllPowerValuesFromAdjacent();
                this.updateNeighbourShapes(state, world, pos);
                this.notifyAdjacent(world, pos);
            }
        }

        private void disablePower(boolean disable) {
            this.can_provide_power_ = !disable;
        }

        private void updateNeighbourShapes(BlockState state, Level world, BlockPos pos) {
            state.m_60701_((LevelAccessor)world, pos, 3);
        }

        public void notifyAdjacent(Level world, BlockPos pos) {
            world.m_46672_(pos, (Block)this);
            for (Direction dir0 : BlockBehaviour.f_60441_) {
                BlockPos ppos = pos.m_121945_(dir0);
                world.m_46590_(ppos, world.m_8055_(ppos).m_60734_(), dir0.m_122424_());
                for (Direction dir1 : BlockBehaviour.f_60441_) {
                    BlockState diagonal_state;
                    if (dir0 == dir1.m_122424_()) {
                        return;
                    }
                    ppos = pos.m_121945_(dir0).m_121945_(dir1);
                    if (ppos == pos || (diagonal_state = world.m_8055_(ppos)).m_60734_() != this) continue;
                    world.m_46586_(ppos, (Block)this, pos);
                }
            }
        }
    }

    public static final class defs {
        public static final long STATE_FLAG_WIR_MASK = 0xFFFFFFL;
        public static final long STATE_FLAG_CON_MASK = 0x3F000000L;
        public static final long STATE_FLAG_PWR_MASK = 0xFFFFFF00000000L;
        public static final int STATE_FLAG_WIR_COUNT = 24;
        public static final int STATE_FLAG_CON_COUNT = 6;
        public static final int STATE_FLAG_WIR_POS = 0;
        public static final int STATE_FLAG_CON_POS = 24;
        public static final int STATE_FLAG_PWR_POS = 32;

        public static final class models {
            public static final ImmutableMap<Long, String> STATE_WIRE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)1L, (Object)"dn").put((Object)2L, (Object)"ds").put((Object)4L, (Object)"de").put((Object)8L, (Object)"dw").put((Object)16L, (Object)"un").put((Object)32L, (Object)"us").put((Object)64L, (Object)"ue").put((Object)128L, (Object)"uw").put((Object)256L, (Object)"nu").put((Object)512L, (Object)"nd").put((Object)1024L, (Object)"ne").put((Object)2048L, (Object)"nw").put((Object)4096L, (Object)"su").put((Object)8192L, (Object)"sd").put((Object)16384L, (Object)"se").put((Object)32768L, (Object)"sw").put((Object)65536L, (Object)"eu").put((Object)131072L, (Object)"ed").put((Object)262144L, (Object)"en").put((Object)524288L, (Object)"es").put((Object)0x100000L, (Object)"wu").put((Object)0x200000L, (Object)"wd").put((Object)0x400000L, (Object)"wn").put((Object)0x800000L, (Object)"ws").build();
            public static final ImmutableMap<Long, String> STATE_CONNECT_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)0x1000000L, (Object)"dc").put((Object)0x2000000L, (Object)"uc").put((Object)0x4000000L, (Object)"nc").put((Object)0x8000000L, (Object)"sc").put((Object)0x10000000L, (Object)"ec").put((Object)0x20000000L, (Object)"wc").build();
            public static final ImmutableMap<Long, String> STATE_CNTWIRE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)"none").put((Object)0x1000000L, (Object)"dm").put((Object)0x2000000L, (Object)"um").put((Object)0x4000000L, (Object)"nm").put((Object)0x8000000L, (Object)"sm").put((Object)0x10000000L, (Object)"em").put((Object)0x20000000L, (Object)"wm").build();
        }

        public static class shape {
            private static final double SHAPE_LAYER_THICKNESS = 0.01;
            private static final double SHAPE_TRACK_HALFWIDTH = 1.0;
            private static final VoxelShape DOWN_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(7.0, 0.0, 0.0, 9.0, 0.01, 16.0), Auxiliaries.getPixeledAABB(0.0, 0.0, 7.0, 16.0, 0.01, 9.0));
            private static final VoxelShape UP_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(7.0, 15.99, 0.0, 9.0, 16.0, 16.0), Auxiliaries.getPixeledAABB(0.0, 15.99, 7.0, 16.0, 16.0, 9.0));
            private static final VoxelShape WEST_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 0.0, 7.0, 0.01, 16.0, 9.0), Auxiliaries.getPixeledAABB(0.0, 7.0, 0.0, 0.01, 9.0, 16.0));
            private static final VoxelShape EAST_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(15.99, 0.0, 7.0, 16.0, 16.0, 9.0), Auxiliaries.getPixeledAABB(15.99, 7.0, 0.0, 16.0, 9.0, 16.0));
            private static final VoxelShape NORTH_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 7.0, 0.0, 16.0, 9.0, 0.01), Auxiliaries.getPixeledAABB(7.0, 0.0, 0.0, 9.0, 16.0, 0.01));
            private static final VoxelShape SOUTH_SHAPE = Auxiliaries.getUnionShape(Auxiliaries.getPixeledAABB(0.0, 7.0, 15.99, 16.0, 9.0, 16.0), Auxiliaries.getPixeledAABB(7.0, 0.0, 15.99, 9.0, 16.0, 16.0));
            private static final VoxelShape[] shape_cache = new VoxelShape[64];

            public static VoxelShape get(int faces) {
                if (shape_cache[faces] == null) {
                    VoxelShape shape2 = Shapes.m_83040_();
                    if ((faces & 1) != 0) {
                        shape2 = Shapes.m_83113_((VoxelShape)shape2, (VoxelShape)DOWN_SHAPE, (BooleanOp)BooleanOp.f_82695_);
                    }
                    if ((faces & 2) != 0) {
                        shape2 = Shapes.m_83113_((VoxelShape)shape2, (VoxelShape)UP_SHAPE, (BooleanOp)BooleanOp.f_82695_);
                    }
                    if ((faces & 4) != 0) {
                        shape2 = Shapes.m_83113_((VoxelShape)shape2, (VoxelShape)NORTH_SHAPE, (BooleanOp)BooleanOp.f_82695_);
                    }
                    if ((faces & 8) != 0) {
                        shape2 = Shapes.m_83113_((VoxelShape)shape2, (VoxelShape)SOUTH_SHAPE, (BooleanOp)BooleanOp.f_82695_);
                    }
                    if ((faces & 0x10) != 0) {
                        shape2 = Shapes.m_83113_((VoxelShape)shape2, (VoxelShape)EAST_SHAPE, (BooleanOp)BooleanOp.f_82695_);
                    }
                    if ((faces & 0x20) != 0) {
                        shape2 = Shapes.m_83113_((VoxelShape)shape2, (VoxelShape)WEST_SHAPE, (BooleanOp)BooleanOp.f_82695_);
                    }
                    shape.shape_cache[faces] = shape2;
                }
                return shape_cache[faces];
            }
        }

        public static final class connections {
            public static final Direction[] CONNECTION_BIT_ORDER = new Direction[]{Direction.DOWN, Direction.UP, Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST};
            public static final ImmutableMap<Direction, Integer> CONNECTION_BIT_ORDER_REV = new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)0).put((Object)Direction.UP, (Object)1).put((Object)Direction.NORTH, (Object)2).put((Object)Direction.SOUTH, (Object)3).put((Object)Direction.EAST, (Object)4).put((Object)Direction.WEST, (Object)5).build();
            public static final ImmutableMap<Long, Direction> BULK_FACE_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)Direction.DOWN).put((Object)0x1000000L, (Object)Direction.DOWN).put((Object)0x2000000L, (Object)Direction.UP).put((Object)0x4000000L, (Object)Direction.NORTH).put((Object)0x8000000L, (Object)Direction.SOUTH).put((Object)0x10000000L, (Object)Direction.EAST).put((Object)0x20000000L, (Object)Direction.WEST).build();
            public static final ImmutableMap<Direction, Long> BULK_FACE_MAPPING_REV = new ImmutableMap.Builder().put((Object)Direction.DOWN, (Object)0x1000000L).put((Object)Direction.UP, (Object)0x2000000L).put((Object)Direction.NORTH, (Object)0x4000000L).put((Object)Direction.SOUTH, (Object)0x8000000L).put((Object)Direction.EAST, (Object)0x10000000L).put((Object)Direction.WEST, (Object)0x20000000L).build();
            public static final ImmutableMap<Long, Tuple<Direction, Direction>> WIRE_FACE_DIRECTION_MAPPING = new ImmutableMap.Builder().put((Object)0L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.DOWN)).put((Object)1L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.NORTH)).put((Object)2L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.SOUTH)).put((Object)4L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.EAST)).put((Object)8L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.WEST)).put((Object)16L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.NORTH)).put((Object)32L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.SOUTH)).put((Object)64L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.EAST)).put((Object)128L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.WEST)).put((Object)256L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.UP)).put((Object)512L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.DOWN)).put((Object)1024L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.EAST)).put((Object)2048L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.WEST)).put((Object)4096L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.UP)).put((Object)8192L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.DOWN)).put((Object)16384L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.EAST)).put((Object)32768L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.WEST)).put((Object)65536L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.UP)).put((Object)131072L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.DOWN)).put((Object)262144L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.NORTH)).put((Object)524288L, (Object)new Tuple((Object)Direction.EAST, (Object)Direction.SOUTH)).put((Object)0x100000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.UP)).put((Object)0x200000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.DOWN)).put((Object)0x400000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.NORTH)).put((Object)0x800000L, (Object)new Tuple((Object)Direction.WEST, (Object)Direction.SOUTH)).build();
            public static final ImmutableMap<Long, Tuple<Direction, Direction>> INTERNAL_EDGE_CONNECTION_MAPPING = new ImmutableMap.Builder().put((Object)513L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.NORTH)).put((Object)8194L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.SOUTH)).put((Object)131076L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.EAST)).put((Object)0x200008L, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.WEST)).put((Object)272L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.NORTH)).put((Object)4128L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.SOUTH)).put((Object)65600L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.EAST)).put((Object)0x100080L, (Object)new Tuple((Object)Direction.UP, (Object)Direction.WEST)).put((Object)263168L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.EAST)).put((Object)0x400800L, (Object)new Tuple((Object)Direction.NORTH, (Object)Direction.WEST)).put((Object)540672L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.EAST)).put((Object)0x808000L, (Object)new Tuple((Object)Direction.SOUTH, (Object)Direction.WEST)).build();

            public static long getBulkConnectorBit(Direction face) {
                return (Long)BULK_FACE_MAPPING_REV.get((Object)face);
            }

            public static long getWireBit(Direction face, Direction wire_direction) {
                return WIRE_FACE_DIRECTION_MAPPING.entrySet().stream().filter(kv -> ((Tuple)kv.getValue()).m_14418_() == face && ((Tuple)kv.getValue()).m_14419_() == wire_direction).findFirst().map(Map.Entry::getKey).orElse(0L);
            }

            public static Tuple<Direction, Direction> getWireBitSideAndDirection(long wirebit) {
                return (Tuple)WIRE_FACE_DIRECTION_MAPPING.getOrDefault((Object)wirebit, (Object)new Tuple((Object)Direction.DOWN, (Object)Direction.DOWN));
            }

            public static List<Direction> getVanillaWireConnectionDirections(long mask) {
                if ((mask & 0xFL) == 0L) {
                    return Collections.emptyList();
                }
                ArrayList<Direction> r = new ArrayList<Direction>(4);
                if ((mask & 1L) != 0L) {
                    r.add(Direction.NORTH);
                }
                if ((mask & 2L) != 0L) {
                    r.add(Direction.SOUTH);
                }
                if ((mask & 4L) != 0L) {
                    r.add(Direction.EAST);
                }
                if ((mask & 8L) != 0L) {
                    r.add(Direction.WEST);
                }
                return r;
            }

            public static boolean hasVanillaWireConnection(long mask, Direction side) {
                return switch (side) {
                    case Direction.NORTH -> {
                        if ((mask & 1L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.SOUTH -> {
                        if ((mask & 2L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.EAST -> {
                        if ((mask & 4L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.WEST -> {
                        if ((mask & 8L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
            }

            public static boolean hasBulkConnection(long mask, Direction side) {
                return ((Long)BULK_FACE_MAPPING_REV.get((Object)side) & mask) != 0L;
            }

            public static boolean hasRedstoneConnection(long mask, Direction side) {
                return switch (side) {
                    default -> throw new IncompatibleClassChangeError();
                    case Direction.DOWN -> {
                        if ((mask & 0x1222200L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.UP -> {
                        if ((mask & 0x2111100L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.NORTH -> {
                        if ((mask & 0x4440011L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.SOUTH -> {
                        if ((mask & 0x8880022L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.EAST -> {
                        if ((mask & 0x10004444L) != 0L) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.WEST -> (mask & 0x20008888L) != 0L;
                };
            }

            public static long getWireElementsOnFace(Direction face) {
                return 15L << (Integer)CONNECTION_BIT_ORDER_REV.get((Object)face) * 4 + 0;
            }

            public static long getAllElementsOnFace(Direction face) {
                int index = (Integer)CONNECTION_BIT_ORDER_REV.get((Object)face);
                return 15L << index * 4 + 0 | 1L << index + 24;
            }
        }
    }
}

