/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.device.IFluxDevice;
import sonar.fluxnetworks.api.energy.IBlockEnergyAdapter;
import sonar.fluxnetworks.api.energy.IItemEnergyAdapter;
import sonar.fluxnetworks.common.integration.energy.FNEnergyAdapter;
import sonar.fluxnetworks.common.integration.energy.ForgeEnergyAdapter;

public final class EnergyUtils {
    private static final Marker MARKER = MarkerManager.getMarker((String)"Energy");
    private static final List<IBlockEnergyAdapter> BLOCK_ENERGY_ADAPTERS = new ArrayList<IBlockEnergyAdapter>();
    private static final Set<Block> BLOCK_BLACKLIST = new HashSet<Block>();
    private static final List<IItemEnergyAdapter> ITEM_ENERGY_ADAPTERS = new ArrayList<IItemEnergyAdapter>();
    private static final Set<Item> ITEM_BLACKLIST = new HashSet<Item>();

    private EnergyUtils() {
    }

    public static void reloadBlacklist(@Nonnull List<String> blockBlacklist, @Nonnull List<String> itemBlacklist) {
        BLOCK_BLACKLIST.clear();
        for (String s : blockBlacklist) {
            if (s == null || s.isEmpty()) continue;
            try {
                Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(s));
                if (block == null) continue;
                BLOCK_BLACKLIST.add(block);
            }
            catch (Exception e) {
                FluxNetworks.LOGGER.warn(MARKER, "Block blacklist error: {} has incorrect formatting", (Object)s, (Object)e);
            }
        }
        ITEM_BLACKLIST.clear();
        for (String s : itemBlacklist) {
            if (s == null || s.isEmpty()) continue;
            try {
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(s));
                if (item == null) continue;
                ITEM_BLACKLIST.add(item);
            }
            catch (Exception e) {
                FluxNetworks.LOGGER.warn(MARKER, "Item blacklist error: {} has incorrect formatting", (Object)s, (Object)e);
            }
        }
        FluxNetworks.LOGGER.info(MARKER, "Energy blacklist loaded: {} block entries, {} item entries", (Object)BLOCK_BLACKLIST.size(), (Object)ITEM_BLACKLIST.size());
    }

    @Nullable
    public static IBlockEnergyAdapter getAdapter(@Nullable BlockEntity target, @Nonnull Direction side) {
        if (target == null) {
            return null;
        }
        if (target.m_58901_()) {
            return null;
        }
        if (target instanceof IFluxDevice) {
            return null;
        }
        if (BLOCK_BLACKLIST.contains(target.m_58900_().m_60734_())) {
            return null;
        }
        for (IBlockEnergyAdapter adapter : BLOCK_ENERGY_ADAPTERS) {
            if (!adapter.hasCapability(target, side)) continue;
            return adapter;
        }
        return null;
    }

    @Nullable
    public static IItemEnergyAdapter getAdapter(@Nullable ItemStack stack) {
        if (stack == null) {
            return null;
        }
        if (stack.m_41619_()) {
            return null;
        }
        if (ITEM_BLACKLIST.contains(stack.m_41720_())) {
            return null;
        }
        for (IItemEnergyAdapter adapter : ITEM_ENERGY_ADAPTERS) {
            if (!adapter.hasCapability(stack)) continue;
            return adapter;
        }
        return null;
    }

    static {
        BLOCK_ENERGY_ADAPTERS.add(FNEnergyAdapter.INSTANCE);
        ITEM_ENERGY_ADAPTERS.add(FNEnergyAdapter.INSTANCE);
        BLOCK_ENERGY_ADAPTERS.add(ForgeEnergyAdapter.INSTANCE);
        ITEM_ENERGY_ADAPTERS.add(ForgeEnergyAdapter.INSTANCE);
    }
}

