/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.common.integration.energy;

import javax.annotation.Nonnull;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.IEnergyStorage;
import sonar.fluxnetworks.api.energy.IBlockEnergyAdapter;
import sonar.fluxnetworks.api.energy.IItemEnergyAdapter;
import sonar.fluxnetworks.common.util.FluxUtils;

public class ForgeEnergyAdapter
implements IBlockEnergyAdapter,
IItemEnergyAdapter {
    public static final ForgeEnergyAdapter INSTANCE = new ForgeEnergyAdapter();

    private ForgeEnergyAdapter() {
    }

    @Override
    public boolean hasCapability(@Nonnull BlockEntity target, @Nonnull Direction side) {
        return !target.m_58901_() && target.getCapability(ForgeCapabilities.ENERGY, side).isPresent();
    }

    @Override
    public boolean canSendTo(@Nonnull BlockEntity target, @Nonnull Direction side) {
        if (!target.m_58901_()) {
            IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)target, ForgeCapabilities.ENERGY, side);
            return storage != null && storage.canReceive();
        }
        return false;
    }

    @Override
    public boolean canReceiveFrom(@Nonnull BlockEntity target, @Nonnull Direction side) {
        if (!target.m_58901_()) {
            IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)target, ForgeCapabilities.ENERGY, side);
            return storage != null && storage.canExtract();
        }
        return false;
    }

    @Override
    public long sendTo(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)target, ForgeCapabilities.ENERGY, side);
        return storage == null ? 0L : (long)storage.receiveEnergy((int)Math.min(amount, Integer.MAX_VALUE), simulate);
    }

    @Override
    public long receiveFrom(long amount, @Nonnull BlockEntity target, @Nonnull Direction side, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)target, ForgeCapabilities.ENERGY, side);
        return storage == null ? 0L : (long)storage.extractEnergy((int)Math.min(amount, Integer.MAX_VALUE), simulate);
    }

    @Override
    public boolean hasCapability(@Nonnull ItemStack stack) {
        return !stack.m_41619_() && stack.getCapability(ForgeCapabilities.ENERGY).isPresent();
    }

    @Override
    public boolean canSendTo(@Nonnull ItemStack stack) {
        if (!stack.m_41619_()) {
            IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
            return storage != null && storage.canReceive();
        }
        return false;
    }

    @Override
    public boolean canReceiveFrom(@Nonnull ItemStack stack) {
        if (!stack.m_41619_()) {
            IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
            return storage != null && storage.canExtract();
        }
        return false;
    }

    @Override
    public long sendTo(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
        return storage == null ? 0L : (long)storage.receiveEnergy((int)Math.min(amount, Integer.MAX_VALUE), simulate);
    }

    @Override
    public long receiveFrom(long amount, @Nonnull ItemStack stack, boolean simulate) {
        IEnergyStorage storage = (IEnergyStorage)FluxUtils.get((ICapabilityProvider)stack, ForgeCapabilities.ENERGY);
        return storage == null ? 0L : (long)storage.extractEnergy((int)Math.min(amount, Integer.MAX_VALUE), simulate);
    }
}

