/*
 * Decompiled with CFR 0.152.
 */
package sonar.fluxnetworks.client.jei;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Quaternion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ITickTimer;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.model.ItemTransforms;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraftforge.client.model.data.ModelData;
import sonar.fluxnetworks.FluxNetworks;
import sonar.fluxnetworks.api.FluxTranslate;
import sonar.fluxnetworks.client.jei.CreatingFluxRecipe;
import sonar.fluxnetworks.register.RegistryBlocks;
import sonar.fluxnetworks.register.RegistryItems;

public class CreatingFluxRecipeCategory
implements IRecipeCategory<CreatingFluxRecipe> {
    public static final ResourceLocation TEXTURES = FluxNetworks.location("textures/gui/gui_creating_flux_recipe.png");
    public static final RecipeType<CreatingFluxRecipe> RECIPE_TYPE = RecipeType.create((String)"fluxnetworks", (String)"creating_flux", CreatingFluxRecipe.class);
    private final IDrawable background;
    private final IDrawable icon;
    private final ITickTimer timer;

    public CreatingFluxRecipeCategory(@Nonnull IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(TEXTURES, 0, -20, 128, 80);
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get()));
        this.timer = guiHelper.createTickTimer(60, 320, false);
    }

    @Nonnull
    public static List<CreatingFluxRecipe> getRecipes() {
        ArrayList<CreatingFluxRecipe> recipes = new ArrayList<CreatingFluxRecipe>();
        recipes.add(new CreatingFluxRecipe(Blocks.f_50752_, Blocks.f_50080_, new ItemStack((ItemLike)Items.f_42451_), new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get())));
        recipes.add(new CreatingFluxRecipe((Block)RegistryBlocks.FLUX_BLOCK.get(), Blocks.f_50080_, new ItemStack((ItemLike)Items.f_42451_), new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get())));
        return recipes;
    }

    @Nonnull
    public static List<ItemStack> getCatalysts() {
        return List.of(new ItemStack((ItemLike)RegistryItems.FLUX_DUST.get()));
    }

    @Nonnull
    public RecipeType<CreatingFluxRecipe> getRecipeType() {
        return RECIPE_TYPE;
    }

    @Nonnull
    public Component getTitle() {
        return FluxTranslate.JEI_CREATING_FLUX.getComponent();
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull CreatingFluxRecipe recipe, @Nonnull IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.INPUT, 9, 25).addItemStack(recipe.input());
        builder.addSlot(RecipeIngredientRole.OUTPUT, 103, 25).addItemStack(recipe.output());
    }

    @Nonnull
    public List<Component> getTooltipStrings(@Nonnull CreatingFluxRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        if (mouseX >= 40.0 && mouseX < 80.0 && mouseY >= 10.0 && mouseY < 64.0) {
            return List.of(Component.m_237113_((String)"Y+2 = ").m_7220_((Component)recipe.crusher().m_49954_()), Component.m_237113_((String)"Y+1 = ").m_7220_(recipe.input().m_41786_()), Component.m_237113_((String)"Y+0 = ").m_7220_((Component)recipe.base().m_49954_()));
        }
        return Collections.emptyList();
    }

    public void draw(@Nonnull CreatingFluxRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, @Nonnull PoseStack poseStack, double mouseX, double mouseY) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.m_91087_().m_91269_().m_110104_();
        ItemRenderer itemRenderer = Minecraft.m_91087_().m_91291_();
        BlockRenderDispatcher dispatcher = Minecraft.m_91087_().m_91289_();
        poseStack.m_85836_();
        int value = this.timer.getValue();
        double offset = (float)(value > 160 ? 160 - (value - 160) : value) / 10.0f;
        poseStack.m_85837_(52.0, 10.0 + offset, 128.0);
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        poseStack.m_85845_(new Quaternion(30.0f, 45.0f, 0.0f, true));
        dispatcher.renderSingleBlock(recipe.crusher().m_49966_(), poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, null);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(52.0, 40.0, 96.0);
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        poseStack.m_85845_(new Quaternion(30.0f, 45.0f, 0.0f, true));
        dispatcher.renderSingleBlock(recipe.base().m_49966_(), poseStack, (MultiBufferSource)bufferSource, 0xF000F0, OverlayTexture.f_118083_, ModelData.EMPTY, null);
        poseStack.m_85849_();
        poseStack.m_85836_();
        poseStack.m_85837_(63.0, 36.0, 112.0);
        poseStack.m_85841_(16.0f, -16.0f, 16.0f);
        ItemStack toDisplay = value > 160 ? recipe.output() : recipe.input();
        poseStack.m_85845_(new Quaternion(toDisplay.m_41720_() instanceof BlockItem ? 30.0f : 0.0f, -90.0f + 180.0f * ((float)value / (float)this.timer.getMaxValue()), 0.0f, true));
        itemRenderer.m_174269_(toDisplay, ItemTransforms.TransformType.FIXED, 0xF000F0, OverlayTexture.f_118083_, poseStack, (MultiBufferSource)bufferSource, 0);
        poseStack.m_85849_();
        bufferSource.m_109911_();
        Font fontRenderer = Minecraft.m_91087_().f_91062_;
        String help = FluxTranslate.JEI_LEFT_CLICK.format(recipe.crusher().m_49954_().getString());
        fontRenderer.m_92883_(poseStack, help, 64.0f - (float)fontRenderer.m_92895_(help) / 2.0f, 68.0f, -12566464);
    }
}

