/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.trades;

import java.util.Arrays;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.event.village.VillagerTradesEvent;
import net.minecraftforge.event.village.WandererTradesEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.scroll.ScrollItem;
import se.mickelus.tetra.items.forged.BoltItem;
import se.mickelus.tetra.items.forged.CombustionChamberItem;
import se.mickelus.tetra.items.forged.EarthpiercerItem;
import se.mickelus.tetra.items.forged.InsulatedPlateItem;
import se.mickelus.tetra.items.forged.LubricantDispenserItem;
import se.mickelus.tetra.items.forged.QuickLatchItem;
import se.mickelus.tetra.items.forged.StonecutterItem;
import se.mickelus.tetra.trades.ItemsForEmeraldsAndScrapTrade;
import se.mickelus.tetra.trades.ItemsForEmeraldsTrade;
import se.mickelus.tetra.trades.ItemsForScrapTrade;

@ParametersAreNonnullByDefault
public class TradeHandler {
    private static void add(VillagerTradesEvent event, int level, VillagerTrades.ItemListing ... listings) {
        ((List)event.getTrades().get(level)).addAll(Arrays.asList(listings));
    }

    @SubscribeEvent
    public void setupWandererTrades(WandererTradesEvent event) {
        List generic = event.getGenericTrades();
        List rare = event.getRareTrades();
        generic.add(new ItemsForScrapTrade(InsulatedPlateItem.instance, 1, 24, 1));
        generic.add(new ItemsForEmeraldsAndScrapTrade((ItemLike)LubricantDispenserItem.instance.get(), 1, 8, 16, 1));
        generic.add(new ItemsForEmeraldsAndScrapTrade((ItemLike)QuickLatchItem.instance, 1, 5, 16, 1));
        generic.add(new ItemsForScrapTrade(BoltItem.instance, 1, 32, 2));
        rare.add(new ItemsForEmeraldsAndScrapTrade((ItemLike)StonecutterItem.instance, 1, 32, 16, 1));
        rare.add(new ItemsForEmeraldsAndScrapTrade((ItemLike)EarthpiercerItem.instance, 1, 24, 16, 1));
        rare.add(new ItemsForEmeraldsAndScrapTrade((ItemLike)CombustionChamberItem.instance.get(), 1, 25, 16, 1));
        rare.add(new ItemsForEmeraldsAndScrapTrade((ItemLike)ChthonicExtractorBlock.instance, 1, 8, 16, 5));
    }

    @SubscribeEvent
    public void setupVillagerTrades(VillagerTradesEvent event) {
        VillagerProfession profession = event.getType();
        if (VillagerProfession.f_35598_.equals((Object)profession)) {
            TradeHandler.add(event, 2, new ItemsForEmeraldsTrade(ScrollItem.hammerEfficiency, 4, 1, 1, 5));
            TradeHandler.add(event, 5, new ItemsForEmeraldsTrade(ScrollItem.metalExpertise, 8, 1, 1, 20));
        }
        if (VillagerProfession.f_35599_.equals((Object)profession)) {
            TradeHandler.add(event, 3, new ItemsForEmeraldsTrade(ScrollItem.hammerEfficiency, 4, 1, 1, 10));
            TradeHandler.add(event, 5, new ItemsForEmeraldsTrade(ScrollItem.metalExpertise, 8, 1, 1, 20));
        }
        if (VillagerProfession.f_35586_.equals((Object)profession)) {
            TradeHandler.add(event, 4, new ItemsForEmeraldsTrade(ScrollItem.hammerEfficiency, 4, 1, 1, 10));
            TradeHandler.add(event, 5, new ItemsForEmeraldsTrade(ScrollItem.metalExpertise, 8, 1, 1, 20));
        }
        if (VillagerProfession.f_35592_.equals((Object)profession)) {
            TradeHandler.add(event, 2, new ItemsForEmeraldsTrade(ScrollItem.axeEfficiency, 4, 1, 1, 5));
            TradeHandler.add(event, 3, new ItemsForEmeraldsTrade(ScrollItem.woodExpertise, 8, 1, 1, 15));
            TradeHandler.add(event, 4, new ItemsForEmeraldsTrade(ScrollItem.fibreExpertise, 8, 1, 1, 20));
        }
        if (VillagerProfession.f_35593_.equals((Object)profession)) {
            TradeHandler.add(event, 3, new ItemsForEmeraldsTrade(ScrollItem.cutEfficiency, 4, 1, 1, 10));
            TradeHandler.add(event, 4, new ItemsForEmeraldsTrade(ScrollItem.scaleExpertise, 8, 1, 1, 20));
            TradeHandler.add(event, 5, new ItemsForEmeraldsTrade(ScrollItem.skinExpertise, 8, 1, 1, 20));
        }
        if (VillagerProfession.f_35595_.equals((Object)profession)) {
            TradeHandler.add(event, 2, new ItemsForEmeraldsTrade(ScrollItem.stoneExpertise, 8, 1, 1, 5));
            TradeHandler.add(event, 5, new ItemsForEmeraldsTrade(ScrollItem.gemExpertise, 8, 1, 1, 20));
        }
        if (VillagerProfession.f_35597_.equals((Object)profession)) {
            TradeHandler.add(event, 5, new ItemsForEmeraldsTrade(ScrollItem.fabricExpertise, 16, 1, 1, 20));
        }
        if (VillagerProfession.f_35587_.equals((Object)profession)) {
            TradeHandler.add(event, 4, new ItemsForEmeraldsTrade(ScrollItem.boneExpertise, 16, 1, 1, 20));
        }
    }
}

