/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.module.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class TierData<T> {
    public Map<T, Float> levelMap = new HashMap<T, Float>();
    public Map<T, Float> efficiencyMap = new HashMap<T, Float>();

    public boolean contains(T key) {
        return this.levelMap.containsKey(key);
    }

    public int getLevel(T key) {
        if (this.contains(key)) {
            return Math.round(this.levelMap.get(key).floatValue());
        }
        return 0;
    }

    public Map<T, Integer> getLevelMap() {
        return this.levelMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> Math.round(((Float)e.getValue()).floatValue())));
    }

    public float getEfficiency(T key) {
        if (this.efficiencyMap.containsKey(key)) {
            return this.efficiencyMap.get(key).floatValue();
        }
        return 0.0f;
    }

    public Set<T> getValues() {
        return this.levelMap.keySet();
    }
}

