/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui;

import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiRoot;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.OverlayGuiPotionGroup;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.OverlayGuiQuickslotGroup;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.OverlayGuiQuiverGroup;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.PotionsInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuickslotInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.QuiverInventory;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltSlotType;

@ParametersAreNonnullByDefault
public class OverlayGuiToolbelt
extends GuiRoot {
    private final OverlayGuiQuickslotGroup quickslotGroup = new OverlayGuiQuickslotGroup(42, 0);
    private final OverlayGuiPotionGroup potionGroup;
    private final OverlayGuiQuiverGroup quiverGroup;

    public OverlayGuiToolbelt(Minecraft mc) {
        super(mc);
        this.addChild(this.quickslotGroup);
        this.potionGroup = new OverlayGuiPotionGroup(0, 30);
        this.addChild(this.potionGroup);
        this.quiverGroup = new OverlayGuiQuiverGroup(-30, -30);
        this.addChild(this.quiverGroup);
    }

    public void setInventories(ItemStack itemStack) {
        this.quickslotGroup.setInventory(new QuickslotInventory(itemStack));
        this.potionGroup.setInventory(new PotionsInventory(itemStack));
        this.quiverGroup.setInventory(new QuiverInventory(itemStack));
    }

    public void setVisible(boolean visible) {
        if (visible) {
            this.quickslotGroup.setVisible(true);
            this.potionGroup.setVisible(true);
            this.quiverGroup.setVisible(true);
        } else {
            this.quickslotGroup.setVisible(false);
            this.potionGroup.setVisible(false);
            this.quiverGroup.setVisible(false);
        }
    }

    public void draw(PoseStack poseStack) {
        if (this.isVisible()) {
            Window window = this.mc.m_91268_();
            int width = window.m_85445_();
            int height = window.m_85446_();
            int mouseX = (int)(this.mc.f_91067_.m_91589_() * (double)window.m_85445_() / (double)window.m_85443_());
            int mouseY = (int)(this.mc.f_91067_.m_91594_() * (double)window.m_85446_() / (double)window.m_85444_());
            this.updateFocusState(width / 2, height / 2, mouseX, mouseY);
            this.drawChildren(new PoseStack(), width / 2, height / 2, 0, 0, mouseX, mouseY, 1.0f);
        }
    }

    public ToolbeltSlotType getFocusType() {
        if (this.quickslotGroup.getFocus() != -1) {
            return ToolbeltSlotType.quickslot;
        }
        if (this.potionGroup.getFocus() != -1) {
            return ToolbeltSlotType.potion;
        }
        if (this.quiverGroup.getFocus() != -1) {
            return ToolbeltSlotType.quiver;
        }
        return ToolbeltSlotType.quickslot;
    }

    public int getFocusIndex() {
        int quickslotFocus = this.quickslotGroup.getFocus();
        if (quickslotFocus != -1) {
            return quickslotFocus;
        }
        int potionFocus = this.potionGroup.getFocus();
        if (potionFocus != -1) {
            return potionFocus;
        }
        int quiverFocus = this.quiverGroup.getFocus();
        return quiverFocus;
    }

    public InteractionHand getFocusHand() {
        InteractionHand quickslotHand = this.quickslotGroup.getHand();
        if (quickslotHand != null) {
            return quickslotHand;
        }
        InteractionHand potionHand = this.potionGroup.getHand();
        if (potionHand != null) {
            return potionHand;
        }
        InteractionHand quiverHand = this.quiverGroup.getHand();
        if (quiverHand != null) {
            return quiverHand;
        }
        return InteractionHand.OFF_HAND;
    }
}

