/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt.gui;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import se.mickelus.mutil.gui.GuiAttachment;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.OverlayGuiPotionSlot;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.PotionsInventory;

@ParametersAreNonnullByDefault
public class OverlayGuiPotionGroup
extends GuiElement {
    GuiString focusSlot;
    PotionsInventory inventory;
    private OverlayGuiPotionSlot[] slots = new OverlayGuiPotionSlot[0];

    public OverlayGuiPotionGroup(int x, int y) {
        super(x, y, 0, 0);
        this.setAttachmentPoint(GuiAttachment.topCenter);
        this.focusSlot = new GuiString(0, -15, "");
        this.focusSlot.setAttachmentPoint(GuiAttachment.topCenter);
        this.focusSlot.setAttachmentAnchor(GuiAttachment.topCenter);
    }

    public void setInventory(PotionsInventory inventory) {
        this.clearChildren();
        this.inventory = inventory;
        int numSlots = inventory.m_6643_();
        this.slots = new OverlayGuiPotionSlot[numSlots];
        this.focusSlot.setString("");
        this.addChild((GuiElement)this.focusSlot);
        this.width = 66;
        if (numSlots > 5) {
            this.height = 44;
        } else if (numSlots > 3) {
            this.height = 33;
        } else {
            this.width = numSlots * 22;
            this.height = 22;
        }
        for (int i = 0; i < numSlots; ++i) {
            ItemStack itemStack = inventory.m_8020_(i);
            if (itemStack.m_41619_()) continue;
            this.slots[i] = i > 6 ? new OverlayGuiPotionSlot(22, 22, itemStack, i, true) : (i > 4 ? new OverlayGuiPotionSlot((i - 5) * 22 + 11, -11, itemStack, i, true) : (i > 2 ? new OverlayGuiPotionSlot((i - 3) * 22 + 11, 11, itemStack, i, true) : new OverlayGuiPotionSlot(i * 22, 0, itemStack, i, true)));
            this.addChild(this.slots[i]);
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            Arrays.stream(this.slots).filter(Objects::nonNull).forEach(item -> item.setVisible(true));
        } else {
            Arrays.stream(this.slots).filter(Objects::nonNull).forEach(item -> item.setVisible(false));
        }
        this.focusSlot.setVisible(visible);
    }

    public void draw(PoseStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        super.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        int focus = this.getFocus();
        if (focus != -1) {
            this.focusSlot.setString(this.inventory.m_8020_(focus).m_41786_().getString());
        } else {
            this.focusSlot.setString("");
        }
    }

    public int getFocus() {
        for (int i = 0; i < this.slots.length; ++i) {
            OverlayGuiPotionSlot element = this.slots[i];
            if (element == null || !element.hasFocus()) continue;
            return element.getSlot();
        }
        return -1;
    }

    public InteractionHand getHand() {
        return null;
    }
}

