/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.toolbelt;

import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.gui.overlay.ForgeGui;
import net.minecraftforge.client.gui.overlay.IGuiOverlay;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.items.modular.impl.toolbelt.EquipToolbeltItemPacket;
import se.mickelus.tetra.items.modular.impl.toolbelt.OpenToolbeltItemPacket;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltHelper;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltKeyMappings;
import se.mickelus.tetra.items.modular.impl.toolbelt.gui.OverlayGuiToolbelt;
import se.mickelus.tetra.items.modular.impl.toolbelt.inventory.ToolbeltSlotType;

@ParametersAreNonnullByDefault
public class ToolbeltOverlay
implements IGuiOverlay {
    private final Minecraft mc;
    private final OverlayGuiToolbelt gui;
    private long openTime = -1L;
    private boolean isActive = false;

    public ToolbeltOverlay(Minecraft mc) {
        this.mc = mc;
        this.gui = new OverlayGuiToolbelt(mc);
    }

    @SubscribeEvent
    public void onKeyInput(InputEvent.Key event) {
        if (ToolbeltKeyMappings.restockBinding.m_90857_()) {
            this.equipToolbeltItem(ToolbeltSlotType.quickslot, -1, InteractionHand.OFF_HAND);
        } else if (ToolbeltKeyMappings.openBinding.m_90857_()) {
            this.openToolbelt();
        } else if (ToolbeltKeyMappings.accessBinding.m_90857_() && this.mc.m_91302_() && !this.isActive) {
            this.showView();
        }
    }

    public void render(ForgeGui gui, PoseStack poseStack, float partialTick, int screenWidth, int screenHeight) {
        if (!ToolbeltKeyMappings.accessBinding.m_90857_() && this.isActive) {
            this.hideView();
        }
        this.gui.draw();
    }

    private void showView() {
        boolean canOpen = this.updateGuiData();
        if (canOpen) {
            this.mc.f_91067_.m_91602_();
            this.isActive = true;
            this.openTime = System.currentTimeMillis();
        }
    }

    private void hideView() {
        this.gui.setVisible(false);
        this.mc.f_91067_.m_91601_();
        this.isActive = false;
        int focusIndex = this.findIndex();
        if (focusIndex != -1) {
            this.equipToolbeltItem(this.findSlotType(), focusIndex, this.getHand());
        } else if (System.currentTimeMillis() - this.openTime < 500L) {
            this.quickEquip();
        }
    }

    private void equipToolbeltItem(ToolbeltSlotType slotType, int toolbeltItemIndex, InteractionHand hand) {
        EquipToolbeltItemPacket packet = new EquipToolbeltItemPacket(slotType, toolbeltItemIndex, hand);
        TetraMod.packetHandler.sendToServer((AbstractPacket)packet);
        if (toolbeltItemIndex > -1) {
            ToolbeltHelper.equipItemFromToolbelt((Player)this.mc.f_91074_, slotType, toolbeltItemIndex, hand);
        } else {
            boolean storeItemSuccess = ToolbeltHelper.storeItemInToolbelt((Player)this.mc.f_91074_);
            if (!storeItemSuccess) {
                this.mc.f_91074_.m_5661_((Component)Component.m_237115_((String)"tetra.toolbelt.full"), true);
            }
        }
    }

    private void quickEquip() {
        BlockHitResult raytrace;
        BlockState blockState;
        int index;
        if (this.mc.f_91077_.m_6662_() == HitResult.Type.BLOCK && (index = ToolbeltHelper.getQuickAccessSlotIndex((Player)this.mc.f_91074_, this.mc.f_91077_, blockState = this.mc.f_91073_.m_8055_((raytrace = (BlockHitResult)this.mc.f_91077_).m_82425_()))) > -1) {
            this.equipToolbeltItem(ToolbeltSlotType.quickslot, index, InteractionHand.MAIN_HAND);
        }
    }

    private boolean openToolbelt() {
        ItemStack itemStack = ToolbeltHelper.findToolbelt((Player)this.mc.f_91074_);
        if (!itemStack.m_41619_()) {
            TetraMod.packetHandler.sendToServer((AbstractPacket)new OpenToolbeltItemPacket());
        }
        return !itemStack.m_41619_();
    }

    private boolean updateGuiData() {
        ItemStack itemStack = ToolbeltHelper.findToolbelt((Player)this.mc.f_91074_);
        if (!itemStack.m_41619_()) {
            this.gui.setInventories(itemStack);
            this.gui.setVisible(true);
            return true;
        }
        return false;
    }

    private int findIndex() {
        return this.gui.getFocusIndex();
    }

    private InteractionHand getHand() {
        return this.gui.getFocusHand();
    }

    private ToolbeltSlotType findSlotType() {
        return this.gui.getFocusType();
    }
}

