/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiString;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.gui.stats.sorting.IStatSorter;
import se.mickelus.tetra.gui.stats.sorting.StatSorters;
import se.mickelus.tetra.items.modular.impl.holo.gui.craft.HoloSortPopover;
import se.mickelus.tetra.module.schematic.OutcomePreview;

@ParametersAreNonnullByDefault
public class HoloSortButton
extends GuiElement {
    private final List<Component> tooltip;
    private final GuiString label;
    private final GuiTexture icon;
    private final HoloSortPopover popover;
    Consumer<IStatSorter> onSelect;

    public HoloSortButton(int x, int y, Consumer<IStatSorter> onSelect) {
        super(x, y, 36, 9);
        this.onSelect = onSelect;
        this.icon = new GuiTexture(0, 1, 9, 9, 233, 0, GuiTextures.workbench);
        this.addChild((GuiElement)this.icon);
        this.label = new GuiString(11, 0, this.width - 11, "");
        this.addChild((GuiElement)this.label);
        this.popover = new HoloSortPopover(0, 11, this::onSelect);
        this.addChild(this.popover);
        this.tooltip = Collections.singletonList(Component.m_237115_((String)"tetra.holo.craft.variants_sort"));
    }

    public void update(OutcomePreview[] previews) {
        this.label.setString(StatSorters.none.getName());
        if (previews.length > 0) {
            LocalPlayer player = Minecraft.m_91087_().f_91074_;
            this.popover.update((IStatSorter[])StatSorters.sorters.stream().filter(arg_0 -> HoloSortButton.lambda$update$1(previews, (Player)player, arg_0)).toArray(IStatSorter[]::new));
        }
        this.popover.setVisible(false);
        this.icon.setColor(0xFFFFFF);
        this.label.setColor(0xFFFFFF);
    }

    private void onSelect(IStatSorter sorter) {
        String name = sorter.getName();
        this.label.setString(name.length() > 4 ? name.substring(0, 4) : name);
        this.icon.setColor(0xFFFFFF);
        this.label.setColor(0xFFFFFF);
        this.onSelect.accept(sorter);
    }

    public boolean onMouseClick(int x, int y, int button) {
        if (this.hasFocus()) {
            this.togglePopover(!this.popover.isVisible());
            return true;
        }
        return super.onMouseClick(x, y, button);
    }

    public List<Component> getTooltipLines() {
        if (this.hasFocus() && !this.popover.isVisible()) {
            return this.tooltip;
        }
        return null;
    }

    private void togglePopover(boolean visible) {
        this.icon.setColor(visible ? 0xFFFFCC : 0xFFFFFF);
        this.label.setColor(visible ? 0xFFFFCC : 0xFFFFFF);
        this.popover.setVisible(visible);
    }

    public boolean isBlockingFocus() {
        return this.popover.isVisible() && this.popover.hasFocus();
    }

    public boolean onCharType(char character, int modifiers) {
        if (character == 's') {
            this.togglePopover(!this.popover.isVisible());
            return true;
        }
        return super.onCharType(character, modifiers);
    }

    public void reset() {
        this.label.setString(StatSorters.none.getName());
    }

    private static /* synthetic */ boolean lambda$update$1(OutcomePreview[] previews, Player player, IStatSorter sorter) {
        return Arrays.stream(previews).anyMatch(preview -> sorter.getWeight(player, preview.itemStack) > 0);
    }
}

