/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.holo.gui.craft;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.registries.ForgeRegistries;
import se.mickelus.mutil.gui.GuiElement;
import se.mickelus.mutil.gui.GuiTexture;
import se.mickelus.tetra.ClientScheduler;
import se.mickelus.tetra.gui.GuiTextures;
import se.mickelus.tetra.items.modular.IModularItem;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;
import se.mickelus.tetra.items.modular.impl.holo.gui.HoloGui;
import se.mickelus.tetra.module.schematic.SchematicRarity;
import se.mickelus.tetra.module.schematic.SchematicType;
import se.mickelus.tetra.module.schematic.UpgradeSchematic;

@ParametersAreNonnullByDefault
public class HoloMaterialApplicable
extends GuiElement {
    private final List<Component> emptyTooltip;
    private final GuiTexture icon = new GuiTexture(0, 0, 9, 9, 215, 0, GuiTextures.workbench);
    private List<Component> tooltip;
    private IModularItem item;
    private String slot;
    private UpgradeSchematic schematic;

    public HoloMaterialApplicable(int x, int y) {
        super(x, y, 9, 9);
        this.addChild((GuiElement)this.icon);
        this.emptyTooltip = Collections.singletonList(Component.m_237115_((String)"tetra.holo.craft.empty_applicable_materials"));
    }

    public List<Component> getTooltipLines() {
        if (this.hasFocus()) {
            return this.tooltip;
        }
        return null;
    }

    public void update(ItemStack itemStack, String slot, UpgradeSchematic schematic, Player playerEntity) {
        this.item = null;
        this.slot = null;
        this.schematic = null;
        this.tooltip = new ArrayList<Component>();
        String[] materials = schematic.getApplicableMaterials();
        if (materials != null && materials.length > 0) {
            String materialsString = Arrays.stream(materials).map(mat -> {
                if (mat.startsWith("#")) {
                    return I18n.m_118938_((String)("tetra.variant_category." + mat.substring(1) + ".label"), (Object[])new Object[0]);
                }
                if (mat.startsWith("!")) {
                    return I18n.m_118938_((String)("tetra.material." + mat.substring(1)), (Object[])new Object[0]);
                }
                return Optional.ofNullable((Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(mat))).map(Item::m_41466_).map(Component::getString).orElse((String)mat);
            }).collect(Collectors.joining(", "));
            this.tooltip.add((Component)Component.m_237115_((String)"tetra.holo.craft.applicable_materials"));
            this.tooltip.add((Component)Component.m_237113_((String)materialsString).m_130940_(ChatFormatting.GRAY));
            this.tooltip.add((Component)Component.m_237113_((String)""));
            if (schematic.getType() != SchematicType.major && schematic.getType() != SchematicType.minor || schematic.getRarity() != SchematicRarity.basic) {
                this.tooltip.add((Component)Component.m_237115_((String)"tetra.holo.craft.holosphere_shortcut_disabled"));
                this.tooltip.add((Component)Component.m_237115_((String)"tetra.holo.craft.holosphere_shortcut_unavailable").m_130940_(ChatFormatting.DARK_GRAY));
            } else if (ModularHolosphereItem.findHolosphere(playerEntity).m_41619_() || !(itemStack.m_41720_() instanceof IModularItem)) {
                this.tooltip.add((Component)Component.m_237115_((String)"tetra.holo.craft.holosphere_shortcut_disabled"));
                this.tooltip.add((Component)Component.m_237115_((String)"tetra.holo.craft.holosphere_shortcut_missing").m_130940_(ChatFormatting.DARK_GRAY));
            } else {
                this.tooltip.add((Component)Component.m_237115_((String)"tetra.holo.craft.holosphere_shortcut"));
                this.item = (IModularItem)itemStack.m_41720_();
                this.slot = slot;
                this.schematic = schematic;
            }
        } else {
            this.tooltip = this.emptyTooltip;
        }
    }

    public boolean onMouseClick(int x, int y, int button) {
        if (this.hasFocus() && this.item != null) {
            Screen currentScreen = Minecraft.m_91087_().f_91080_;
            HoloGui gui = HoloGui.getInstance();
            Minecraft.m_91087_().m_91152_((Screen)gui);
            gui.openSchematic(this.item, this.slot, this.schematic, () -> ClientScheduler.schedule(0, () -> Minecraft.m_91087_().m_91152_(currentScreen)));
            return true;
        }
        return false;
    }
}

