/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.items.modular.impl.crossbow;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.FireworkRocketEntity;
import net.minecraft.world.item.ArrowItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.registries.ObjectHolder;
import org.jetbrains.annotations.NotNull;
import se.mickelus.mutil.network.PacketHandler;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileEntity;
import se.mickelus.tetra.data.DataManager;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.GuiModuleOffsets;
import se.mickelus.tetra.items.modular.ModularItem;
import se.mickelus.tetra.items.modular.impl.crossbow.CrossbowOverlay;
import se.mickelus.tetra.module.ItemModule;
import se.mickelus.tetra.module.SchematicRegistry;
import se.mickelus.tetra.module.data.ModuleModel;
import se.mickelus.tetra.module.schematic.RemoveSchematic;
import se.mickelus.tetra.module.schematic.RepairSchematic;
import se.mickelus.tetra.properties.AttributeHelper;
import se.mickelus.tetra.properties.TetraAttributes;

@ParametersAreNonnullByDefault
public class ModularCrossbowItem
extends ModularItem {
    public static final String staveKey = "crossbow/stave";
    public static final String stockKey = "crossbow/stock";
    public static final String stringKey = "crossbow/string";
    public static final String attachmentAKey = "crossbow/attachment_0";
    public static final String attachmentBKey = "crossbow/attachment_1";
    public static final String identifier = "modular_crossbow";
    public static final double velocityFactor = 0.125;
    private static final GuiModuleOffsets majorOffsets = new GuiModuleOffsets(-13, 0, -13, 18);
    private static final GuiModuleOffsets minorOffsets = new GuiModuleOffsets(4, -1, 13, 12, 4, 25);
    @ObjectHolder(registryName="item", value="tetra:modular_crossbow")
    public static ModularCrossbowItem instance;
    public static double multishotDefaultSpread;
    protected ModuleModel arrowModel = new ModuleModel("item", new ResourceLocation("tetra", "items/module/crossbow/arrow"));
    protected ModuleModel extractorModel = new ModuleModel("item", new ResourceLocation("tetra", "items/module/crossbow/extractor"));
    protected ModuleModel fireworkModel = new ModuleModel("item", new ResourceLocation("tetra", "items/module/crossbow/firework"));
    protected ItemStack shootableDummy;
    private boolean isLoadingStart = false;
    private boolean isLoadingMiddle = false;

    public ModularCrossbowItem(@NotNull Item shootableDummy) {
        super(new Item.Properties().m_41487_(1).m_41486_());
        this.majorModuleKeys = new String[]{staveKey, stockKey};
        this.minorModuleKeys = new String[]{attachmentAKey, stringKey, attachmentBKey};
        this.requiredModules = new String[]{stringKey, stockKey, staveKey};
        this.shootableDummy = new ItemStack((ItemLike)shootableDummy);
        this.updateConfig((Integer)ConfigHandler.honeCrossbowBase.get(), (Integer)ConfigHandler.honeCrossbowIntegrityMultiplier.get());
        SchematicRegistry.instance.registerSchematic(new RepairSchematic(this, identifier));
        RemoveSchematic.registerRemoveSchematics(this, identifier);
    }

    public static float getProjectileVelocity(double strength, float velocityBonus) {
        float velocity = (float)Math.max(1.0, 1.0 + (strength - 6.0) * 0.125);
        velocity += velocity * velocityBonus;
        return velocity;
    }

    @Override
    public void commonInit(PacketHandler packetHandler) {
        DataManager.instance.synergyData.onReload(() -> {
            this.synergies = DataManager.instance.getSynergyData("crossbow/");
        });
    }

    public void updateConfig(int honeBase, int honeIntegrityMultiplier) {
        this.honeBase = honeBase;
        this.honeIntegrityMultiplier = honeIntegrityMultiplier;
    }

    @Override
    public void clientInit() {
        super.clientInit();
        MinecraftForge.EVENT_BUS.register((Object)new CrossbowOverlay(Minecraft.m_91087_()));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        List<ItemStack> list = this.getProjectiles(stack);
        if (this.isLoaded(stack) && !list.isEmpty()) {
            ItemStack itemstack = list.get(0);
            tooltip.add((Component)Component.m_237115_((String)"item.minecraft.crossbow.projectile").m_130946_(" ").m_7220_(itemstack.m_41611_()));
            if (flagIn.m_7050_() && itemstack.m_41720_() == Items.f_42688_) {
                ArrayList list1 = Lists.newArrayList();
                Items.f_42688_.m_7373_(itemstack, worldIn, (List)list1, flagIn);
                if (!list1.isEmpty()) {
                    for (int i = 0; i < list1.size(); ++i) {
                        list1.set(i, Component.m_237113_((String)"  ").m_7220_((Component)list1.get(i)).m_130940_(ChatFormatting.GRAY));
                    }
                    tooltip.addAll(list1);
                }
            }
        }
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237115_((String)"item.tetra.crossbow.wip").m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237113_((String)" "));
        }
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack itemStack) {
        if (this.isBroken(itemStack)) {
            return AttributeHelper.emptyMap;
        }
        if (slot == EquipmentSlot.MAINHAND) {
            return this.getAttributeModifiersCached(itemStack);
        }
        if (slot == EquipmentSlot.OFFHAND) {
            return (Multimap)this.getAttributeModifiersCached(itemStack).entries().stream().filter(entry -> !((Attribute)entry.getKey()).equals(Attributes.f_22281_) && !((Attribute)entry.getKey()).equals(Attributes.f_22281_)).collect(Multimaps.toMultimap(Map.Entry::getKey, Map.Entry::getValue, ArrayListMultimap::create));
        }
        return AttributeHelper.emptyMap;
    }

    public void m_5929_(Level world, LivingEntity entity, ItemStack itemStack, int count) {
        if (!world.f_46443_) {
            int drawDuration = this.getReloadDuration(itemStack);
            float f = this.getProgress(itemStack, entity);
            if (f < 0.2f) {
                this.isLoadingStart = false;
                this.isLoadingMiddle = false;
            }
            if (f >= 0.2f && !this.isLoadingStart) {
                this.isLoadingStart = true;
                world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), this.getSoundEvent(drawDuration), SoundSource.PLAYERS, 0.5f, 1.0f);
            }
            if (f >= 0.5f && drawDuration <= 28 && !this.isLoadingMiddle) {
                this.isLoadingMiddle = true;
                if (drawDuration > 21) {
                    world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11842_, SoundSource.PLAYERS, 0.5f, 1.0f);
                }
            }
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player player, InteractionHand hand) {
        ItemStack itemstack = player.m_21120_(hand);
        if (this.isLoaded(itemstack)) {
            this.fireProjectiles(itemstack, world, (LivingEntity)player);
            this.setLoaded(itemstack, false);
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        if (!this.findAmmo((LivingEntity)player).m_41619_()) {
            if (!this.isLoaded(itemstack)) {
                this.isLoadingStart = false;
                this.isLoadingMiddle = false;
                player.m_6672_(hand);
            }
            return InteractionResultHolder.m_19096_((Object)itemstack);
        }
        return InteractionResultHolder.m_19100_((Object)itemstack);
    }

    public void m_5551_(ItemStack itemStack, Level world, LivingEntity entity, int timeLeft) {
        boolean gotLoaded;
        float progress = this.getProgress(itemStack, entity);
        if (progress >= 1.0f && !this.isLoaded(itemStack) && (gotLoaded = this.reload(entity, itemStack))) {
            this.setLoaded(itemStack, true);
            SoundSource soundcategory = entity instanceof Player ? SoundSource.PLAYERS : SoundSource.HOSTILE;
            world.m_6263_(null, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), SoundEvents.f_11841_, soundcategory, 1.0f, 1.0f / (world.f_46441_.m_188501_() * 0.5f + 1.0f) + 0.2f);
        }
    }

    protected void fireProjectiles(ItemStack itemStack, Level world, LivingEntity entity) {
        if (entity instanceof Player) {
            Player player = (Player)entity;
            if (!world.f_46443_) {
                ItemStack advancementCopy = itemStack.m_41777_();
                int multishotEnchantLevel = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44959_, (ItemStack)itemStack) * 3;
                int count = Math.max(this.getEffectLevel(itemStack, ItemEffect.multishot) + multishotEnchantLevel, 1);
                List<ItemStack> list = this.takeProjectiles(itemStack, 1);
                if (!list.isEmpty()) {
                    double spread = this.getEffectEfficiency(itemStack, ItemEffect.multishot);
                    if (spread == 0.0 && multishotEnchantLevel > 0) {
                        spread = multishotDefaultSpread;
                    }
                    for (int i = 0; i < count; ++i) {
                        ItemStack ammoStack = list.get(0);
                        double yaw = (double)player.m_146908_() - spread * (double)(count - 1) / 2.0 + spread * (double)i;
                        boolean isDupe = player.m_150110_().f_35937_ || count > 1 && i != count / 2;
                        this.fireProjectile(world, itemStack, ammoStack, player, yaw, isDupe);
                    }
                    itemStack.m_41622_(1, (LivingEntity)player, p -> p.m_21190_(p.m_7655_()));
                    this.applyUsageEffects(entity, itemStack, 1.0);
                    world.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_11847_, SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (player instanceof ServerPlayer) {
                        CriteriaTriggers.f_10555_.m_65462_((ServerPlayer)player, advancementCopy);
                        player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                    }
                }
            }
        }
    }

    public int getReloadDuration(ItemStack itemStack) {
        return Math.max((int)(20.0 * (this.getAttributeValue(itemStack, (Attribute)TetraAttributes.drawSpeed.get()) - (double)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44960_, (ItemStack)itemStack) * 0.2)), 1);
    }

    public float getProgress(ItemStack itemStack, @Nullable LivingEntity entity) {
        return Optional.ofNullable(entity).filter(e -> e.m_21212_() > 0).filter(e -> itemStack.equals(e.m_21211_())).map(e -> Float.valueOf((float)(this.m_8105_(itemStack) - e.m_21212_()) * 1.0f / (float)this.getReloadDuration(itemStack))).orElse(Float.valueOf(0.0f)).floatValue();
    }

    private ItemStack findAmmo(LivingEntity entity) {
        return entity.m_6298_(this.shootableDummy);
    }

    protected void fireProjectile(Level world, ItemStack crossbowStack, ItemStack ammoStack, Player player, double yaw, boolean isDupe) {
        double strength = this.getAttributeValue(crossbowStack, (Attribute)TetraAttributes.drawStrength.get());
        float velocityBonus = (float)this.getEffectLevel(crossbowStack, ItemEffect.velocity) / 100.0f;
        float projectileVelocity = ModularCrossbowItem.getProjectileVelocity(strength, velocityBonus);
        if (ChthonicExtractorBlock.item.equals(ammoStack.m_41720_()) || ChthonicExtractorBlock.usedItem.equals(ammoStack.m_41720_())) {
            ExtractorProjectileEntity projectileEntity = new ExtractorProjectileEntity(world, (LivingEntity)player, ammoStack);
            if (isDupe) {
                projectileEntity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            projectileEntity.m_37251_((Entity)player, player.m_146909_(), (float)yaw, 0.0f, projectileVelocity, 1.0f);
            world.m_7967_((Entity)projectileEntity);
        } else if (ammoStack.m_41720_() instanceof FireworkRocketItem) {
            FireworkRocketEntity projectile = new FireworkRocketEntity(world, ammoStack, (Entity)player, player.m_20185_(), player.m_20188_() - 0.15, player.m_20189_(), true);
            projectile.m_37251_((Entity)player, player.m_146909_(), (float)yaw, 0.0f, projectileVelocity * 1.6f, 1.0f);
            world.m_7967_((Entity)projectile);
        } else {
            int piercingLevel;
            ArrowItem ammoItem = CastOptional.cast((Object)ammoStack.m_41720_(), ArrowItem.class).orElse((ArrowItem)Items.f_42412_);
            AbstractArrow projectile = ammoItem.m_6394_(world, ammoStack, (LivingEntity)player);
            projectile.m_36740_(SoundEvents.f_11840_);
            projectile.m_36793_(true);
            projectile.m_36762_(true);
            projectile.m_36781_(projectile.m_36789_() - 2.0 + strength / 3.0);
            if (projectileVelocity > 1.0f) {
                projectile.m_36781_(projectile.m_36789_() / (double)projectileVelocity);
            }
            if ((piercingLevel = this.getEffectLevel(crossbowStack, ItemEffect.piercing) + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44961_, (ItemStack)crossbowStack)) > 0) {
                projectile.m_36767_((byte)piercingLevel);
            }
            if (isDupe) {
                projectile.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
            }
            projectile.m_37251_((Entity)player, player.m_146909_(), (float)yaw, 0.0f, projectileVelocity * 3.15f, 1.0f);
            world.m_7967_((Entity)projectile);
        }
    }

    public boolean isLoaded(ItemStack stack) {
        CompoundTag compoundnbt = stack.m_41783_();
        return compoundnbt != null && compoundnbt.m_128471_("Charged");
    }

    public void setLoaded(ItemStack stack, boolean chargedIn) {
        CompoundTag compoundnbt = stack.m_41784_();
        compoundnbt.m_128379_("Charged", chargedIn);
    }

    private ListTag getProjectilesNBT(ItemStack itemStack) {
        if (itemStack.m_41782_()) {
            return this.getProjectilesNBT(itemStack.m_41783_());
        }
        return new ListTag();
    }

    private ListTag getProjectilesNBT(CompoundTag nbt) {
        if (nbt.m_128425_("ChargedProjectiles", 9)) {
            return nbt.m_128437_("ChargedProjectiles", 10);
        }
        return new ListTag();
    }

    private void writeProjectile(ItemStack crossbowStack, ItemStack projectileStack) {
        CompoundTag crossbowTag = crossbowStack.m_41784_();
        ListTag list = this.getProjectilesNBT(crossbowTag);
        CompoundTag projectileTag = new CompoundTag();
        projectileStack.m_41739_(projectileTag);
        list.add((Object)projectileTag);
        crossbowTag.m_128365_("ChargedProjectiles", (Tag)list);
    }

    private ItemStack getFirstProjectile(ItemStack itemStack) {
        ListTag projectiles = this.getProjectilesNBT(itemStack);
        if (projectiles.size() > 0) {
            return ItemStack.m_41712_((CompoundTag)projectiles.m_128728_(0));
        }
        return ItemStack.f_41583_;
    }

    private List<ItemStack> getProjectiles(ItemStack itemStack) {
        ArrayList result = Lists.newArrayList();
        ListTag projectileTags = this.getProjectilesNBT(itemStack);
        for (int i = 0; i < projectileTags.size(); ++i) {
            CompoundTag stackNbt = projectileTags.m_128728_(i);
            result.add(ItemStack.m_41712_((CompoundTag)stackNbt));
        }
        return result;
    }

    private List<ItemStack> takeProjectiles(ItemStack itemStack, int count) {
        ListTag nbtList = this.getProjectilesNBT(itemStack);
        int size = Math.min(nbtList.size(), count);
        ArrayList<ItemStack> result = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            CompoundTag stackNbt = nbtList.m_128728_(0);
            nbtList.remove(0);
            result.add(ItemStack.m_41712_((CompoundTag)stackNbt));
        }
        return result;
    }

    public boolean hasProjectiles(ItemStack stack, Item ammoItem) {
        return this.getProjectiles(stack).stream().anyMatch(s -> s.m_41720_() == ammoItem);
    }

    private SoundEvent getSoundEvent(float velocity) {
        if (velocity < 7.0f) {
            return SoundEvents.f_11846_;
        }
        if (velocity < 15.0f) {
            return SoundEvents.f_11845_;
        }
        if (velocity < 22.0f) {
            return SoundEvents.f_11844_;
        }
        return SoundEvents.f_11843_;
    }

    public int m_8105_(ItemStack itemStack) {
        return 37000;
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.CROSSBOW;
    }

    public boolean m_41463_(ItemStack stack) {
        return true;
    }

    public boolean m_41465_() {
        return true;
    }

    private String getDrawVariant(ItemStack itemStack, @Nullable LivingEntity entity) {
        float progress = this.getProgress(itemStack, entity);
        if (this.isLoaded(itemStack)) {
            return "loaded";
        }
        if (progress == 0.0f) {
            return "item";
        }
        if ((double)progress < 0.58) {
            return "draw_0";
        }
        if (progress < 1.0f) {
            return "draw_1";
        }
        return "draw_2";
    }

    private String getProjectileVariant(ItemStack itemStack) {
        ItemStack projectileStack = this.getFirstProjectile(itemStack);
        if (projectileStack.m_41720_() instanceof FireworkRocketItem) {
            return "p1";
        }
        if (ChthonicExtractorBlock.item.equals(projectileStack.m_41720_()) || ChthonicExtractorBlock.usedItem.equals(projectileStack.m_41720_())) {
            return "p2";
        }
        return "p0";
    }

    private ModuleModel getProjectileModel(ItemStack itemStack) {
        ItemStack projectileStack = this.getFirstProjectile(itemStack);
        if (projectileStack.m_41720_() instanceof FireworkRocketItem) {
            return this.fireworkModel;
        }
        if (ChthonicExtractorBlock.item.equals(projectileStack.m_41720_()) || ChthonicExtractorBlock.usedItem.equals(projectileStack.m_41720_())) {
            return this.extractorModel;
        }
        return this.arrowModel;
    }

    @Override
    public String getModelCacheKey(ItemStack itemStack, LivingEntity entity) {
        return super.getModelCacheKey(itemStack, entity) + ":" + this.getDrawVariant(itemStack, entity) + this.getProjectileVariant(itemStack);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public ImmutableList<ModuleModel> getModels(ItemStack itemStack, @Nullable LivingEntity entity) {
        String modelType = this.getDrawVariant(itemStack, entity);
        ImmutableList models = this.getAllModules(itemStack).stream().sorted(Comparator.comparing(ItemModule::getRenderLayer)).flatMap(itemModule -> Arrays.stream(itemModule.getModels(itemStack))).filter(Objects::nonNull).filter(model -> model.type.equals(modelType) || model.type.equals("static")).collect(Collectors.collectingAndThen(Collectors.toList(), ImmutableList::copyOf));
        if (this.isLoaded(itemStack)) {
            return ImmutableList.builder().addAll((Iterable)models).add((Object)this.getProjectileModel(itemStack)).build();
        }
        return models;
    }

    private boolean reload(LivingEntity entity, ItemStack crossbowStack) {
        int count = Math.max(this.getEffectLevel(crossbowStack, ItemEffect.ammoCapacity), 1);
        boolean infinite = CastOptional.cast((Object)entity, Player.class).map(player -> player.m_150110_().f_35937_).orElse(false);
        ItemStack ammoStack = ItemStack.f_41583_;
        for (int i = 0; i < count; ++i) {
            if (ammoStack.m_41619_()) {
                ammoStack = this.findAmmo(entity);
            }
            if (ammoStack.m_41619_() && infinite) {
                ammoStack = new ItemStack((ItemLike)Items.f_42412_);
            }
            if (this.loadProjectiles(entity, crossbowStack, ammoStack, infinite && ammoStack.m_41720_() instanceof ArrowItem)) continue;
            return i > 0;
        }
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMajorGuiOffsets() {
        return majorOffsets;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public GuiModuleOffsets getMinorGuiOffsets() {
        return minorOffsets;
    }

    private boolean loadProjectiles(LivingEntity entity, ItemStack crossbowStack, ItemStack ammoStack, boolean infiniteAmmo) {
        ItemStack itemstack;
        if (ammoStack.m_41619_()) {
            return false;
        }
        if (!infiniteAmmo) {
            itemstack = ammoStack.m_41620_(1);
            if (ammoStack.m_41619_() && entity instanceof Player) {
                Player player = (Player)entity;
                player.m_150109_().m_36057_(ammoStack);
            }
        } else {
            itemstack = ammoStack.m_41777_();
        }
        this.writeProjectile(crossbowStack, itemstack);
        return true;
    }

    static {
        multishotDefaultSpread = 10.0;
    }
}

