/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.gui.stats.bar;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.gui.stats.bar.GuiStatIndicator;
import se.mickelus.tetra.gui.stats.getter.StatGetterEffectLevel;
import se.mickelus.tetra.gui.stats.getter.TooltipGetterNone;

@ParametersAreNonnullByDefault
public class StrikingStatIndicatorGui
extends GuiStatIndicator {
    GuiStatIndicator striking;
    GuiStatIndicator sweeping;
    GuiStatIndicator current;

    public StrikingStatIndicatorGui(ToolAction toolAction) {
        super(0, 0, "", 0, null, null);
        if (toolAction == ToolActions.AXE_DIG) {
            this.striking = new GuiStatIndicator(0, 0, "tetra.stats.tool.striking", 0, new StatGetterEffectLevel(ItemEffect.strikingAxe, 1.0), new TooltipGetterNone("tetra.stats.tool.striking.tooltip"));
        } else if (toolAction == ToolActions.PICKAXE_DIG) {
            this.striking = new GuiStatIndicator(0, 0, "tetra.stats.tool.striking", 0, new StatGetterEffectLevel(ItemEffect.strikingPickaxe, 1.0), new TooltipGetterNone("tetra.stats.tool.striking.tooltip"));
        } else if (toolAction == TetraToolActions.cut) {
            this.striking = new GuiStatIndicator(0, 0, "tetra.stats.tool.striking", 0, new StatGetterEffectLevel(ItemEffect.strikingCut, 1.0), new TooltipGetterNone("tetra.stats.tool.striking.tooltip"));
        } else if (toolAction == ToolActions.SHOVEL_DIG) {
            this.striking = new GuiStatIndicator(0, 0, "tetra.stats.tool.striking", 0, new StatGetterEffectLevel(ItemEffect.strikingShovel, 1.0), new TooltipGetterNone("tetra.stats.tool.striking.tooltip"));
        } else if (toolAction == ToolActions.HOE_DIG) {
            this.striking = new GuiStatIndicator(0, 0, "tetra.stats.tool.striking", 0, new StatGetterEffectLevel(ItemEffect.strikingHoe, 1.0), new TooltipGetterNone("tetra.stats.tool.striking.tooltip"));
        }
        this.sweeping = new GuiStatIndicator(0, 0, "tetra.stats.tool.sweeping", 1, new StatGetterEffectLevel(ItemEffect.sweepingStrike, 1.0), new TooltipGetterNone("tetra.stats.tool.sweeping.tooltip"));
    }

    @Override
    public boolean update(Player player, ItemStack currentStack, ItemStack previewStack, String slot, String improvement) {
        if (this.striking != null && this.striking.update(player, currentStack, previewStack, slot, improvement)) {
            this.current = this.sweeping.update(player, currentStack, previewStack, slot, improvement) ? this.sweeping : this.striking;
            return true;
        }
        this.current = null;
        return false;
    }

    @Override
    public boolean isActive(Player player, ItemStack itemStack) {
        return this.current != null && this.current.isActive(player, itemStack);
    }

    @Override
    protected int getDiffColor(double baseValue, double value, double diffValue) {
        return Optional.ofNullable(this.current).map(c -> c.getDiffColor(baseValue, value, diffValue)).orElse(0xFFFFFF);
    }

    @Override
    public String getLabel() {
        return Optional.ofNullable(this.current).map(c -> c.label).orElse("");
    }

    @Override
    public String getTooltipBase(Player player, ItemStack itemStack) {
        return Optional.ofNullable(this.current).map(c -> c.getTooltipBase(player, itemStack)).orElse("");
    }

    @Override
    public boolean hasExtendedTooltip(Player player, ItemStack itemStack) {
        return Optional.ofNullable(this.current).map(c -> c.hasExtendedTooltip(player, itemStack)).orElse(false);
    }

    @Override
    public String getTooltipExtension(Player player, ItemStack itemStack) {
        return Optional.ofNullable(this.current).map(c -> c.getTooltipExtension(player, itemStack)).orElse("");
    }

    public void draw(PoseStack matrixStack, int refX, int refY, int screenWidth, int screenHeight, int mouseX, int mouseY, float opacity) {
        if (this.current != null) {
            this.current.draw(matrixStack, refX, refY, screenWidth, screenHeight, mouseX, mouseY, opacity);
        }
    }
}

