/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect.howling;

import java.util.Optional;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import se.mickelus.mutil.network.AbstractPacket;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.effect.howling.HowlingPacket;
import se.mickelus.tetra.effect.howling.HowlingPotionEffect;

@ParametersAreNonnullByDefault
public class HowlingEffect {
    public static void sendPacket() {
        TetraMod.packetHandler.sendToServer((AbstractPacket)new HowlingPacket());
    }

    public static void trigger(ItemStack itemStack, LivingEntity player, int effectLevel) {
        int duration = Math.round(EffectHelper.getEffectEfficiency(itemStack, ItemEffect.howling) * 20.0f);
        int currentAmplifier = Optional.ofNullable(player.m_21124_((MobEffect)HowlingPotionEffect.instance)).map(MobEffectInstance::m_19564_).orElse(-1);
        player.m_7292_(new MobEffectInstance((MobEffect)HowlingPotionEffect.instance, duration, Math.min(currentAmplifier + effectLevel, 11), false, false));
    }

    public static void deflectProjectile(ProjectileImpactEvent event, Projectile projectile, HitResult rayTraceResult) {
        Optional.ofNullable(rayTraceResult).filter(result -> result.m_6662_() == HitResult.Type.ENTITY).map(result -> (EntityHitResult)result).map(EntityHitResult::m_82443_).flatMap(entity -> CastOptional.cast((Object)entity, LivingEntity.class)).filter(entity -> HowlingEffect.willDeflect(entity.m_21124_((MobEffect)HowlingPotionEffect.instance), entity.m_217043_())).ifPresent(entity -> {
            Vec3 newDir;
            if ((double)entity.m_21124_((MobEffect)HowlingPotionEffect.instance).m_19564_() * 0.02 < entity.m_217043_().m_188500_()) {
                Vec3 normal = entity.m_20182_().m_82520_(0.0, (double)(entity.m_20206_() / 2.0f), 0.0).m_82546_(projectile.m_20182_()).m_82541_();
                newDir = projectile.m_20184_().m_82546_(normal.m_82490_(2.0 * projectile.m_20184_().m_82526_(normal)));
            } else {
                newDir = projectile.m_20184_().m_82490_(-0.8);
                CastOptional.cast((Object)projectile.m_37282_(), LivingEntity.class).ifPresent(shooter -> shooter.m_21335_((Entity)entity));
                projectile.m_5602_((Entity)entity);
            }
            projectile.m_6686_(newDir.f_82479_, newDir.f_82480_, newDir.f_82481_, (float)projectile.m_20184_().m_82553_(), 0.1f);
            event.setCanceled(true);
        });
    }

    private static boolean willDeflect(MobEffectInstance effectInstance, RandomSource random) {
        return effectInstance != null && random.m_188500_() < (double)effectInstance.m_19564_() * 0.125;
    }
}

