/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.effect;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import org.apache.commons.lang3.tuple.Pair;
import se.mickelus.mutil.util.CastOptional;
import se.mickelus.mutil.util.RotationHelper;
import se.mickelus.tetra.ServerScheduler;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.effect.CritEffect;
import se.mickelus.tetra.effect.EffectHelper;
import se.mickelus.tetra.effect.ItemEffect;
import se.mickelus.tetra.items.modular.ItemModularHandheld;
import se.mickelus.tetra.util.ToolActionHelper;

@ParametersAreNonnullByDefault
public class StrikingEffect {
    private static final Cache<UUID, Integer> strikeCache = CacheBuilder.newBuilder().maximumSize(100L).expireAfterWrite(1L, TimeUnit.MINUTES).build();
    private static final BlockPos[] sweep1 = new BlockPos[]{new BlockPos(-2, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(-3, 0, -1), new BlockPos(-2, 0, -1), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(3, 0, -1), new BlockPos(-3, 0, -2), new BlockPos(-2, 0, -2), new BlockPos(-1, 0, -2), new BlockPos(-1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(-2, 1, -1), new BlockPos(-1, 1, -1), new BlockPos(-1, -1, 0), new BlockPos(0, -1, 0), new BlockPos(-2, -1, -1), new BlockPos(-1, -1, -1)};
    private static final BlockPos[] sweep2 = new BlockPos[]{new BlockPos(-2, 0, 0), new BlockPos(-1, 0, 0), new BlockPos(0, 0, 0), new BlockPos(1, 0, 0), new BlockPos(2, 0, 0), new BlockPos(3, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(2, 0, 1), new BlockPos(-2, 0, -1), new BlockPos(-1, 0, -1), new BlockPos(0, 0, -1), new BlockPos(4, 0, -1), new BlockPos(-1, 1, 0), new BlockPos(0, 1, 0), new BlockPos(1, 1, 0), new BlockPos(-1, -1, 0), new BlockPos(0, -1, 0), new BlockPos(1, -1, 0)};
    static final List<Pair<ItemEffect, ToolAction>> effectActionMap = ImmutableList.of((Object)Pair.of((Object)ItemEffect.strikingAxe, (Object)ToolActions.AXE_DIG), (Object)Pair.of((Object)ItemEffect.strikingPickaxe, (Object)ToolActions.PICKAXE_DIG), (Object)Pair.of((Object)ItemEffect.strikingCut, (Object)TetraToolActions.cut), (Object)Pair.of((Object)ItemEffect.strikingShovel, (Object)ToolActions.SHOVEL_DIG), (Object)Pair.of((Object)ItemEffect.strikingHoe, (Object)ToolActions.HOE_DIG));

    public static boolean causeEffect(Player breakingPlayer, ItemStack itemStack, ItemModularHandheld item, Level world, BlockPos pos, BlockState blockState) {
        int strikingLevel = 0;
        ToolAction tool = null;
        if (breakingPlayer.m_21023_(MobEffects.f_19599_)) {
            return false;
        }
        for (Pair<ItemEffect, ToolAction> entry : effectActionMap) {
            if (!ToolActionHelper.isEffectiveOn((ToolAction)entry.getRight(), blockState) || (strikingLevel = EffectHelper.getEffectLevel(itemStack, (ItemEffect)entry.getLeft())) <= 0) continue;
            tool = (ToolAction)entry.getRight();
            break;
        }
        if (strikingLevel > 0) {
            int sweepingLevel = EffectHelper.getEffectLevel(itemStack, ItemEffect.sweepingStrike);
            if ((double)breakingPlayer.m_36403_(0.0f) > 0.9 && blockState.m_60800_((BlockGetter)world, pos) != -1.0f) {
                if (sweepingLevel > 0) {
                    StrikingEffect.breakBlocksAround(world, breakingPlayer, itemStack, pos, tool, sweepingLevel);
                } else if (ToolActionHelper.playerCanDestroyBlock(breakingPlayer, blockState, pos, itemStack)) {
                    EffectHelper.breakBlock(world, breakingPlayer, itemStack, pos, blockState, true);
                }
                item.applyUsageEffects((LivingEntity)breakingPlayer, itemStack, 1.0);
                item.applyDamage(item.getBlockDestroyDamage(), itemStack, (LivingEntity)breakingPlayer);
            }
            breakingPlayer.m_36334_();
            return true;
        }
        return false;
    }

    private static int getStrikeCounter(UUID entityId) {
        int counter = 0;
        try {
            counter = (Integer)strikeCache.get((Object)entityId, () -> 0);
        }
        catch (ExecutionException e) {
            e.printStackTrace();
        }
        strikeCache.put((Object)entityId, (Object)(counter + 1));
        return counter;
    }

    private static void breakBlocksAround(Level world, Player breakingPlayer, ItemStack toolStack, BlockPos originPos, ToolAction tool, int sweepingLevel) {
        if (world.f_46443_) {
            return;
        }
        Direction facing = breakingPlayer.m_6350_();
        int strikeCounter = StrikingEffect.getStrikeCounter(breakingPlayer.m_20148_());
        boolean alternate = strikeCounter % 2 == 0;
        double efficiency = CastOptional.cast((Object)toolStack.m_41720_(), ItemModularHandheld.class).map(item -> Float.valueOf(item.getToolEfficiency(toolStack, tool))).orElse(Float.valueOf(0.0f)).floatValue();
        double critMultiplier = CastOptional.cast((Object)toolStack.m_41720_(), ItemModularHandheld.class).map(item -> CritEffect.rollMultiplier(breakingPlayer.m_217043_(), item, toolStack)).orElse(1.0);
        if (critMultiplier != 1.0) {
            efficiency *= critMultiplier;
            ((ServerLevel)world).m_8767_((ParticleOptions)ParticleTypes.f_123808_, (double)((float)originPos.m_123341_() + 0.5f), (double)((float)originPos.m_123342_() + 0.5f), (double)((float)originPos.m_123343_() + 0.5f), 15, 0.2, 0.2, 0.2, 0.0);
        }
        breakingPlayer.m_36346_();
        int[] delays = Arrays.stream(strikeCounter / 2 % 2 == 0 ? sweep1 : sweep2).map(Vec3i::m_123341_).mapToInt(x -> x + 3).toArray();
        List positions = Arrays.stream(strikeCounter / 2 % 2 == 0 ? sweep1 : sweep2).map(pos -> alternate ? new BlockPos(-pos.m_123341_(), pos.m_123342_(), pos.m_123343_()) : pos).map(pos -> RotationHelper.rotatePitch((BlockPos)pos, (float)breakingPlayer.m_146909_())).map(pos -> RotationHelper.rotateDirection((BlockPos)pos, (Direction)facing)).map(arg_0 -> ((BlockPos)originPos).m_121955_(arg_0)).collect(Collectors.toList());
        for (int i = 0; i < positions.size(); ++i) {
            BlockPos pos2 = (BlockPos)positions.get(i);
            BlockState blockState = world.m_8055_(pos2);
            float blockHardness = blockState.m_60800_((BlockGetter)world, pos2);
            if (ToolActionHelper.isEffectiveOn(tool, blockState) && blockHardness >= 0.0f) {
                if (!ToolActionHelper.playerCanDestroyBlock(breakingPlayer, blockState, pos2, toolStack, tool)) break;
                efficiency -= (double)blockHardness + 0.5;
                StrikingEffect.enqueueBlockBreak(world, breakingPlayer, toolStack, pos2, blockState, delays[i]);
            } else if (blockState.m_60815_()) {
                efficiency -= (double)Math.abs(blockHardness);
            }
            if (efficiency <= 0.0) break;
        }
    }

    private static void enqueueBlockBreak(Level world, Player player, ItemStack itemStack, BlockPos pos, BlockState blockState, int delay) {
        ServerScheduler.schedule(delay, () -> {
            if (EffectHelper.breakBlock(world, player, itemStack, pos, blockState, true)) {
                EffectHelper.sendEventToPlayer((ServerPlayer)player, 2001, pos, Block.m_49956_((BlockState)blockState));
            }
        });
    }
}

