/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.salvage;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.event.RenderHighlightEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import se.mickelus.tetra.blocks.salvage.InteractiveBlockOverlayGui;

@ParametersAreNonnullByDefault
public class InteractiveBlockOverlay {
    private static boolean isDirty = false;
    private final Minecraft mc;
    private final InteractiveBlockOverlayGui gui = new InteractiveBlockOverlayGui();
    private BlockPos previousPos;
    private Direction previousFace;
    private BlockState previousState;

    public InteractiveBlockOverlay() {
        this.mc = Minecraft.m_91087_();
    }

    public static void markDirty() {
        isDirty = true;
    }

    @SubscribeEvent
    public void renderOverlay(RenderHighlightEvent.Block event) {
        if (event.getTarget().m_6662_().equals((Object)HitResult.Type.BLOCK)) {
            BlockHitResult rayTrace = event.getTarget();
            ClientLevel world = Minecraft.m_91087_().f_91073_;
            VoxelShape shape = world.m_8055_(rayTrace.m_82425_()).m_60651_((BlockGetter)Minecraft.m_91087_().f_91073_, rayTrace.m_82425_(), CollisionContext.m_82750_((Entity)this.mc.f_91074_));
            BlockPos blockPos = rayTrace.m_82425_();
            Direction face = rayTrace.m_82434_();
            BlockState blockState = world.m_8055_(blockPos);
            if (!shape.m_83281_()) {
                if (isDirty || !blockState.equals(this.previousState) || !blockPos.equals((Object)this.previousPos) || !face.equals((Object)this.previousFace)) {
                    this.gui.update((Level)world, blockPos, blockState, face, (Player)Minecraft.m_91087_().f_91074_, blockPos.equals((Object)this.previousPos) && face.equals((Object)this.previousFace));
                    this.previousPos = blockPos;
                    this.previousFace = face;
                    this.previousState = blockState;
                    isDirty = false;
                }
                this.gui.draw(event.getPoseStack(), event.getCamera().m_90583_(), rayTrace, shape);
            }
        }
    }
}

