/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.blocks.forged.chthonic;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ObjectHolder;
import se.mickelus.mutil.util.TileEntityOptional;
import se.mickelus.tetra.ConfigHandler;
import se.mickelus.tetra.TetraToolActions;
import se.mickelus.tetra.Tooltips;
import se.mickelus.tetra.blocks.PropertyMatcher;
import se.mickelus.tetra.blocks.TetraBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorTile;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockTile;
import se.mickelus.tetra.blocks.salvage.BlockInteraction;
import se.mickelus.tetra.blocks.salvage.IInteractiveBlock;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.properties.IToolProvider;

@ParametersAreNonnullByDefault
public class ChthonicExtractorBlock
extends TetraBlock
implements IInteractiveBlock,
EntityBlock {
    public static final String identifier = "chthonic_extractor";
    public static final String usedIdentifier = "chthonic_extractor_used";
    public static final String description = "block.tetra.chthonic_extractor.description";
    public static final String extendedDescription = "block.tetra.chthonic_extractor.description_extended";
    public static final int maxDamage = 1024;
    protected static final VoxelShape shape = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)7.0, (double)0.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape)Block.m_49796_((double)6.0, (double)15.0, (double)6.0, (double)10.0, (double)16.0, (double)10.0));
    static final BlockInteraction[] interactions = new BlockInteraction[]{new BlockInteraction(TetraToolActions.hammer, 4, Direction.UP, 0.0f, 4.0f, 0.0f, 4.0f, PropertyMatcher.any, (world, pos, blockState, player, hand, hitFace) -> ChthonicExtractorBlock.hit(world, pos, player, hand)), new BlockInteraction(TetraToolActions.hammer, 5, Direction.UP, 0.0f, 4.0f, 0.0f, 4.0f, PropertyMatcher.any, (world, pos, blockState, player, hand, hitFace) -> ChthonicExtractorBlock.hit(world, pos, player, hand)), new BlockInteraction(TetraToolActions.hammer, 6, Direction.UP, 0.0f, 4.0f, 0.0f, 4.0f, PropertyMatcher.any, (world, pos, blockState, player, hand, hitFace) -> ChthonicExtractorBlock.hit(world, pos, player, hand)), new BlockInteraction(TetraToolActions.hammer, 7, Direction.UP, 0.0f, 4.0f, 0.0f, 4.0f, PropertyMatcher.any, (world, pos, blockState, player, hand, hitFace) -> ChthonicExtractorBlock.hit(world, pos, player, hand))};
    @ObjectHolder(registryName="block", value="tetra:chthonic_extractor")
    public static ChthonicExtractorBlock instance;
    @ObjectHolder(registryName="item", value="tetra:chthonic_extractor")
    public static Item item;
    @ObjectHolder(registryName="item", value="tetra:chthonic_extractor_used")
    public static Item usedItem;

    public ChthonicExtractorBlock() {
        super(BlockBehaviour.Properties.m_60944_((Material)ForgedBlockCommon.forgedMaterialNotSolid, (MaterialColor)MaterialColor.f_76419_).m_60918_(SoundType.f_56725_).m_60913_(2.5f, 2400.0f));
    }

    private static boolean hit(Level world, BlockPos pos, @Nullable Player playerEntity, InteractionHand hand) {
        if (((Boolean)ConfigHandler.enableExtractor.get()).booleanValue()) {
            int amount = Optional.ofNullable(playerEntity).map(player -> player.m_21120_(hand)).filter(itemStack -> itemStack.m_41720_() instanceof IToolProvider).map(itemStack -> Float.valueOf(((IToolProvider)itemStack.m_41720_()).getToolEfficiency((ItemStack)itemStack, TetraToolActions.hammer))).map(Math::round).orElse(4);
            TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ChthonicExtractorTile.class).ifPresent(tile -> tile.damage(amount));
            FracturedBedrockBlock.pierce(world, pos.m_7495_(), amount);
            world.m_5594_(playerEntity, pos, SoundEvents.f_12201_, SoundSource.PLAYERS, 0.8f, 0.5f);
            return true;
        }
        return false;
    }

    private static int getTier(Level world, BlockPos pos) {
        return TileEntityOptional.from((BlockGetter)world, (BlockPos)pos.m_7495_(), FracturedBedrockTile.class).map(FracturedBedrockTile::getProjectedTier).orElseGet(() -> FracturedBedrockBlock.canPierce(world, pos.m_7495_()) ? 0 : -1);
    }

    public static void registerItems(DeferredRegister<Item> registry) {
        registry.register(usedIdentifier, () -> new BlockItem((Block)instance, new Item.Properties().m_41503_(1024)));
        registry.register(identifier, () -> new BlockItem((Block)instance, new Item.Properties().m_41491_((CreativeModeTab)TetraItemGroup.instance).m_41487_(64)));
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter world, List<Component> tooltip, TooltipFlag advanced) {
        tooltip.add((Component)Component.m_237115_((String)description).m_130940_(ChatFormatting.GRAY));
        tooltip.add((Component)Component.m_237113_((String)" "));
        if (Screen.m_96638_()) {
            tooltip.add(Tooltips.expanded);
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add(ForgedBlockCommon.locationTooltip);
            tooltip.add((Component)Component.m_237113_((String)" "));
            tooltip.add((Component)Component.m_237115_((String)extendedDescription).m_130940_(ChatFormatting.GRAY));
        } else {
            tooltip.add(Tooltips.expand);
        }
    }

    public void m_6402_(Level world, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ChthonicExtractorTile.class).ifPresent(tile -> tile.setDamage(stack.m_41773_()));
    }

    public void m_5707_(Level world, BlockPos pos, BlockState state, Player player) {
        TileEntityOptional.from((BlockGetter)world, (BlockPos)pos, ChthonicExtractorTile.class).ifPresent(tile -> {
            ItemStack itemStack = this.getItemStack((ChthonicExtractorTile)((Object)tile));
            ItemEntity itemEntity = new ItemEntity(world, (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5, itemStack);
            itemEntity.m_32060_();
            world.m_7967_((Entity)itemEntity);
        });
        super.m_5707_(world, pos, state, player);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity tile = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (tile instanceof ChthonicExtractorTile) {
            builder = builder.m_78979_(new ResourceLocation("tetra:cthtonic_drop"), (context, stackConsumer) -> stackConsumer.accept(this.getItemStack((ChthonicExtractorTile)tile)));
        }
        return super.m_7381_(state, builder);
    }

    private ItemStack getItemStack(ChthonicExtractorTile tile) {
        if (tile.getDamage() > 0) {
            ItemStack itemStack = new ItemStack((ItemLike)usedItem);
            itemStack.m_41721_(tile.getDamage());
            return itemStack;
        }
        return new ItemStack((ItemLike)item);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return shape;
    }

    @Override
    public BlockInteraction[] getPotentialInteractions(Level world, BlockPos pos, BlockState blockState, Direction face, Collection<ToolAction> tools) {
        int tier = ChthonicExtractorBlock.getTier(world, pos);
        if (((Boolean)ConfigHandler.enableExtractor.get()).booleanValue() && tier >= 0 && face == Direction.UP) {
            return new BlockInteraction[]{interactions[Math.min(tier, interactions.length - 1)]};
        }
        return new BlockInteraction[0];
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        return BlockInteraction.attemptInteraction(world, state, pos, player, hand, hit);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos p_153215_, BlockState p_153216_) {
        return new ChthonicExtractorTile(p_153215_, p_153216_);
    }
}

