/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra.advancements;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.advancements.critereon.AbstractCriterionTriggerInstance;
import net.minecraft.advancements.critereon.DeserializationContext;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import se.mickelus.mutil.util.JsonOptional;
import se.mickelus.tetra.advancements.GenericTrigger;
import se.mickelus.tetra.blocks.PropertyMatcher;

@ParametersAreNonnullByDefault
public class BlockUseCriterion
extends AbstractCriterionTriggerInstance {
    public static final GenericTrigger<BlockUseCriterion> trigger = new GenericTrigger<BlockUseCriterion>("tetra:block_use", BlockUseCriterion::deserialize);
    private final PropertyMatcher before;
    private final PropertyMatcher after;
    private final ItemPredicate item;
    private final Map<String, String> data;

    public BlockUseCriterion(EntityPredicate.Composite playerCondition, PropertyMatcher before, PropertyMatcher after, ItemPredicate item, Map<String, String> data) {
        super(trigger.m_7295_(), playerCondition);
        this.before = before;
        this.after = after;
        this.item = item;
        this.data = data;
    }

    public static void trigger(ServerPlayer player, BlockState state, ItemStack usedItem, Map<String, String> data) {
        trigger.fulfillCriterion(player, criterion -> criterion.test(state, usedItem, data));
    }

    public static void trigger(ServerPlayer player, BlockState state, ItemStack usedItem) {
        BlockUseCriterion.trigger(player, state, usedItem, Collections.emptyMap());
    }

    private static BlockUseCriterion deserialize(JsonObject json, EntityPredicate.Composite entityPredicate, DeserializationContext conditionsParser) {
        return new BlockUseCriterion(entityPredicate, JsonOptional.field((JsonObject)json, (String)"before").map(PropertyMatcher::deserialize).orElse(null), JsonOptional.field((JsonObject)json, (String)"after").map(PropertyMatcher::deserialize).orElse(null), JsonOptional.field((JsonObject)json, (String)"item").map(ItemPredicate::m_45051_).orElse(null), JsonOptional.field((JsonObject)json, (String)"data").map(JsonElement::getAsJsonObject).map(JsonObject::entrySet).map(Collection::stream).orElseGet(Stream::empty).collect(Collectors.toMap(Map.Entry::getKey, entry -> ((JsonElement)entry.getValue()).getAsString())));
    }

    public boolean test(BlockState state, ItemStack usedItem, Map<String, String> data) {
        if (this.before != null && !this.before.test(state)) {
            return false;
        }
        if (this.after != null && !this.after.test(state)) {
            return false;
        }
        if (this.item != null && !this.item.m_45049_(usedItem)) {
            return false;
        }
        if (this.data != null) {
            boolean hasUnmatched = this.data.entrySet().stream().anyMatch(entry -> !data.containsKey(entry.getKey()) || !((String)entry.getValue()).equals(data.get(entry.getKey())));
            return !hasUnmatched;
        }
        return true;
    }
}

