/*
 * Decompiled with CFR 0.152.
 */
package se.mickelus.tetra;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.Tiers;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessor;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureProcessorType;
import net.minecraft.world.level.storage.loot.Serializer;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.predicates.LootItemConditionType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.TierSortingRegistry;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import se.mickelus.tetra.LooseItemPredicate;
import se.mickelus.tetra.TetraMod;
import se.mickelus.tetra.advancements.BlockInteractionCriterion;
import se.mickelus.tetra.advancements.BlockUseCriterion;
import se.mickelus.tetra.advancements.ImprovementCraftCriterion;
import se.mickelus.tetra.advancements.ModuleCraftCriterion;
import se.mickelus.tetra.blocks.InitializableBlock;
import se.mickelus.tetra.blocks.forged.ForgedBlockCommon;
import se.mickelus.tetra.blocks.forged.ForgedCrateBlock;
import se.mickelus.tetra.blocks.forged.ForgedPillarBlock;
import se.mickelus.tetra.blocks.forged.ForgedPlatformBlock;
import se.mickelus.tetra.blocks.forged.ForgedPlatformSlabBlock;
import se.mickelus.tetra.blocks.forged.ForgedVentBlock;
import se.mickelus.tetra.blocks.forged.ForgedWallBlock;
import se.mickelus.tetra.blocks.forged.ForgedWorkbenchBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ChthonicExtractorTile;
import se.mickelus.tetra.blocks.forged.chthonic.DepletedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.ExtractorProjectileEntity;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockBlock;
import se.mickelus.tetra.blocks.forged.chthonic.FracturedBedrockTile;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlock;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerBlockEntity;
import se.mickelus.tetra.blocks.forged.container.ForgedContainerMenu;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorBaseBlockEntity;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPipeBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonBlock;
import se.mickelus.tetra.blocks.forged.extractor.CoreExtractorPistonBlockEntity;
import se.mickelus.tetra.blocks.forged.extractor.SeepingBedrockBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerBaseBlockEntity;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlock;
import se.mickelus.tetra.blocks.forged.hammer.HammerHeadBlockEntity;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitBlock;
import se.mickelus.tetra.blocks.forged.transfer.TransferUnitBlockEntity;
import se.mickelus.tetra.blocks.geode.GeodeBlock;
import se.mickelus.tetra.blocks.geode.GeodeItem;
import se.mickelus.tetra.blocks.geode.PristineDiamondItem;
import se.mickelus.tetra.blocks.geode.PristineEmeraldItem;
import se.mickelus.tetra.blocks.geode.PristineLapisItem;
import se.mickelus.tetra.blocks.multischematic.MultiblockSchematicBlock;
import se.mickelus.tetra.blocks.rack.RackBlock;
import se.mickelus.tetra.blocks.rack.RackTile;
import se.mickelus.tetra.blocks.salvage.InteractiveBlockOverlay;
import se.mickelus.tetra.blocks.scroll.OpenScrollBlock;
import se.mickelus.tetra.blocks.scroll.RolledScrollBlock;
import se.mickelus.tetra.blocks.scroll.ScrollItem;
import se.mickelus.tetra.blocks.scroll.ScrollTile;
import se.mickelus.tetra.blocks.scroll.WallScrollBlock;
import se.mickelus.tetra.blocks.workbench.BasicWorkbenchBlock;
import se.mickelus.tetra.blocks.workbench.WorkbenchContainer;
import se.mickelus.tetra.blocks.workbench.WorkbenchTile;
import se.mickelus.tetra.crafting.ScrollIngredient;
import se.mickelus.tetra.effect.howling.HowlingPotionEffect;
import se.mickelus.tetra.effect.potion.BleedingPotionEffect;
import se.mickelus.tetra.effect.potion.EarthboundPotionEffect;
import se.mickelus.tetra.effect.potion.ExhaustedPotionEffect;
import se.mickelus.tetra.effect.potion.MiningSpeedPotionEffect;
import se.mickelus.tetra.effect.potion.PriedPotionEffect;
import se.mickelus.tetra.effect.potion.PuncturedPotionEffect;
import se.mickelus.tetra.effect.potion.SeveredPotionEffect;
import se.mickelus.tetra.effect.potion.SmallAbsorbPotionEffect;
import se.mickelus.tetra.effect.potion.SmallHealthPotionEffect;
import se.mickelus.tetra.effect.potion.SmallStrengthPotionEffect;
import se.mickelus.tetra.effect.potion.SteeledPotionEffect;
import se.mickelus.tetra.effect.potion.StunPotionEffect;
import se.mickelus.tetra.effect.potion.UnwaveringPotionEffect;
import se.mickelus.tetra.items.InitializableItem;
import se.mickelus.tetra.items.TetraItemGroup;
import se.mickelus.tetra.items.cell.ThermalCellItem;
import se.mickelus.tetra.items.forged.BeamItem;
import se.mickelus.tetra.items.forged.BoltItem;
import se.mickelus.tetra.items.forged.CombustionChamberItem;
import se.mickelus.tetra.items.forged.EarthpiercerItem;
import se.mickelus.tetra.items.forged.InsulatedPlateItem;
import se.mickelus.tetra.items.forged.LubricantDispenserItem;
import se.mickelus.tetra.items.forged.MeshItem;
import se.mickelus.tetra.items.forged.MetalScrapItem;
import se.mickelus.tetra.items.forged.PlanarStabilizerItem;
import se.mickelus.tetra.items.forged.QuickLatchItem;
import se.mickelus.tetra.items.forged.StonecutterItem;
import se.mickelus.tetra.items.loot.DragonSinewItem;
import se.mickelus.tetra.items.modular.ItemPredicateModular;
import se.mickelus.tetra.items.modular.MaterialItemPredicate;
import se.mickelus.tetra.items.modular.ThrownModularItemEntity;
import se.mickelus.tetra.items.modular.impl.ModularBladedItem;
import se.mickelus.tetra.items.modular.impl.ModularDoubleHeadedItem;
import se.mickelus.tetra.items.modular.impl.ModularSingleHeadedItem;
import se.mickelus.tetra.items.modular.impl.bow.ModularBowItem;
import se.mickelus.tetra.items.modular.impl.crossbow.ModularCrossbowItem;
import se.mickelus.tetra.items.modular.impl.crossbow.ShootableDummyItem;
import se.mickelus.tetra.items.modular.impl.holo.ModularHolosphereItem;
import se.mickelus.tetra.items.modular.impl.shield.ModularShieldItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ModularToolbeltItem;
import se.mickelus.tetra.items.modular.impl.toolbelt.ToolbeltContainer;
import se.mickelus.tetra.items.modular.impl.toolbelt.suspend.SuspendPotionEffect;
import se.mickelus.tetra.levelgen.ForgedContainerProcessor;
import se.mickelus.tetra.levelgen.ForgedCrateProcessor;
import se.mickelus.tetra.levelgen.ForgedHammerProcessor;
import se.mickelus.tetra.levelgen.MultiblockSchematicProcessor;
import se.mickelus.tetra.levelgen.TransferUnitProcessor;
import se.mickelus.tetra.loot.FortuneBonusCondition;
import se.mickelus.tetra.loot.ReplaceTableModifier;
import se.mickelus.tetra.loot.ScrollDataFunction;

public class TetraRegistries {
    public static final DeferredRegister<Block> blocks = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"tetra");
    public static final DeferredRegister<Item> items = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"tetra");
    public static final DeferredRegister<BlockEntityType<?>> blockEntities = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"tetra");
    public static final DeferredRegister<MenuType<?>> containers = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MENU_TYPES, (String)"tetra");
    public static final DeferredRegister<EntityType<?>> entities = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITY_TYPES, (String)"tetra");
    public static final DeferredRegister<ParticleType<?>> particles = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"tetra");
    public static final DeferredRegister<MobEffect> effects = DeferredRegister.create((IForgeRegistry)ForgeRegistries.MOB_EFFECTS, (String)"tetra");
    public static final DeferredRegister<Codec<? extends IGlobalLootModifier>> lootModifiers = DeferredRegister.create((ResourceKey)ForgeRegistries.Keys.GLOBAL_LOOT_MODIFIER_SERIALIZERS, (String)"tetra");
    public static final DeferredRegister<LootItemConditionType> lootConditions = DeferredRegister.create((ResourceKey)Registry.f_122817_, (String)"tetra");
    public static final DeferredRegister<LootItemFunctionType> lootFunctions = DeferredRegister.create((ResourceKey)Registry.f_122816_, (String)"tetra");
    public static final DeferredRegister<StructureProcessorType<?>> structureProcessors = DeferredRegister.create((ResourceKey)Registry.f_122854_, (String)"tetra");
    public static final TagKey<Block> forgeHammerBreakTag = BlockTags.create((ResourceLocation)new ResourceLocation("tetra:needs_forge_hammer_tool"));
    public static final Tier forgeHammerTier = TierSortingRegistry.registerTier((Tier)new ForgeTier(Tiers.NETHERITE.m_6604_() + 1, 0, 0.0f, 0.0f, 0, forgeHammerBreakTag, () -> Ingredient.f_43901_), (ResourceLocation)new ResourceLocation("tetra:maxed_forge_hammer"), List.of(Tiers.NETHERITE), List.of());
    private static Item.Properties itemProperties;

    public static void init(IEventBus bus) {
        bus.register(TetraRegistries.class);
        blocks.register(bus);
        items.register(bus);
        blockEntities.register(bus);
        entities.register(bus);
        particles.register(bus);
        containers.register(bus);
        effects.register(bus);
        lootConditions.register(bus);
        lootFunctions.register(bus);
        lootModifiers.register(bus);
        structureProcessors.register(bus);
        new TetraItemGroup();
        itemProperties = new Item.Properties().m_41491_((CreativeModeTab)TetraItemGroup.instance);
        RegistryObject basicWorkbench = blocks.register("basic_workbench", BasicWorkbenchBlock::new);
        TetraRegistries.registerBlockItem(basicWorkbench);
        blocks.register("block_geode", GeodeBlock::new);
        RegistryObject seepingBedrock = blocks.register("seeping_bedrock", SeepingBedrockBlock::new);
        TetraRegistries.registerBlockItem(seepingBedrock);
        RegistryObject rack = blocks.register("rack", RackBlock::new);
        TetraRegistries.registerBlockItem(rack);
        RegistryObject chthonicExtractor = blocks.register("chthonic_extractor", ChthonicExtractorBlock::new);
        ChthonicExtractorBlock.registerItems(items);
        RegistryObject fracturedBedrock = blocks.register("fractured_bedrock", FracturedBedrockBlock::new);
        blocks.register("depleted_bedrock", DepletedBedrockBlock::new);
        RegistryObject rolledScroll = blocks.register("scroll_rolled", RolledScrollBlock::new);
        RegistryObject wallScroll = blocks.register("scroll_wall", WallScrollBlock::new);
        RegistryObject openScroll = blocks.register("scroll_open", OpenScrollBlock::new);
        TetraRegistries.registerBlockItem(blocks.register("forged_wall", ForgedWallBlock::new));
        TetraRegistries.registerBlockItem(blocks.register("forged_pillar", ForgedPillarBlock::new));
        TetraRegistries.registerBlockItem(blocks.register("forged_platform", ForgedPlatformBlock::new));
        TetraRegistries.registerBlockItem(blocks.register("forged_platform_slab", ForgedPlatformSlabBlock::new));
        TetraRegistries.registerBlockItem(blocks.register("forged_vent", ForgedVentBlock::new));
        blocks.register("hammer_head", HammerHeadBlock::new);
        TetraRegistries.registerBlockItem(blocks.register("hammer_base", HammerBaseBlock::new));
        RegistryObject forgedWorkbench = blocks.register("forged_workbench", ForgedWorkbenchBlock::new);
        TetraRegistries.registerBlockItem(forgedWorkbench);
        ForgedContainerBlock.instance = blocks.register("forged_container", ForgedContainerBlock::new);
        TetraRegistries.registerBlockItem(ForgedContainerBlock.instance);
        TetraRegistries.registerBlockItem(blocks.register("forged_crate", ForgedCrateBlock::new));
        RegistryObject transferUnit = blocks.register("transfer_unit", TransferUnitBlock::new);
        TetraRegistries.registerBlockItem(transferUnit);
        CoreExtractorBaseBlock.instance = blocks.register("core_extractor", CoreExtractorBaseBlock::new);
        TetraRegistries.registerBlockItem(CoreExtractorBaseBlock.instance);
        CoreExtractorPistonBlock.instance = blocks.register("extractor_piston", CoreExtractorPistonBlock::new);
        TetraRegistries.registerBlockItem(blocks.register("extractor_pipe", CoreExtractorPipeBlock::new));
        new MultiblockSchematicBlock.Builder("stonecutter", 3, 2, ForgedBlockCommon.propertiesSolid).build(blocks, items);
        new MultiblockSchematicBlock.Builder("earthpiercer", 2, 2, ForgedBlockCommon.propertiesSolid).build(blocks, items);
        new MultiblockSchematicBlock.Builder("extractor", 3, 3, ForgedBlockCommon.propertiesSolid).build(blocks, items);
        items.register("modular_sword", ModularBladedItem::new);
        items.register("modular_double", ModularDoubleHeadedItem::new);
        items.register("modular_bow", ModularBowItem::new);
        RegistryObject shootableDummy = items.register("shootable_dummy", ShootableDummyItem::new);
        items.register("modular_crossbow", () -> new ModularCrossbowItem((Item)shootableDummy.get()));
        items.register("modular_single", ModularSingleHeadedItem::new);
        items.register("modular_shield", ModularShieldItem::new);
        ModularToolbeltItem.instance = items.register("modular_toolbelt", ModularToolbeltItem::new);
        items.register("geode", GeodeItem::new);
        items.register("pristine_lapis", PristineLapisItem::new);
        items.register("pristine_emerald", PristineEmeraldItem::new);
        items.register("pristine_diamond", PristineDiamondItem::new);
        items.register("forged_bolt", BoltItem::new);
        items.register("forged_beam", BeamItem::new);
        items.register("forged_mesh", MeshItem::new);
        items.register("quick_latch", QuickLatchItem::new);
        MetalScrapItem.instance = items.register("metal_scrap", MetalScrapItem::new);
        items.register("vent_plate", InsulatedPlateItem::new);
        items.register("planar_stabilizer", PlanarStabilizerItem::new);
        ThermalCellItem.instance = items.register("thermal_cell", ThermalCellItem::new);
        CombustionChamberItem.instance = items.register("combustion_chamber", CombustionChamberItem::new);
        LubricantDispenserItem.instance = items.register("lubricant_dispenser", LubricantDispenserItem::new);
        items.register("holo", ModularHolosphereItem::new);
        items.register("earthpiercer", EarthpiercerItem::new);
        items.register("stonecutter", StonecutterItem::new);
        items.register("dragon_sinew", DragonSinewItem::new);
        items.register("scroll_rolled", () -> new ScrollItem((Block)rolledScroll.get()));
        WorkbenchTile.type = blockEntities.register("workbench", () -> BlockEntityType.Builder.m_155273_(WorkbenchTile::new, (Block[])new Block[]{(Block)basicWorkbench.get(), (Block)forgedWorkbench.get()}).m_58966_(null));
        ChthonicExtractorTile.type = blockEntities.register("chthonic_extractor", () -> BlockEntityType.Builder.m_155273_(ChthonicExtractorTile::new, (Block[])new Block[]{(Block)chthonicExtractor.get()}).m_58966_(null));
        blockEntities.register("fractured_bedrock", () -> BlockEntityType.Builder.m_155273_(FracturedBedrockTile::new, (Block[])new Block[]{(Block)fracturedBedrock.get()}).m_58966_(null));
        blockEntities.register("rack", () -> BlockEntityType.Builder.m_155273_(RackTile::new, (Block[])new Block[]{(Block)rack.get()}).m_58966_(null));
        blockEntities.register("scroll", () -> BlockEntityType.Builder.m_155273_(ScrollTile::new, (Block[])new Block[]{(Block)openScroll.get(), (Block)wallScroll.get(), (Block)rolledScroll.get()}).m_58966_(null));
        HammerBaseBlockEntity.type = blockEntities.register("hammer_base", () -> BlockEntityType.Builder.m_155273_(HammerBaseBlockEntity::new, (Block[])new Block[]{HammerBaseBlock.instance}).m_58966_(null));
        HammerHeadBlockEntity.type = blockEntities.register("hammer_head", () -> BlockEntityType.Builder.m_155273_(HammerHeadBlockEntity::new, (Block[])new Block[]{HammerHeadBlock.instance}).m_58966_(null));
        TransferUnitBlockEntity.type = blockEntities.register("transfer_unit", () -> BlockEntityType.Builder.m_155273_(TransferUnitBlockEntity::new, (Block[])new Block[]{(Block)transferUnit.get()}).m_58966_(null));
        blockEntities.register("core_extractor", () -> BlockEntityType.Builder.m_155273_(CoreExtractorBaseBlockEntity::new, (Block[])new Block[]{(Block)CoreExtractorBaseBlock.instance.get()}).m_58966_(null));
        CoreExtractorPistonBlockEntity.type = blockEntities.register("extractor_piston", () -> BlockEntityType.Builder.m_155273_(CoreExtractorPistonBlockEntity::new, (Block[])new Block[]{(Block)CoreExtractorPistonBlock.instance.get()}).m_58966_(null));
        ForgedContainerBlockEntity.type = blockEntities.register("forged_container", () -> BlockEntityType.Builder.m_155273_(ForgedContainerBlockEntity::new, (Block[])new Block[]{(Block)ForgedContainerBlock.instance.get()}).m_58966_(null));
        entities.register("thrown_modular_item", () -> EntityType.Builder.m_20704_(ThrownModularItemEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(ThrownModularItemEntity::new).m_20699_(0.5f, 0.5f).m_20712_("thrown_modular_item"));
        entities.register("extractor_projectile", () -> EntityType.Builder.m_20704_(ExtractorProjectileEntity::new, (MobCategory)MobCategory.MISC).setCustomClientFactory(ExtractorProjectileEntity::new).m_20699_(0.5f, 0.5f).m_20712_("extractor_projectile"));
        particles.register("sparkle", () -> new SimpleParticleType(false));
        ToolbeltContainer.type = containers.register("modular_toolbelt", () -> IForgeMenuType.create((windowId, inv, data) -> ToolbeltContainer.create(windowId, inv)));
        WorkbenchContainer.containerType = containers.register("workbench", () -> IForgeMenuType.create((windowId, inv, data) -> WorkbenchContainer.create(windowId, data.m_130135_(), inv)));
        ForgedContainerMenu.type = containers.register("forged_container", () -> IForgeMenuType.create((windowId, inv, data) -> ForgedContainerMenu.create(windowId, data.m_130135_(), inv)));
        effects.register("bleeding", BleedingPotionEffect::new);
        effects.register("earthbound", EarthboundPotionEffect::new);
        effects.register("stun", StunPotionEffect::new);
        effects.register("howling", HowlingPotionEffect::new);
        effects.register("severed", SeveredPotionEffect::new);
        effects.register("punctured", PuncturedPotionEffect::new);
        effects.register("pried", PriedPotionEffect::new);
        effects.register("exhausted", ExhaustedPotionEffect::new);
        effects.register("steeled", SteeledPotionEffect::new);
        effects.register("small_strength", SmallStrengthPotionEffect::new);
        effects.register("unwavering", UnwaveringPotionEffect::new);
        effects.register("small_health", SmallHealthPotionEffect::new);
        effects.register("small_absorb", SmallAbsorbPotionEffect::new);
        effects.register("suspended", SuspendPotionEffect::new);
        effects.register("mining_speed", MiningSpeedPotionEffect::new);
        FortuneBonusCondition.type = lootConditions.register("random_chance_with_fortune", () -> new LootItemConditionType((Serializer)new FortuneBonusCondition.ConditionSerializer()));
        ScrollDataFunction.type = lootFunctions.register("scroll", () -> new LootItemFunctionType((Serializer)new ScrollDataFunction.Serializer()));
        lootModifiers.register("replace_table", ReplaceTableModifier.codec);
        ForgedHammerProcessor.type = TetraRegistries.registerStructureProcessor("hammer", () -> ForgedHammerProcessor.codec);
        ForgedCrateProcessor.type = TetraRegistries.registerStructureProcessor("crate", () -> ForgedCrateProcessor.codec);
        ForgedContainerProcessor.type = TetraRegistries.registerStructureProcessor("container", () -> ForgedContainerProcessor.codec);
        TransferUnitProcessor.type = TetraRegistries.registerStructureProcessor("transfer_unit", () -> TransferUnitProcessor.codec);
        MultiblockSchematicProcessor.type = TetraRegistries.registerStructureProcessor("multiblock_schematic", () -> MultiblockSchematicProcessor.codec);
        CraftingHelper.register((ResourceLocation)new ResourceLocation("tetra", "scroll"), (IIngredientSerializer)ScrollIngredient.Serializer.instance);
    }

    public static <B extends Block> RegistryObject<Item> registerBlockItem(RegistryObject<B> block) {
        return items.register(block.getId().m_135815_(), () -> new BlockItem((Block)block.get(), itemProperties));
    }

    public static <P extends StructureProcessor> RegistryObject<StructureProcessorType<?>> registerStructureProcessor(String id, StructureProcessorType<P> type) {
        return structureProcessors.register(id, () -> type);
    }

    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                CriteriaTriggers.m_10595_(BlockUseCriterion.trigger);
                CriteriaTriggers.m_10595_(BlockInteractionCriterion.trigger);
                CriteriaTriggers.m_10595_(ModuleCraftCriterion.trigger);
                CriteriaTriggers.m_10595_(ImprovementCraftCriterion.trigger);
                ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:modular_item"), ItemPredicateModular::new);
                ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:material"), MaterialItemPredicate::new);
                ItemPredicate.register((ResourceLocation)new ResourceLocation("tetra:loose"), LooseItemPredicate::new);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        blocks.getEntries().stream().map(RegistryObject::get).filter(block -> block instanceof InitializableBlock).map(block -> (InitializableBlock)block).forEach(block -> block.commonInit(TetraMod.packetHandler));
        items.getEntries().stream().map(RegistryObject::get).filter(item -> item instanceof InitializableItem).map(item -> (InitializableItem)item).forEach(item -> item.commonInit(TetraMod.packetHandler));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup(FMLClientSetupEvent event) {
        event.enqueueWork(() -> {
            try {
                blocks.getEntries().stream().map(RegistryObject::get).filter(block -> block instanceof InitializableBlock).map(block -> (InitializableBlock)block).forEach(InitializableBlock::clientInit);
                items.getEntries().stream().map(RegistryObject::get).filter(item -> item instanceof InitializableItem).map(item -> (InitializableItem)item).forEach(InitializableItem::clientInit);
                MinecraftForge.EVENT_BUS.register((Object)new InteractiveBlockOverlay());
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
    }
}

