/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.industrial.worlddata;

import com.buuz135.industrial.block.generator.mycelial.IMycelialGeneratorType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.common.util.INBTSerializable;

public class MycelialDataManager
extends SavedData {
    public static final String NAME = "IFMycelial";
    public HashMap<String, HashMap<String, List<GeneratorInfo>>> infos = new HashMap();

    public static void setGeneratorInfo(String uuid, Level world, BlockPos pos, IMycelialGeneratorType type) {
        if (world instanceof ServerLevel) {
            MycelialDataManager dataManager = MycelialDataManager.getData((LevelAccessor)world);
            List generatorInfos = dataManager.getInfos().computeIfAbsent(uuid, s -> new HashMap()).computeIfAbsent(type.getName(), s -> new ArrayList());
            boolean updated = false;
            for (GeneratorInfo generatorInfo : generatorInfos) {
                if (!generatorInfo.pos.equals((Object)pos) || !generatorInfo.world.equals((Object)world.m_46472_())) continue;
                updated = true;
                generatorInfo.lastRun = world.m_46467_();
            }
            if (!updated) {
                generatorInfos.add(new GeneratorInfo(world.m_46467_(), 0L, pos, (ResourceKey<Level>)world.m_46472_()));
            }
            dataManager.m_77762_();
        }
    }

    public static void removeGeneratorInfo(String uuid, Level world, BlockPos pos, IMycelialGeneratorType type) {
        MycelialDataManager dataManager = MycelialDataManager.getData((LevelAccessor)world);
        List generatorInfos = dataManager.getInfos().computeIfAbsent(uuid, s -> new HashMap()).computeIfAbsent(type.getName(), s -> new ArrayList());
        generatorInfos.removeIf(generatorInfo -> generatorInfo.world.equals((Object)world.m_46472_()) && generatorInfo.pos.equals((Object)pos));
        dataManager.m_77762_();
    }

    public static List<String> getReactorAvailable(String uuid, Level world, boolean execute) {
        ArrayList<String> names = new ArrayList<String>();
        if (world instanceof ServerLevel) {
            MycelialDataManager dataManager = MycelialDataManager.getData((LevelAccessor)world);
            HashMap generators = dataManager.getInfos().computeIfAbsent(uuid, s -> new HashMap());
            block0: for (IMycelialGeneratorType type : IMycelialGeneratorType.TYPES) {
                for (GeneratorInfo generatorInfo : generators.computeIfAbsent(type.getName(), s -> new ArrayList())) {
                    if (generatorInfo.lastTracked + 5L > world.m_46467_() || generatorInfo.lastRun + 5L < world.m_46467_()) continue;
                    names.add(type.getName());
                    if (execute) {
                        generatorInfo.lastTracked = world.m_46467_();
                    }
                    dataManager.m_77762_();
                    continue block0;
                }
            }
        }
        return names;
    }

    public HashMap<String, HashMap<String, List<GeneratorInfo>>> getInfos() {
        return this.infos;
    }

    public static MycelialDataManager load(CompoundTag nbt) {
        MycelialDataManager mycelialDataManager = new MycelialDataManager();
        for (String uuid : nbt.m_128469_("values").m_128431_()) {
            CompoundTag uuidNbt = nbt.m_128469_("values").m_128469_(uuid);
            HashMap<String, List> generators = new HashMap<String, List>();
            for (String genName : uuidNbt.m_128431_()) {
                CompoundTag genNbt = uuidNbt.m_128469_(genName);
                for (String s : genNbt.m_128431_()) {
                    GeneratorInfo generatorInfo = new GeneratorInfo();
                    generatorInfo.deserializeNBT(genNbt.m_128469_(s));
                    generators.computeIfAbsent(genName, s1 -> new ArrayList()).add(generatorInfo);
                }
            }
            mycelialDataManager.infos.put(uuid, generators);
        }
        return mycelialDataManager;
    }

    public CompoundTag m_7176_(CompoundTag compound) {
        CompoundTag values = new CompoundTag();
        for (String uuid : this.infos.keySet()) {
            CompoundTag uuidNbt = new CompoundTag();
            for (String genName : this.infos.get(uuid).keySet()) {
                int i = 0;
                CompoundTag genNbt = new CompoundTag();
                for (GeneratorInfo generatorInfo : this.infos.get(uuid).get(genName)) {
                    genNbt.m_128365_("" + i, (Tag)generatorInfo.serializeNBT());
                    ++i;
                }
                uuidNbt.m_128365_(genName, (Tag)genNbt);
            }
            values.m_128365_(uuid, (Tag)uuidNbt);
        }
        compound.m_128365_("values", (Tag)values);
        return compound;
    }

    @Nullable
    public static MycelialDataManager getData(LevelAccessor world) {
        if (world instanceof ServerLevel) {
            ServerLevel serverWorld = ((ServerLevel)world).m_7654_().m_129880_(Level.f_46428_);
            MycelialDataManager data = (MycelialDataManager)serverWorld.m_8895_().m_164861_(MycelialDataManager::load, MycelialDataManager::new, NAME);
            return data;
        }
        return null;
    }

    public static class GeneratorInfo
    implements INBTSerializable<CompoundTag> {
        private long lastRun;
        private long lastTracked;
        private BlockPos pos;
        private ResourceKey<Level> world;

        public GeneratorInfo(long lastRun, long lastTracked, BlockPos pos, ResourceKey<Level> world) {
            this.lastRun = lastRun;
            this.lastTracked = lastTracked;
            this.pos = pos;
            this.world = world;
        }

        public GeneratorInfo() {
        }

        public CompoundTag serializeNBT() {
            CompoundTag compoundNBT = new CompoundTag();
            compoundNBT.m_128356_("Run", this.lastRun);
            compoundNBT.m_128356_("Track", this.lastTracked);
            compoundNBT.m_128356_("Pos", this.pos.m_121878_());
            compoundNBT.m_128359_("RKValue", this.world.m_135782_().toString());
            return compoundNBT;
        }

        public void deserializeNBT(CompoundTag nbt) {
            this.lastRun = nbt.m_128454_("Run");
            this.lastTracked = nbt.m_128454_("Track");
            this.pos = BlockPos.m_122022_((long)nbt.m_128454_("Pos"));
            this.world = ResourceKey.m_135785_((ResourceKey)Registry.f_122819_, (ResourceLocation)new ResourceLocation(nbt.m_128461_("RKValue")));
        }
    }
}

