/*
 * Decompiled with CFR 0.152.
 */
package snownee.jade.addon.create;

import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import snownee.jade.addon.create.CreatePlugin;
import snownee.jade.api.EntityAccessor;
import snownee.jade.api.IEntityComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.Identifiers;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public enum ContraptionExactBlockProvider implements IEntityComponentProvider
{
    INSTANCE;

    private long time = Long.MIN_VALUE;
    private BlockState hitBlock;
    private BlockHitResult hitResult;

    @Nullable
    public IElement getIcon(EntityAccessor accessor, IPluginConfig config, IElement currentIcon) {
        if (this.validate()) {
            ItemStack stack = this.hitBlock.getCloneItemStack((HitResult)this.hitResult, (BlockGetter)accessor.getLevel(), this.hitResult.m_82425_(), accessor.getPlayer());
            return IElementHelper.get().item(stack);
        }
        return null;
    }

    public void appendTooltip(ITooltip tooltip, EntityAccessor accessor, IPluginConfig config) {
        ItemStack pick;
        if (!this.validate()) {
            return;
        }
        Object name = null;
        if (CreatePlugin.client.shouldPick(this.hitBlock) && (pick = this.hitBlock.getCloneItemStack((HitResult)this.hitResult, (BlockGetter)accessor.getLevel(), this.hitResult.m_82425_(), accessor.getPlayer())) != null && !pick.m_41619_()) {
            name = pick.m_41786_();
        }
        if (name == null) {
            ItemStack pick2;
            String key = this.hitBlock.m_60734_().m_7705_();
            name = I18n.m_118936_((String)key) ? this.hitBlock.m_60734_().m_49954_() : ((pick2 = accessor.getPickedResult()) != null && !pick2.m_41619_() ? pick2.m_41786_() : Component.m_237113_((String)key));
        }
        tooltip.remove(Identifiers.CORE_OBJECT_NAME);
        tooltip.add(0, (Component)config.getWailaConfig().getFormatting().title(name).m_6881_().m_130940_(ChatFormatting.ITALIC), Identifiers.CORE_OBJECT_NAME);
    }

    public void setHit(BlockHitResult hitResult, BlockState hitBlock) {
        this.hitResult = hitResult;
        this.hitBlock = hitBlock;
        this.time = Util.m_137550_();
    }

    private boolean validate() {
        return Util.m_137550_() - this.time < 10L;
    }

    public ResourceLocation getUid() {
        return CreatePlugin.CONTRAPTION_EXACT_BLOCK;
    }

    public int getDefaultPriority() {
        return -10000;
    }
}

