/*
 * Decompiled with CFR 0.152.
 */
package de.castcrafter.travelanchors.block;

import de.castcrafter.travelanchors.ModBlocks;
import de.castcrafter.travelanchors.TeleportHandler;
import de.castcrafter.travelanchors.TravelAnchorList;
import de.castcrafter.travelanchors.block.MenuTravelAnchor;
import de.castcrafter.travelanchors.block.RenderTravelAnchor;
import de.castcrafter.travelanchors.block.ScreenTravelAnchor;
import de.castcrafter.travelanchors.block.TileTravelAnchor;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.moddingx.libx.base.tile.MenuBlockBE;
import org.moddingx.libx.mod.ModX;
import org.moddingx.libx.registration.SetupContext;

public class BlockTravelAnchor
extends MenuBlockBE<TileTravelAnchor, MenuTravelAnchor> {
    private static final VoxelShape SHAPE = Shapes.m_83048_((double)0.01, (double)0.01, (double)0.01, (double)0.99, (double)0.99, (double)0.99);

    public BlockTravelAnchor(ModX mod, Class<TileTravelAnchor> teClass, MenuType<MenuTravelAnchor> menu, BlockBehaviour.Properties properties) {
        super(mod, teClass, menu, properties);
    }

    public BlockTravelAnchor(ModX mod, Class<TileTravelAnchor> teClass, MenuType<MenuTravelAnchor> menu, BlockBehaviour.Properties properties, Item.Properties itemProperties) {
        super(mod, teClass, menu, properties, itemProperties);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void registerClient(SetupContext ctx) {
        MenuScreens.m_96206_((MenuType)ModBlocks.travelAnchor.menu, ScreenTravelAnchor::new);
        BlockEntityRenderers.m_173590_((BlockEntityType)ModBlocks.travelAnchor.getBlockEntityType(), dispatcher -> new RenderTravelAnchor());
    }

    public int m_7753_(@Nonnull BlockState state, BlockGetter level, @Nonnull BlockPos pos) {
        BlockState mimic;
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof TileTravelAnchor && (mimic = ((TileTravelAnchor)tile).getMimic()) != null) {
            return mimic.m_60739_(level, pos);
        }
        return super.m_7753_(state, level, pos);
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        BlockState mimic;
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof TileTravelAnchor && (mimic = ((TileTravelAnchor)tile).getMimic()) != null) {
            return mimic.m_60651_(level, pos, context);
        }
        return Shapes.m_83144_();
    }

    @Nonnull
    public VoxelShape m_7952_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos) {
        BlockState mimic;
        BlockEntity tile = level.m_7702_(pos);
        if (tile instanceof TileTravelAnchor && (mimic = ((TileTravelAnchor)tile).getMimic()) != null) {
            return mimic.m_60816_(level, pos);
        }
        return SHAPE;
    }

    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, @Nonnull TooltipFlag flag) {
        tooltip.add((Component)Component.m_237115_((String)"tooltip.travelanchors.travel_anchor_block"));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hit) {
        BlockEntity be = level.m_7702_(pos);
        if (be instanceof TileTravelAnchor) {
            Item item;
            TileTravelAnchor anchor = (TileTravelAnchor)be;
            ItemStack stack = player.m_21120_(hand);
            if (anchor.isLocked()) {
                if (stack.m_41720_() == Items.f_42398_) {
                    if (!level.f_46443_) {
                        anchor.setLocked(false);
                        player.m_5661_((Component)Component.m_237115_((String)"travelanchors.lock.unlocked"), true);
                    }
                    return InteractionResult.m_19078_((boolean)level.f_46443_);
                }
                if (!level.f_46443_ && !TeleportHandler.canPlayerTeleportAnyHand(player)) {
                    player.m_5661_((Component)Component.m_237115_((String)"travelanchors.lock.interact"), true);
                }
                return InteractionResult.PASS;
            }
            ItemStack offhand = player.m_21120_(InteractionHand.OFF_HAND);
            if (hand == InteractionHand.MAIN_HAND && stack.m_41619_() && !offhand.m_41619_() && (item = offhand.m_41720_()) instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                if (!level.f_46443_) {
                    BlockState mimicState = blockItem.m_40614_().m_5573_(new BlockPlaceContext(player, InteractionHand.OFF_HAND, offhand, hit));
                    if (mimicState == null || mimicState.m_60734_() == this) {
                        anchor.setMimic(null);
                    } else {
                        anchor.setMimic(mimicState);
                    }
                }
                return InteractionResult.m_19078_((boolean)level.f_46443_);
            }
            return super.m_6227_(state, level, pos, player, hand, hit);
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        super.m_6810_(state, level, pos, newState, isMoving);
        TravelAnchorList.get(level).setAnchor(level, pos, null, ModBlocks.travelAnchor.m_49966_());
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.ENTITYBLOCK_ANIMATED;
    }
}

