/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge;

import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.common.casting.Patterns;
import ram.talia.hexal.common.lib.HexalBlockEntities;
import ram.talia.hexal.common.lib.HexalBlocks;
import ram.talia.hexal.common.lib.HexalEntities;
import ram.talia.hexal.common.lib.HexalIotaTypes;
import ram.talia.hexal.common.lib.HexalSounds;
import ram.talia.hexal.common.lib.feature.HexalConfiguredFeatures;
import ram.talia.hexal.common.lib.feature.HexalFeatures;
import ram.talia.hexal.common.lib.feature.HexalPlacedFeatures;
import ram.talia.hexal.common.recipe.HexalRecipeSerializers;
import ram.talia.hexal.common.recipe.HexalRecipeTypes;
import ram.talia.hexal.forge.ForgeHexalClientInitializer;
import ram.talia.hexal.forge.ForgeHexalConfig;
import ram.talia.hexal.forge.datagen.HexalForgeDataGenerators;
import ram.talia.hexal.forge.eventhandlers.BoundStorageEventHandler;
import ram.talia.hexal.forge.eventhandlers.EverbookEventHandler;
import ram.talia.hexal.forge.eventhandlers.GateEventHandler;
import ram.talia.hexal.forge.eventhandlers.PlayerLinkstoreEventHandler;
import ram.talia.hexal.forge.eventhandlers.RenderLinkEventHandler;
import ram.talia.hexal.forge.eventhandlers.WispCastingMangerEventHandler;
import ram.talia.hexal.forge.network.ForgePacketHandler;
import thedarkcolour.kotlinforforge.KotlinModLoadingContext;

@Mod(value="hexal")
public class ForgeHexalInitializer {
    public ForgeHexalInitializer() {
        HexalAPI.LOGGER.info("Hello Forge World!");
        ForgeHexalInitializer.initConfig();
        ForgeHexalInitializer.initRegistry();
        ForgeHexalInitializer.initListeners();
    }

    private static void initConfig() {
        Pair config = new ForgeConfigSpec.Builder().configure(ForgeHexalConfig::new);
        Pair clientConfig = new ForgeConfigSpec.Builder().configure(ForgeHexalConfig.Client::new);
        Pair serverConfig = new ForgeConfigSpec.Builder().configure(ForgeHexalConfig.Server::new);
        HexalConfig.setCommon((HexalConfig.CommonConfigAccess)config.getLeft());
        HexalConfig.setClient((HexalConfig.ClientConfigAccess)clientConfig.getLeft());
        HexalConfig.setServer((HexalConfig.ServerConfigAccess)serverConfig.getLeft());
        ModLoadingContext mlc = ModLoadingContext.get();
        mlc.registerConfig(ModConfig.Type.COMMON, (IConfigSpec)config.getRight());
        mlc.registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)clientConfig.getRight());
        mlc.registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverConfig.getRight());
    }

    private static void initRegistry() {
        ForgeHexalInitializer.bind(Registry.f_122838_, HexalFeatures::registerFeatures);
        ForgeHexalInitializer.bind(BuiltinRegistries.f_123861_, HexalConfiguredFeatures::registerConfiguredFeatures);
        ForgeHexalInitializer.bind(BuiltinRegistries.f_194653_, HexalPlacedFeatures::registerPlacedFeatures);
        ForgeHexalInitializer.bind(Registry.f_122898_, HexalSounds::registerSounds);
        ForgeHexalInitializer.bind(Registry.f_122901_, HexalBlocks::registerBlocks);
        ForgeHexalInitializer.bind(Registry.f_122904_, HexalBlocks::registerBlockItems);
        ForgeHexalInitializer.bind(Registry.f_122907_, HexalBlockEntities::registerBlockEntities);
        ForgeHexalInitializer.bind(Registry.f_122903_, HexalEntities::registerEntities);
        ForgeHexalInitializer.bind(Registry.f_122915_, HexalRecipeSerializers::registerSerializers);
        ForgeHexalInitializer.bind(Registry.f_122914_, HexalRecipeTypes::registerTypes);
        HexalIotaTypes.registerTypes();
    }

    private static void initListeners() {
        IEventBus modBus = ForgeHexalInitializer.getModEventBus();
        IEventBus evBus = MinecraftForge.EVENT_BUS;
        modBus.register(ForgeHexalClientInitializer.class);
        modBus.addListener(evt -> evt.enqueueWork(() -> ForgePacketHandler.init()));
        modBus.addListener(evt -> evt.enqueueWork(Patterns::registerPatterns));
        modBus.register(HexalForgeDataGenerators.class);
        evBus.register(BoundStorageEventHandler.class);
        evBus.register(EverbookEventHandler.class);
        evBus.register(GateEventHandler.class);
        evBus.register(PlayerLinkstoreEventHandler.class);
        evBus.register(RenderLinkEventHandler.class);
        evBus.register(WispCastingMangerEventHandler.class);
    }

    private static <T> void bind(ResourceKey<Registry<T>> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        ForgeHexalInitializer.getModEventBus().addListener(event -> {
            if (registry.equals((Object)event.getRegistryKey())) {
                source.accept((t, rl) -> event.register(registry, rl, () -> t));
            }
        });
    }

    private static <T> void bind(Registry<T> registry, Consumer<BiConsumer<T, ResourceLocation>> source) {
        source.accept((t, id) -> Registry.m_122965_((Registry)registry, (ResourceLocation)id, (Object)t));
    }

    private static IEventBus getModEventBus() {
        return KotlinModLoadingContext.Companion.get().getKEventBus();
    }
}

