/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.forge;

import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.config.HexalConfig;

public class ForgeHexalConfig
implements HexalConfig.CommonConfigAccess {
    public ForgeHexalConfig(ForgeConfigSpec.Builder builder) {
    }

    public static class Server
    implements HexalConfig.ServerConfigAccess {
        private static ForgeConfigSpec.BooleanValue generateSlipwayGeodes;
        private static ForgeConfigSpec.DoubleValue fallingBlockCost;
        private static ForgeConfigSpec.DoubleValue freezeCost;
        private static ForgeConfigSpec.DoubleValue particlesCost;
        private static ForgeConfigSpec.DoubleValue placeTypeCost;
        private static ForgeConfigSpec.DoubleValue smeltCost;
        private static ForgeConfigSpec.DoubleValue moveSpeedSetCost;
        private static ForgeConfigSpec.DoubleValue summonTickingWispCost;
        private static ForgeConfigSpec.DoubleValue summonProjectileWispCost;
        private static ForgeConfigSpec.DoubleValue summonProjectileWispMinCost;
        private static ForgeConfigSpec.DoubleValue tickingWispUpkeepPerTick;
        private static ForgeConfigSpec.DoubleValue projectileWispUpkeepPerTick;
        private static ForgeConfigSpec.DoubleValue untriggeredWispUpkeepDiscount;
        private static ForgeConfigSpec.DoubleValue linkUpkeepPerTick;
        private static ForgeConfigSpec.DoubleValue seonDiscountFactor;
        private static ForgeConfigSpec.DoubleValue storingPlayerCostScaleFactor;
        private static ForgeConfigSpec.DoubleValue mediaFlowRateOverLink;
        private static ForgeConfigSpec.DoubleValue linkCost;
        private static ForgeConfigSpec.DoubleValue sendIotaCost;
        private static ForgeConfigSpec.DoubleValue unlinkCost;
        private static ForgeConfigSpec.DoubleValue makeGateCost;
        private static ForgeConfigSpec.DoubleValue markGateCost;
        private static ForgeConfigSpec.DoubleValue closeGateCost;
        private static ForgeConfigSpec.DoubleValue closeGateDistanceCostFactor;
        private static ForgeConfigSpec.DoubleValue bindStorageCost;
        private static ForgeConfigSpec.DoubleValue bindTemporaryStorageCost;
        private static ForgeConfigSpec.DoubleValue makeItemCost;
        private static ForgeConfigSpec.DoubleValue returnItemCost;
        private static ForgeConfigSpec.DoubleValue craftItemCost;
        private static ForgeConfigSpec.DoubleValue tradeItemCost;
        private static ForgeConfigSpec.IntValue maxItemsReturned;
        private static ForgeConfigSpec.IntValue maxRecordsInMediafiedStorage;
        private static ForgeConfigSpec.DoubleValue consumeWispOwnCost;
        private static ForgeConfigSpec.DoubleValue consumeWispOthersCostPerMedia;
        private static ForgeConfigSpec.DoubleValue seonWispSetCost;
        private static ForgeConfigSpec.DoubleValue tickConstantCost;
        private static ForgeConfigSpec.DoubleValue tickCostPerTicked;
        private static ForgeConfigSpec.IntValue tickRandomTickIProb;
        private static ForgeConfigSpec.ConfigValue<List<? extends String>> accelerateDenyList;

        public Server(ForgeConfigSpec.Builder builder) {
            builder.translation("text.autoconfig.hexal.option.server.terrainGeneration").push("terrainGeneration");
            generateSlipwayGeodes = builder.translation("text.autoconfig.hexal.option.server.generateSlipwayGeodes").define("generateSlipwayGeodes", true);
            builder.pop();
            builder.translation("text.autoconfig.hexal.option.server.miscSpells").push("miscSpells");
            fallingBlockCost = builder.translation("text.autoconfig.hexal.option.server.miscSpells.fallingBlockCost").defineInRange("fallingBlockCost", 1.5, 1.0E-4, 10000.0);
            freezeCost = builder.translation("text.autoconfig.hexal.option.server.miscSpells.freezeCost").defineInRange("freezeCost", 1.0, 1.0E-4, 10000.0);
            particlesCost = builder.translation("text.autoconfig.hexal.option.server.miscSpells.particlesCost").defineInRange("particlesCost", 0.01, 1.0E-4, 10000.0);
            placeTypeCost = builder.translation("text.autoconfig.hexal.option.server.miscSpells.placeTypeCost").defineInRange("placeTypeCost", 0.125, 1.0E-4, 10000.0);
            smeltCost = builder.translation("text.autoconfig.hexal.option.server.miscSpells.smeltCost").defineInRange("smeltCost", 0.75, 1.0E-4, 10000.0);
            builder.pop();
            builder.translation("text.autoconfig.hexal.option.server.wispSpells").push("wispSpells");
            moveSpeedSetCost = builder.translation("text.autoconfig.hexal.option.server.wispSpells.moveSpeedSetCost").comment(new String[]{"Cost to increase the movement speed of a wisp by 1.", "This is the base cost, with greater increases being quadratically based on this."}).defineInRange("moveSpeedSetCost", 1.0, 1.0E-4, 10000.0);
            summonTickingWispCost = builder.translation("text.autoconfig.hexal.option.server.wispSpells.summonTickingWispCost").defineInRange("summonTickingWispCost", 3.0, 1.0E-4, 10000.0);
            summonProjectileWispCost = builder.translation("text.autoconfig.hexal.option.server.wispSpells.summonProjectileWispCost").defineInRange("summonProjectileWispCost", 1.7, 1.0E-4, 10000.0);
            summonProjectileWispMinCost = builder.translation("text.autoconfig.hexal.option.server.wispSpells.summonProjectileWispMinCost").defineInRange("summonProjectileWispMinCost", 0.5, 1.0E-4, 10000.0);
            builder.pop();
            builder.translation("text.autoconfig.hexal.option.server.wispUpkeep").push("wispUpkeep");
            tickingWispUpkeepPerTick = builder.translation("text.autoconfig.hexal.option.server.wispUpkeep.tickingWispUpkeepPerTick").defineInRange("tickingWispUpkeepPerTick", 0.0325, 1.0E-4, 10000.0);
            projectileWispUpkeepPerTick = builder.translation("text.autoconfig.hexal.option.server.wispUpkeep.projectileWispUpkeepPerTick").defineInRange("projectileWispUpkeepPerTick", 0.01625, 1.0E-4, 10000.0);
            untriggeredWispUpkeepDiscount = builder.translation("text.autoconfig.hexal.option.server.wispUpkeep.untriggeredWispUpkeepDiscount").comment("The upkeep cost of untriggered cyclic wisps is multiplied by this number.").defineInRange("untriggeredWispUpkeepDiscount", 0.77, 0.0, 1.0);
            linkUpkeepPerTick = builder.translation("text.autoconfig.hexal.option.server.wispUpkeep.linkUpkeepPerTick").defineInRange("linkUpkeepPerTick", 5.0E-4, 1.0E-4, 10000.0);
            seonDiscountFactor = builder.translation("text.autoconfig.hexal.option.server.wispUpkeep.seonDiscountFactor").comment("The upkeep cost of bound wisps is divided by this number.").defineInRange("seonDiscountFactor", 20.0, 2.0, 200.0);
            storingPlayerCostScaleFactor = builder.translation("text.autoconfig.hexal.option.server.wispUpkeep.storingPlayerCostScaleFactor").comment("The multiplicative cost increase of wisps containing an iota of another player.").defineInRange("storingPlayerCostScaleFactor", 20.0, 1.0, 200.0);
            mediaFlowRateOverLink = builder.translation("text.autoconfig.hexal.option.server.wispUpkeep.mediaFlowRateOverLink").comment("Proportion of the difference between media amounts that flows across a link per tick.").defineInRange("mediaFlowRateOverLink", 0.01, 0.0, 0.1);
            builder.pop();
            builder.translation("text.autoconfig.hexal.option.server.linkSpells").push("linkSpells");
            linkCost = builder.translation("text.autoconfig.hexal.option.server.linkSpells.linkCost").defineInRange("linkCost", 5.0, 1.0E-4, 10000.0);
            sendIotaCost = builder.translation("text.autoconfig.hexal.option.server.linkSpells.sendIotaCost").defineInRange("sendIotaCost", 0.01, 1.0E-4, 10000.0);
            unlinkCost = builder.translation("text.autoconfig.hexal.option.server.linkSpells.unlinkCost").defineInRange("unlinkCost", 2.0, 1.0E-4, 10000.0);
            builder.pop();
            builder.translation("text.autoconfig.hexal.option.server.gateSpells").push("gateSpells");
            makeGateCost = builder.translation("text.autoconfig.hexal.option.server.gateSpells.makeGateCost").defineInRange("makeGateCost", 320.0, 1.0E-4, 10000.0);
            markGateCost = builder.translation("text.autoconfig.hexal.option.server.gateSpells.markGateCost").defineInRange("markGateCost", 0.05, 1.0E-4, 10000.0);
            closeGateCost = builder.translation("text.autoconfig.hexal.option.server.gateSpells.closeGateCost").defineInRange("closeGateCost", 2.5, 1.0E-4, 10000.0);
            closeGateDistanceCostFactor = builder.translation("text.autoconfig.hexal.option.server.gateSpells.closeGateDistanceCostFactor").defineInRange("closeGateDistanceCostFactor", 0.1, 1.0E-4, 10000.0);
            builder.pop();
            builder.translation("text.autoconfig.hexal.option.server.itemSpells").push("itemSpells");
            bindStorageCost = builder.translation("text.autoconfig.hexal.option.server.itemSpells.bindStorageCost").defineInRange("bindStorageCost", 32.0, 1.0E-4, 10000.0);
            bindTemporaryStorageCost = builder.translation("text.autoconfig.hexal.option.server.itemSpells.bindTemporaryStorageCost").defineInRange("bindTemporaryStorageCost", 0.001, 1.0E-4, 10000.0);
            makeItemCost = builder.translation("text.autoconfig.hexal.option.server.itemSpells.makeItemCost").defineInRange("makeItemCost", 0.1, 1.0E-4, 10000.0);
            returnItemCost = builder.translation("text.autoconfig.hexal.option.server.itemSpells.returnItemCost").defineInRange("returnItemCost", 0.1, 1.0E-4, 10000.0);
            craftItemCost = builder.translation("text.autoconfig.hexal.option.server.itemSpells.craftItemCost").defineInRange("craftItemCost", 0.1, 1.0E-4, 10000.0);
            tradeItemCost = builder.translation("text.autoconfig.hexal.option.server.itemSpells.tradeItemCost").defineInRange("tradeItemCost", 0.1, 1.0E-4, 10000.0);
            maxItemsReturned = builder.translation("text.autoconfig.hexal.option.server.itemSpells.maxItemsReturned").comment("Maximum number of items that can be returned to the world as item entities in a single OpReturnItem call.").defineInRange("maxItemsReturned", 32000, 640, 64000);
            maxRecordsInMediafiedStorage = builder.translation("text.autoconfig.hexal.option.server.itemSpells.maxRecordsInMediafiedStorage").comment("Maximum number of Item Records (the things Item Iotas point at) that can be stored in a Mediafied Storage block.").defineInRange("maxRecordsInMediafiedStorage", 1023, 128, 16384);
            builder.pop();
            builder.translation("text.autoconfig.hexal.option.server.greatSpells").push("greatSpells");
            consumeWispOwnCost = builder.translation("text.autoconfig.hexal.option.server.greatSpells.consumeWispOwnCost").comment(new String[]{"Cost to consume a wisp you own,", "or that doesn't fight back for some other reason."}).defineInRange("consumeWispOwnCost", 5.0, 1.0E-4, 10000.0);
            consumeWispOthersCostPerMedia = builder.translation("text.autoconfig.hexal.option.server.greatSpells.consumeWispOthersCostPerMedia").comment(new String[]{"Cost to consume a wisp that fights back, this number is multiplied by", "the media possessed by the wisp you are attempting to consume."}).defineInRange("consumeWispOthersCostPerMedia", 1.5, 1.0, 20.0);
            seonWispSetCost = builder.translation("text.autoconfig.hexal.option.server.greatSpells.seonWispSetCost").defineInRange("seonWispSetCost", 50.0, 1.0E-4, 10000.0);
            tickConstantCost = builder.translation("text.autoconfig.hexal.option.server.greatSpells.tickConstantCost").comment("Constant cost to tick a block. Always applies.").defineInRange("tickConstantCost", 0.1, 1.0E-4, 10000.0);
            tickCostPerTicked = builder.translation("text.autoconfig.hexal.option.server.greatSpells.tickCostPerTicked").comment(new String[]{"Cost to tick a block per time that block has already been ticked.", "Added to the constant cost above."}).defineInRange("tickCostPerTicked", 0.001, 1.0E-4, 10000.0);
            tickRandomTickIProb = builder.translation("text.autoconfig.hexal.option.server.greatSpells.tickRandomTickIProb").comment(new String[]{"The inverse probability of tick randomly ticking a block.", "Higher numbers make random ticks less likely, lower numbers make them more likely."}).defineInRange("tickRandomTickIProb", 1365, 600, 2100);
            accelerateDenyList = builder.comment("Resource locations of blocks you can't accelerate.").defineList("accelerateDenyList", HexalConfig.ServerConfigAccess.Companion.getDEFAULT_ACCELERATE_DENY_LIST(), Server::isValidReslocArg);
            builder.pop();
        }

        private static boolean isValidReslocArg(Object o) {
            String s;
            return o instanceof String && ResourceLocation.m_135830_((String)(s = (String)o));
        }

        @Override
        public boolean getGenerateSlipwayGeodes() {
            return (Boolean)generateSlipwayGeodes.get();
        }

        @Override
        public int getFallingBlockCost() {
            return (int)((Double)fallingBlockCost.get() * 10000.0);
        }

        @Override
        public int getFreezeCost() {
            return (int)((Double)freezeCost.get() * 10000.0);
        }

        @Override
        public int getParticlesCost() {
            return (int)((Double)particlesCost.get() * 10000.0);
        }

        @Override
        public int getPlaceTypeCost() {
            return (int)((Double)placeTypeCost.get() * 10000.0);
        }

        @Override
        public int getSmeltCost() {
            return (int)((Double)smeltCost.get() * 10000.0);
        }

        @Override
        public double getPhaseBlockCostFactor() {
            return 0.0;
        }

        @Override
        public int getMoveSpeedSetCost() {
            return (int)((Double)moveSpeedSetCost.get() * 10000.0);
        }

        @Override
        public int getSummonTickingWispCost() {
            return (int)((Double)summonTickingWispCost.get() * 10000.0);
        }

        @Override
        public int getSummonProjectileWispCost() {
            return (int)((Double)summonProjectileWispCost.get() * 10000.0);
        }

        @Override
        public int getSummonProjectileWispMinCost() {
            return (int)((Double)summonProjectileWispMinCost.get() * 10000.0);
        }

        @Override
        public int getTickingWispUpkeepPerTick() {
            return (int)((Double)tickingWispUpkeepPerTick.get() * 10000.0);
        }

        @Override
        public int getProjectileWispUpkeepPerTick() {
            return (int)((Double)projectileWispUpkeepPerTick.get() * 10000.0);
        }

        @Override
        public double getUntriggeredWispUpkeepDiscount() {
            return (Double)untriggeredWispUpkeepDiscount.get();
        }

        @Override
        public int getLinkUpkeepPerTick() {
            return (int)((Double)linkUpkeepPerTick.get() * 10000.0);
        }

        @Override
        public double getSeonDiscountFactor() {
            return (Double)seonDiscountFactor.get();
        }

        @Override
        public double getStoringPlayerCostScaleFactor() {
            return (Double)storingPlayerCostScaleFactor.get();
        }

        @Override
        public double getMediaFlowRateOverLink() {
            return (Double)mediaFlowRateOverLink.get();
        }

        @Override
        public int getLinkCost() {
            return (int)((Double)linkCost.get() * 10000.0);
        }

        @Override
        public int getSendIotaCost() {
            return (int)((Double)sendIotaCost.get() * 10000.0);
        }

        @Override
        public int getUnlinkCost() {
            return (int)((Double)unlinkCost.get() * 10000.0);
        }

        @Override
        public int getMakeGateCost() {
            return (int)((Double)makeGateCost.get() * 10000.0);
        }

        @Override
        public int getMarkGateCost() {
            return (int)((Double)markGateCost.get() * 10000.0);
        }

        @Override
        public int getCloseGateCost() {
            return (int)((Double)closeGateCost.get() * 10000.0);
        }

        @Override
        public int getCloseGateDistanceCostFactor() {
            return (int)((Double)closeGateDistanceCostFactor.get() * 10000.0);
        }

        @Override
        public int getBindStorageCost() {
            return (int)((Double)bindStorageCost.get() * 10000.0);
        }

        @Override
        public int getBindTemporaryStorageCost() {
            return (int)((Double)bindTemporaryStorageCost.get() * 10000.0);
        }

        @Override
        public int getMakeItemCost() {
            return (int)((Double)makeItemCost.get() * 10000.0);
        }

        @Override
        public int getReturnItemCost() {
            return (int)((Double)returnItemCost.get() * 10000.0);
        }

        @Override
        public int getCraftItemCost() {
            return (int)((Double)craftItemCost.get() * 10000.0);
        }

        @Override
        public int getTradeItemCost() {
            return (int)((Double)tradeItemCost.get() * 10000.0);
        }

        @Override
        public int getMaxItemsReturned() {
            return (Integer)maxItemsReturned.get();
        }

        @Override
        public int getMaxRecordsInMediafiedStorage() {
            return (Integer)maxRecordsInMediafiedStorage.get();
        }

        @Override
        public int getConsumeWispOwnCost() {
            return (int)((Double)consumeWispOwnCost.get() * 10000.0);
        }

        @Override
        public double getConsumeWispOthersCostPerMedia() {
            return (Double)consumeWispOthersCostPerMedia.get();
        }

        @Override
        public int getSeonWispSetCost() {
            return (int)((Double)seonWispSetCost.get() * 10000.0);
        }

        @Override
        public int getTickConstantCost() {
            return (int)((Double)tickConstantCost.get() * 10000.0);
        }

        @Override
        public int getTickCostPerTicked() {
            return (int)((Double)tickCostPerTicked.get() * 10000.0);
        }

        @Override
        public int getTickRandomTickIProb() {
            return (Integer)tickRandomTickIProb.get();
        }

        @Override
        public boolean isAccelerateAllowed(@NotNull ResourceLocation blockId) {
            return HexalConfig.noneMatch((List)accelerateDenyList.get(), blockId);
        }
    }

    public static class Client
    implements HexalConfig.ClientConfigAccess {
        public Client(ForgeConfigSpec.Builder builder) {
        }
    }
}

