/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.lib.feature;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import ram.talia.hexal.api.HexalAPI;
import ram.talia.hexal.common.levelgen.feature.SlipwayGeodeConfiguration;
import ram.talia.hexal.common.levelgen.feature.SlipwayGeodeFeature;

public class HexalFeatures {
    private static final Map<ResourceLocation, Feature<?>> FEATURES = new LinkedHashMap();
    public static final Feature<SlipwayGeodeConfiguration> SLIPWAY_GEODE = HexalFeatures.register("slipway_geode", new SlipwayGeodeFeature(SlipwayGeodeConfiguration.CODEC));

    public static void registerFeatures(BiConsumer<Feature<?>, ResourceLocation> r) {
        HexalAPI.LOGGER.info("registering hexal features");
        for (Map.Entry<ResourceLocation, Feature<?>> e : FEATURES.entrySet()) {
            r.accept(e.getValue(), e.getKey());
        }
    }

    private static <T extends FeatureConfiguration> Feature<T> register(String id, Feature<T> feature) {
        Feature<T> old = FEATURES.put(HexalAPI.modLoc(id), feature);
        if (old != null) {
            throw new IllegalArgumentException("Typo? Duplicate id " + id);
        }
        return feature;
    }
}

