/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.entities;

import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.FunUtilsKt;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.common.entities.IMediaEntity;
import ram.talia.hexal.common.entities.LinkableEntity;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0006\b&\u0018\u0000 52\u00020\u00012\b\u0012\u0004\u0012\u00020\u00000\u0002:\u00015B\u001d\u0012\u000e\u0010\u0003\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00000\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0010\u0010\u001c\u001a\n \u001e*\u0004\u0018\u00010\u001d0\u001dH\u0016J\b\u0010\u001f\u001a\u00020\u0019H\u0014J\b\u0010 \u001a\u00020\u0000H\u0016J\u0018\u0010!\u001a\u00020\"2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&H\u0014J\b\u0010'\u001a\u00020(H\u0014J\u000e\u0010)\u001a\u00020\u00132\u0006\u0010*\u001a\u00020\u0013J\u0006\u0010+\u001a\u00020\u0019J\u0010\u0010+\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010,\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0014J\u0010\u0010-\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0014J\u0006\u0010.\u001a\u00020\u0013J\u0018\u0010.\u001a\u00020\u00132\u0006\u0010/\u001a\u0002002\u0006\u00101\u001a\u00020\tH\u0016J\u000e\u00102\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u00103\u001a\u00020\u00192\u0006\u00104\u001a\u00020\u0013R\u0014\u0010\b\u001a\u00020\tX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\nR$\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f8V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\u000f\"\u0004\b\u0010\u0010\u0011R\u001a\u0010\u0012\u001a\u00020\u0013X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u00066"}, d2={"Lram/talia/hexal/common/entities/BaseWisp;", "Lram/talia/hexal/common/entities/LinkableEntity;", "Lram/talia/hexal/common/entities/IMediaEntity;", "entityType", "Lnet/minecraft/world/entity/EntityType;", "world", "Lnet/minecraft/world/level/Level;", "(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/Level;)V", "isConsumable", "", "()Z", "value", "", "media", "getMedia", "()I", "setMedia", "(I)V", "oldPos", "Lnet/minecraft/world/phys/Vec3;", "getOldPos", "()Lnet/minecraft/world/phys/Vec3;", "setOldPos", "(Lnet/minecraft/world/phys/Vec3;)V", "addAdditionalSaveData", "", "compound", "Lnet/minecraft/nbt/CompoundTag;", "colouriser", "Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "kotlin.jvm.PlatformType", "defineSynchedData", "get", "getEyeHeight", "", "pose", "Lnet/minecraft/world/entity/Pose;", "dim", "Lnet/minecraft/world/entity/EntityDimensions;", "makeBoundingBox", "Lnet/minecraft/world/phys/AABB;", "maxMove", "step", "playTrailParticles", "playWispParticles", "readAdditionalSaveData", "renderCentre", "other", "Lram/talia/hexal/api/linkable/ILinkable$IRenderCentre;", "recursioning", "setColouriser", "setLookVector", "vel", "Companion", "hexal-forge-1.19.2"})
public abstract class BaseWisp
extends LinkableEntity
implements IMediaEntity<BaseWisp> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private Vec3 oldPos;
    private final boolean isConsumable;
    @NotNull
    private static final EntityDataAccessor<CompoundTag> COLOURISER;
    @NotNull
    private static final EntityDataAccessor<Integer> MEDIA;
    @NotNull
    public static final String TAG_COLOURISER = "colouriser";
    @NotNull
    public static final String TAG_MEDIA = "media";

    public BaseWisp(@NotNull EntityType<? extends BaseWisp> entityType, @NotNull Level world) {
        Intrinsics.checkNotNullParameter(entityType, (String)"entityType");
        Intrinsics.checkNotNullParameter((Object)world, (String)"world");
        super(entityType, world);
        Vec3 vec3 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position()");
        this.oldPos = vec3;
        this.isConsumable = true;
    }

    @NotNull
    public final Vec3 getOldPos() {
        return this.oldPos;
    }

    public final void setOldPos(@NotNull Vec3 vec3) {
        Intrinsics.checkNotNullParameter((Object)vec3, (String)"<set-?>");
        this.oldPos = vec3;
    }

    @Override
    public int getMedia() {
        Object object = this.f_19804_.m_135370_(MEDIA);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entityData.get(MEDIA)");
        return ((Number)object).intValue();
    }

    @Override
    public void setMedia(int value) {
        this.f_19804_.m_135381_(MEDIA, (Object)Math.max(value, 0));
    }

    @Override
    public boolean isConsumable() {
        return this.isConsumable;
    }

    @Override
    @NotNull
    public BaseWisp get() {
        return this;
    }

    @Override
    public FrozenColorizer colouriser() {
        return FrozenColorizer.fromNBT((CompoundTag)((CompoundTag)this.f_19804_.m_135370_(COLOURISER)));
    }

    protected float m_6380_(@NotNull Pose pose, @NotNull EntityDimensions dim) {
        Intrinsics.checkNotNullParameter((Object)pose, (String)"pose");
        Intrinsics.checkNotNullParameter((Object)dim, (String)"dim");
        return 0.0f;
    }

    @NotNull
    protected AABB m_142242_() {
        AABB aABB = super.m_142242_().m_82386_(0.0, (double)(-this.m_6972_((Pose)Pose.STANDING).f_20378_) * 0.5, 0.0);
        Intrinsics.checkNotNullExpressionValue((Object)aABB, (String)"super.makeBoundingBox().\u2026TANDING).height*0.5, 0.0)");
        return aABB;
    }

    public final void setLookVector(@NotNull Vec3 vel) {
        Intrinsics.checkNotNullParameter((Object)vel, (String)"vel");
        Vec3 direction = vel.m_82541_();
        double pitch = Math.asin(direction.f_82480_);
        double yaw = Math.asin(Math.max(Math.min(direction.f_82479_ / Math.cos(pitch), 1.0), -1.0));
        this.m_146926_((float)(-pitch * (double)180 / Math.PI));
        this.m_146922_((float)(-yaw * (double)180 / Math.PI));
        this.f_19860_ = this.m_146909_();
        this.f_19859_ = this.m_146908_();
    }

    @NotNull
    public final Vec3 maxMove(@NotNull Vec3 step) {
        Vec3 vec3;
        Intrinsics.checkNotNullParameter((Object)step, (String)"step");
        AABB bBox = this.m_20191_();
        List voxelShapes = this.f_19853_.m_183134_((Entity)this, bBox.m_82369_(this.m_20184_()));
        if (step.m_82556_() == 0.0) {
            vec3 = step;
        } else {
            Vec3 vec32 = Entity.m_198894_((Entity)this, (Vec3)step, (AABB)bBox, (Level)this.f_19853_, (List)voxelShapes);
            vec3 = vec32;
            Intrinsics.checkNotNullExpressionValue((Object)vec32, (String)"collideBoundingBox(this,\u2026bBox, level, voxelShapes)");
        }
        return vec3;
    }

    @NotNull
    public final Vec3 renderCentre() {
        Vec3 vec3 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position()");
        return vec3;
    }

    @Override
    @NotNull
    public Vec3 renderCentre(@NotNull ILinkable.IRenderCentre other, boolean recursioning) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.renderCentre();
    }

    public final void playTrailParticles() {
        FrozenColorizer frozenColorizer = this.colouriser();
        Intrinsics.checkNotNullExpressionValue((Object)frozenColorizer, (String)"colouriser()");
        this.playTrailParticles(frozenColorizer);
    }

    protected void playWispParticles(@NotNull FrozenColorizer colouriser) {
        Intrinsics.checkNotNullParameter((Object)colouriser, (String)TAG_COLOURISER);
        double radius = Math.pow((double)this.getMedia() / (double)10000, 0.3333333333333333) / (double)100;
        for (int i = 0; i < 51; ++i) {
            RandomSource randomSource = this.f_19796_;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
            int colour = FunUtilsKt.nextColour(colouriser, randomSource);
            this.f_19853_.m_7106_((ParticleOptions)new ConjureParticleOptions(colour, true), this.renderCentre().f_82479_ + radius * this.f_19796_.m_188583_(), this.renderCentre().f_82480_ + radius * this.f_19796_.m_188583_(), this.renderCentre().f_82481_ + radius * this.f_19796_.m_188583_(), 0.0125 * (this.f_19796_.m_188500_() - 0.5), 0.0125 * (this.f_19796_.m_188500_() - 0.5), 0.0125 * (this.f_19796_.m_188500_() - 0.5));
        }
    }

    protected void playTrailParticles(@NotNull FrozenColorizer colouriser) {
        Intrinsics.checkNotNullParameter((Object)colouriser, (String)TAG_COLOURISER);
        double radius = Math.ceil(Math.pow((double)this.getMedia() / (double)10000, 0.3333333333333333) / (double)10);
        Vec3 vec3 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position()");
        Vec3 delta = OperatorUtilsKt.minus(this.oldPos, vec3);
        double dist = delta.m_82553_() * (double)12 * radius * radius * radius;
        int i = 0;
        int n = (int)dist;
        if (i <= n) {
            while (true) {
                RandomSource randomSource = this.f_19796_;
                Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
                int colour = FunUtilsKt.nextColour(colouriser, randomSource);
                double coeff = (double)i / dist;
                this.f_19853_.m_7106_((ParticleOptions)new ConjureParticleOptions(colour, false), this.renderCentre().f_82479_ + delta.f_82479_ * coeff, this.renderCentre().f_82480_ + delta.f_82480_ * coeff, this.renderCentre().f_82481_ + delta.f_82481_ * coeff, 0.0125 * (this.f_19796_.m_188500_() - 0.5), 0.0125 * (this.f_19796_.m_188500_() - 0.5), 0.0125 * (this.f_19796_.m_188500_() - 0.5));
                if (i == n) break;
                ++i;
            }
        }
    }

    public final void setColouriser(@NotNull FrozenColorizer colouriser) {
        Intrinsics.checkNotNullParameter((Object)colouriser, (String)TAG_COLOURISER);
        this.f_19804_.m_135381_(COLOURISER, (Object)colouriser.serializeToNBT());
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.m_7378_(compound);
        this.f_19804_.m_135381_(COLOURISER, (Object)compound.m_128469_(TAG_COLOURISER));
        this.setMedia(compound.m_128451_(TAG_MEDIA));
        Vec3 vec3 = this.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"position()");
        this.oldPos = vec3;
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag compound) {
        Intrinsics.checkNotNullParameter((Object)compound, (String)"compound");
        super.m_7380_(compound);
        Object object = this.f_19804_.m_135370_(COLOURISER);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"entityData.get(COLOURISER)");
        NBTHelper.putCompound((CompoundTag)compound, (String)TAG_COLOURISER, (CompoundTag)((CompoundTag)object));
        compound.m_128405_(TAG_MEDIA, this.getMedia());
    }

    protected void m_8097_() {
        this.f_19804_.m_135372_(COLOURISER, (Object)((FrozenColorizer)FrozenColorizer.DEFAULT.get()).serializeToNBT());
        this.f_19804_.m_135372_(MEDIA, (Object)200000);
    }

    @Override
    public void addMedia(int dMedia) {
        IMediaEntity.DefaultImpls.addMedia(this, dMedia);
    }

    @NotNull
    public static final EntityDataAccessor<CompoundTag> getCOLOURISER() {
        return Companion.getCOLOURISER();
    }

    @NotNull
    public static final EntityDataAccessor<Integer> getMEDIA() {
        return Companion.getMEDIA();
    }

    static {
        EntityDataAccessor entityDataAccessor = SynchedEntityData.m_135353_(BaseWisp.class, (EntityDataSerializer)EntityDataSerializers.f_135042_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor, (String)"defineId(BaseWisp::class\u2026Serializers.COMPOUND_TAG)");
        COLOURISER = entityDataAccessor;
        EntityDataAccessor entityDataAccessor2 = SynchedEntityData.m_135353_(BaseWisp.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
        Intrinsics.checkNotNullExpressionValue((Object)entityDataAccessor2, (String)"defineId(BaseWisp::class\u2026ntityDataSerializers.INT)");
        MEDIA = entityDataAccessor2;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\"\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u0006\u0010\u0002\u001a\u0004\b\u0007\u0010\bR\"\u0010\t\u001a\b\u0012\u0004\u0012\u00020\n0\u00048\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\bR\u000e\u0010\r\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u000eX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lram/talia/hexal/common/entities/BaseWisp$Companion;", "", "()V", "COLOURISER", "Lnet/minecraft/network/syncher/EntityDataAccessor;", "Lnet/minecraft/nbt/CompoundTag;", "getCOLOURISER$annotations", "getCOLOURISER", "()Lnet/minecraft/network/syncher/EntityDataAccessor;", "MEDIA", "", "getMEDIA$annotations", "getMEDIA", "TAG_COLOURISER", "", "TAG_MEDIA", "hexal-forge-1.19.2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntityDataAccessor<CompoundTag> getCOLOURISER() {
            return COLOURISER;
        }

        @JvmStatic
        public static /* synthetic */ void getCOLOURISER$annotations() {
        }

        @NotNull
        public final EntityDataAccessor<Integer> getMEDIA() {
            return MEDIA;
        }

        @JvmStatic
        public static /* synthetic */ void getMEDIA$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

