/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.blocks.entity;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.common.items.colorizer.ItemDyeColorizer;
import at.petrak.hexcasting.common.lib.HexItems;
import at.petrak.hexcasting.common.particles.ConjureParticleOptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.FunUtilsKt;
import ram.talia.hexal.common.entities.WanderingWisp;
import ram.talia.hexal.common.lib.HexalBlockEntities;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u001a2\u00020\u0001:\u0001\u001aB\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0010\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0014\u001a\u00020\u0015H\u0014J\u0018\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u0003H\u0002J\u0016\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lram/talia/hexal/common/blocks/entity/BlockEntitySlipway;", "Lat/petrak/hexcasting/api/block/HexBlockEntity;", "pos", "Lnet/minecraft/core/BlockPos;", "state", "Lnet/minecraft/world/level/block/state/BlockState;", "(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V", "isActive", "", "nextSpawnTick", "", "random", "Lnet/minecraft/util/RandomSource;", "kotlin.jvm.PlatformType", "clientTick", "", "level", "Lnet/minecraft/world/level/Level;", "blockPos", "loadModData", "tag", "Lnet/minecraft/nbt/CompoundTag;", "saveModData", "serverTick", "Lnet/minecraft/server/level/ServerLevel;", "tick", "Companion", "hexal-forge-1.19.2"})
public final class BlockEntitySlipway
extends HexBlockEntity {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final RandomSource random;
    private boolean isActive;
    private long nextSpawnTick;
    @NotNull
    public static final String TAG_IS_ACTIVE = "is_active";
    @NotNull
    public static final String TAG_NEXT_SPAWN_TICK = "last_spawned_tick";
    public static final double ACTIVE_RANGE = 5.0;
    public static final int SPAWN_INTERVAL_MU = 80;
    public static final int SPAWN_INTERVAL_SIG = 10;
    public static final double RENDER_RADIUS = 0.5;
    @NotNull
    private static final Random RANDOM = new Random();
    @NotNull
    private static final Integer[] colours = ram.talia.hexal.common.blocks.entity.BlockEntitySlipway$Companion.access$makeColours(Companion);

    public BlockEntitySlipway(@NotNull BlockPos pos2, @NotNull BlockState state) {
        Intrinsics.checkNotNullParameter((Object)pos2, (String)"pos");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        super(HexalBlockEntities.SLIPWAY, pos2, state);
        this.random = RandomSource.m_216327_();
    }

    public final void tick(@NotNull Level level, @NotNull BlockPos blockPos) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        Intrinsics.checkNotNullParameter((Object)blockPos, (String)"blockPos");
        if (level.f_46443_) {
            this.clientTick(level, blockPos);
        } else {
            this.serverTick((ServerLevel)level, blockPos);
        }
    }

    private final void clientTick(Level level, BlockPos blockPos) {
        Vec3 vec = Vec3.m_82512_((Vec3i)((Vec3i)blockPos));
        for (ItemDyeColorizer colouriser : HexItems.DYE_COLORIZERS.values()) {
            int colour = colours[this.random.m_188503_(colours.length)];
            level.m_7106_((ParticleOptions)new ConjureParticleOptions(colour, true), vec.f_82479_ + 0.5 * this.random.m_188583_(), vec.f_82480_ + 0.5 * this.random.m_188583_(), vec.f_82481_ + 0.5 * this.random.m_188583_(), 0.0125 * (this.random.m_188500_() - 0.5), 0.0125 * (this.random.m_188500_() - 0.5), 0.0125 * (this.random.m_188500_() - 0.5));
        }
    }

    private final void serverTick(ServerLevel level, BlockPos blockPos) {
        if (!this.isActive) {
            if (level.m_45914_((double)blockPos.m_123341_(), (double)blockPos.m_123342_(), (double)blockPos.m_123343_(), 5.0)) {
                this.isActive = true;
                this.sync();
            }
            return;
        }
        long tick = level.m_46467_();
        AABB aabb = AABB.m_165882_((Vec3)Vec3.m_82512_((Vec3i)((Vec3i)blockPos)), (double)64.0, (double)64.0, (double)64.0);
        if (tick >= this.nextSpawnTick && level.m_45976_(WanderingWisp.class, aabb).size() < 20) {
            RandomSource randomSource = this.random;
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"random");
            this.nextSpawnTick = tick + (long)FunUtilsKt.nextGaussian(randomSource, 80.0, 10.0);
            FrozenColorizer colouriser = Companion.getRandomColouriser();
            Level level2 = (Level)level;
            Vec3 vec3 = Vec3.m_82512_((Vec3i)((Vec3i)blockPos));
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"atCenterOf(blockPos)");
            WanderingWisp wisp = new WanderingWisp(level2, vec3);
            wisp.setColouriser(colouriser);
            level.m_7967_((Entity)wisp);
            this.sync();
        }
    }

    protected void saveModData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128379_(TAG_IS_ACTIVE, this.isActive);
        tag.m_128356_(TAG_NEXT_SPAWN_TICK, this.nextSpawnTick);
    }

    protected void loadModData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        this.isActive = tag.m_128471_(TAG_IS_ACTIVE);
        this.nextSpawnTick = tag.m_128454_(TAG_NEXT_SPAWN_TICK);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0006\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\t0\u000fH\u0002\u00a2\u0006\u0002\u0010\u0014R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0086T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\t0\u000fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0010\u00a8\u0006\u0015"}, d2={"Lram/talia/hexal/common/blocks/entity/BlockEntitySlipway$Companion;", "", "()V", "ACTIVE_RANGE", "", "RANDOM", "Ljava/util/Random;", "RENDER_RADIUS", "SPAWN_INTERVAL_MU", "", "SPAWN_INTERVAL_SIG", "TAG_IS_ACTIVE", "", "TAG_NEXT_SPAWN_TICK", "colours", "", "[Ljava/lang/Integer;", "getRandomColouriser", "Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "makeColours", "()[Ljava/lang/Integer;", "hexal-forge-1.19.2"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FrozenColorizer getRandomColouriser() {
            Collection collection = HexItems.DYE_COLORIZERS.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"DYE_COLORIZERS.values");
            return new FrozenColorizer(new ItemStack((ItemLike)CollectionsKt.elementAt((Iterable)collection, (int)RANDOM.nextInt(HexItems.DYE_COLORIZERS.size()))), Util.f_137441_);
        }

        private final Integer[] makeColours() {
            RandomSource random = RandomSource.m_216327_();
            List coloursList = new ArrayList();
            for (int i = 0; i < 33; ++i) {
                for (ItemDyeColorizer colouriser : HexItems.DYE_COLORIZERS.values()) {
                    FrozenColorizer frozenColouriser = new FrozenColorizer(new ItemStack((ItemLike)colouriser), Util.f_137441_);
                    Intrinsics.checkNotNullExpressionValue((Object)random, (String)"random");
                    coloursList.add(FunUtilsKt.nextColour(frozenColouriser, random));
                }
            }
            Collection $this$toTypedArray$iv = coloursList;
            boolean $i$f$toTypedArray = false;
            Collection thisCollection$iv = $this$toTypedArray$iv;
            Integer[] integerArray = thisCollection$iv.toArray(new Integer[0]);
            Intrinsics.checkNotNull((Object)integerArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
            return integerArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ Integer[] access$makeColours(Companion $this) {
            return $this.makeColours();
        }
    }
}

