/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.spell.iota;

import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.IotaType;
import at.petrak.hexcasting.api.spell.iota.NullIota;
import at.petrak.hexcasting.api.utils.HexUtils;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagType;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.mediafieditems.ItemRecord;
import ram.talia.hexal.api.mediafieditems.MediafiedItemManager;
import ram.talia.hexal.common.lib.HexalIotaTypes;

public class ItemIota
extends Iota {
    static final String TAG_DISPLAY_NAME = "name";
    static final String TAG_COUNT = "count";
    public static IotaType<ItemIota> TYPE = new IotaType<ItemIota>(){

        public ItemIota deserialize(Tag tag, ServerLevel world) throws IllegalArgumentException {
            CompoundTag ctag = (CompoundTag)HexUtils.downcast((Tag)tag, (TagType)CompoundTag.f_128326_);
            MediafiedItemManager.Index index = MediafiedItemManager.Index.readFromNbt(ctag);
            if (!MediafiedItemManager.contains(index)) {
                return null;
            }
            return new ItemIota(index);
        }

        public Component display(Tag tag) {
            if (!(tag instanceof CompoundTag)) {
                return Component.m_237115_((String)"hexcasting.spelldata.unknown");
            }
            CompoundTag ctag = (CompoundTag)tag;
            if (!ctag.m_128441_(ItemIota.TAG_DISPLAY_NAME) || !ctag.m_128441_(ItemIota.TAG_COUNT)) {
                return Component.m_237115_((String)"hexcasting.tooltip.null_iota").m_130940_(ChatFormatting.GRAY);
            }
            return Component.m_237110_((String)"hexal.spelldata.item", (Object[])new Object[]{ctag.m_128461_(ItemIota.TAG_DISPLAY_NAME), ctag.m_128454_(ItemIota.TAG_COUNT)}).m_130940_(ChatFormatting.YELLOW);
        }

        public int color() {
            return -171;
        }
    };

    public ItemIota(MediafiedItemManager.Index payload) {
        super(HexalIotaTypes.ITEM, (Object)payload);
    }

    @Nullable
    public static ItemIota makeIfStorageLoaded(ItemStack stack, UUID storageUUID) {
        MediafiedItemManager.Index index = MediafiedItemManager.assignItem(stack, storageUUID);
        if (index != null) {
            return new ItemIota(index);
        }
        return null;
    }

    @Nullable
    public static ItemIota makeIfStorageLoaded(ItemRecord record, UUID storageUUID) {
        MediafiedItemManager.Index index = MediafiedItemManager.assignItem(record, storageUUID);
        if (index != null) {
            return new ItemIota(index);
        }
        return null;
    }

    @Nullable
    public ItemIota selfOrNull() {
        if (MediafiedItemManager.contains(this.getItemIndex())) {
            return this;
        }
        return null;
    }

    public boolean isEmpty() {
        return MediafiedItemManager.isEmpty(this.getItemIndex());
    }

    public MediafiedItemManager.Index getItemIndex() {
        return (MediafiedItemManager.Index)this.payload;
    }

    @Nullable
    public ItemRecord getRecord() {
        WeakReference<ItemRecord> record = MediafiedItemManager.getRecord(this.getItemIndex());
        if (record == null) {
            return null;
        }
        return (ItemRecord)record.get();
    }

    public Item getItem() {
        return Objects.requireNonNull(MediafiedItemManager.getItem(this.getItemIndex()), "MediafiedItemManager returned null for Item that has existing ItemIota.");
    }

    public CompoundTag getTag() {
        return Objects.requireNonNull(MediafiedItemManager.getTag(this.getItemIndex()), "MediafiedItemManager returned null for Item that has existing ItemIota.");
    }

    public long getCount() {
        return Objects.requireNonNull(MediafiedItemManager.getCount(this.getItemIndex()), "MediafiedItemManager returned null for Item that has existing ItemIota.");
    }

    public void absorb(ItemIota other) {
        MediafiedItemManager.merge(this.getItemIndex(), other.getItemIndex());
    }

    public boolean typeMatches(ItemIota other) {
        return MediafiedItemManager.typeMatches(this.getItemIndex(), other.getItemIndex());
    }

    @Nullable
    public ItemIota splitOff(int amount, @Nullable UUID storage) {
        MediafiedItemManager.Index newIndex = MediafiedItemManager.splitOff(this.getItemIndex(), amount, storage);
        if (newIndex == null) {
            return null;
        }
        return new ItemIota(newIndex);
    }

    public List<ItemStack> getStacksToDrop(int count) {
        return MediafiedItemManager.getStacksToDrop(this.getItemIndex(), count);
    }

    public long removeItems(int count) {
        return this.removeItems((long)count);
    }

    public long removeItems(long count) {
        return MediafiedItemManager.removeItems(this.getItemIndex(), count);
    }

    public void templateOff(@NotNull ItemStack template) {
        MediafiedItemManager.templateOff(this.getItemIndex(), template, null);
    }

    public void templateOff(@NotNull ItemStack template, long newCount) {
        MediafiedItemManager.templateOff(this.getItemIndex(), template, newCount);
    }

    public ItemIota copy() {
        return new ItemIota(this.getItemIndex());
    }

    @Nullable
    public ItemIota setStorage(@NotNull UUID uuid) {
        Boolean storageFull = MediafiedItemManager.isStorageFull(uuid);
        if (storageFull == null || storageFull.booleanValue()) {
            return null;
        }
        ItemRecord record = this.getRecord();
        MediafiedItemManager.removeRecord(this.getItemIndex());
        if (record == null) {
            return null;
        }
        MediafiedItemManager.Index newIndex = MediafiedItemManager.assignItem(record, uuid);
        return new ItemIota(newIndex);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean toleratesOther(Iota that) {
        if (ItemIota.typesMatch((Iota)this, (Iota)that) && that instanceof ItemIota) {
            ItemIota ithat = (ItemIota)that;
            if (this.getItemIndex().equals(ithat.getItemIndex())) return true;
        }
        if (!this.isEmpty()) return false;
        if (that instanceof NullIota) return true;
        if (!(that instanceof ItemIota)) return false;
        ItemIota ithat2 = (ItemIota)that;
        if (!ithat2.isEmpty()) return false;
        return true;
    }

    public boolean isTruthy() {
        return !this.isEmpty();
    }

    @NotNull
    public Tag serialize() {
        ItemRecord rec;
        CompoundTag tag = new CompoundTag();
        this.getItemIndex().writeToNbt(tag);
        WeakReference<ItemRecord> record = MediafiedItemManager.getRecord(this.getItemIndex());
        if (record == null || (rec = (ItemRecord)record.get()) == null) {
            return tag;
        }
        tag.m_128359_(TAG_DISPLAY_NAME, rec.getDisplayName().getString());
        tag.m_128356_(TAG_COUNT, rec.getCount());
        return tag;
    }
}

