/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.nbt;

import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.api.spell.iota.NullIota;
import at.petrak.hexcasting.api.utils.NBTHelper;
import at.petrak.hexcasting.common.lib.hex.HexIotaTypes;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.nbt.SerialisedIotaList;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0011\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0002\u0010\u0004B\u0011\b\u0016\u0012\b\u0010\u0005\u001a\u0004\u0018\u00010\u0006\u00a2\u0006\u0002\u0010\u0007B\u0007\b\u0016\u00a2\u0006\u0002\u0010\bB\u000f\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u000eJ\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u00102\u0006\u0010\r\u001a\u00020\u000eJ\u0006\u0010\u0012\u001a\u00020\u0006J\u000e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0002\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00142\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lram/talia/hexal/api/nbt/SerialisedIota;", "", "iota", "Lat/petrak/hexcasting/api/spell/iota/Iota;", "(Lat/petrak/hexcasting/api/spell/iota/Iota;)V", "tag", "Lnet/minecraft/nbt/CompoundTag;", "(Lnet/minecraft/nbt/CompoundTag;)V", "()V", "iotaList", "Lram/talia/hexal/api/nbt/SerialisedIotaList;", "(Lram/talia/hexal/api/nbt/SerialisedIotaList;)V", "getIota", "level", "Lnet/minecraft/server/level/ServerLevel;", "getReferencedEntities", "", "Lnet/minecraft/world/entity/Entity;", "getTag", "refreshIota", "", "set", "hexal-forge-1.19.2"})
public final class SerialisedIota {
    @NotNull
    private final SerialisedIotaList iotaList;

    public SerialisedIota(@NotNull SerialisedIotaList iotaList) {
        Intrinsics.checkNotNullParameter((Object)iotaList, (String)"iotaList");
        this.iotaList = iotaList;
    }

    public /* synthetic */ SerialisedIota(SerialisedIotaList serialisedIotaList, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            serialisedIotaList = new SerialisedIotaList(null, null);
        }
        this(serialisedIotaList);
    }

    public SerialisedIota(@Nullable Iota iota) {
        List list;
        if (iota == null) {
            list = null;
        } else {
            Object[] objectArray = new Iota[]{iota};
            list = CollectionsKt.mutableListOf((Object[])objectArray);
        }
        this(new SerialisedIotaList(list));
    }

    public SerialisedIota(@Nullable CompoundTag tag) {
        this(new SerialisedIotaList());
        if (tag != null) {
            this.iotaList.add(tag);
        }
    }

    public SerialisedIota() {
        this(new SerialisedIotaList());
    }

    @NotNull
    public final CompoundTag getTag() {
        CompoundTag compoundTag;
        ListTag listTag = this.iotaList.getTag();
        if (listTag.size() == 0) {
            CompoundTag compoundTag2 = HexIotaTypes.serialize((Iota)((Iota)new NullIota()));
            compoundTag = compoundTag2;
            Intrinsics.checkNotNullExpressionValue((Object)compoundTag2, (String)"{\n            HexIotaTyp\u2026ize(NullIota())\n        }");
        } else {
            Tag tag = listTag.get(0);
            Intrinsics.checkNotNullExpressionValue((Object)tag, (String)"listTag[0]");
            compoundTag = NBTHelper.getAsCompound((Tag)tag);
        }
        return compoundTag;
    }

    @NotNull
    public final Iota getIota(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        List<Iota> iotas = this.iotaList.getIotas(level);
        return iotas.isEmpty() ? (Iota)new NullIota() : iotas.get(0);
    }

    public final void set(@NotNull Iota iota) {
        Intrinsics.checkNotNullParameter((Object)iota, (String)"iota");
        Object[] objectArray = new Iota[]{iota};
        this.iotaList.set(CollectionsKt.mutableListOf((Object[])objectArray));
    }

    public final void set(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        ListTag listTag = new ListTag();
        listTag.add((Object)tag);
        this.iotaList.set(listTag);
    }

    @NotNull
    public final List<Entity> getReferencedEntities(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        return this.iotaList.getReferencedEntities(level);
    }

    public final void refreshIota(@NotNull ServerLevel level) {
        Intrinsics.checkNotNullParameter((Object)level, (String)"level");
        this.iotaList.refreshIotas(level);
    }
}

