/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.linkable;

import at.petrak.hexcasting.api.misc.FrozenColorizer;
import at.petrak.hexcasting.api.spell.iota.EntityIota;
import at.petrak.hexcasting.api.spell.iota.Iota;
import at.petrak.hexcasting.xplat.IXplatAbstractions;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.IntArrayTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import ram.talia.hexal.api.OperatorUtilsKt;
import ram.talia.hexal.api.linkable.ClientLinkableHolder;
import ram.talia.hexal.api.linkable.ILinkable;
import ram.talia.hexal.api.linkable.LinkableRegistry;
import ram.talia.hexal.api.linkable.LinkableTypes;
import ram.talia.hexal.api.linkable.ServerLinkableHolder;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 22\u00020\u0001:\u000223B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001a\u001a\u00020\u00012\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J\u0012\u0010\u001f\u001a\f\u0012\u0004\u0012\u00020\u0000\u0012\u0002\b\u00030 H\u0016J\b\u0010!\u001a\u00020\"H\u0016J\u000e\u0010#\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%J\b\u0010&\u001a\u00020'H\u0016J\u0006\u0010(\u001a\u00020\u0019J\u000e\u0010)\u001a\u00020\u00192\u0006\u0010$\u001a\u00020%J\u000e\u0010\u0016\u001a\u00020\u00192\u0006\u0010*\u001a\u00020\u001cJ\b\u0010+\u001a\u00020,H\u0016J\b\u0010-\u001a\u00020.H\u0016J\b\u0010/\u001a\u000200H\u0016J\b\u00101\u001a\u000200H\u0016R\u001a\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\f\u001a\u00020\rX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R(\u0010\u0013\u001a\u0004\u0018\u00010\u00012\b\u0010\u0012\u001a\u0004\u0018\u00010\u00018F@BX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017\u00a8\u00064"}, d2={"Lram/talia/hexal/api/linkable/PlayerLinkstore;", "Lram/talia/hexal/api/linkable/ILinkable;", "player", "Lnet/minecraft/server/level/ServerPlayer;", "(Lnet/minecraft/server/level/ServerPlayer;)V", "asActionResult", "", "Lat/petrak/hexcasting/api/spell/iota/EntityIota;", "getAsActionResult", "()Ljava/util/List;", "lazyTransmittingTo", "Lram/talia/hexal/api/linkable/ILinkable$LazyILinkable;", "linkableHolder", "Lram/talia/hexal/api/linkable/ServerLinkableHolder;", "getLinkableHolder", "()Lram/talia/hexal/api/linkable/ServerLinkableHolder;", "getPlayer", "()Lnet/minecraft/server/level/ServerPlayer;", "value", "transmittingTo", "getTransmittingTo", "()Lram/talia/hexal/api/linkable/ILinkable;", "setTransmittingTo", "(Lram/talia/hexal/api/linkable/ILinkable;)V", "acceptMedia", "", "other", "sentMedia", "", "canAcceptMedia", "otherMediaLevel", "getLinkableType", "Lram/talia/hexal/api/linkable/LinkableRegistry$LinkableType;", "getPosition", "Lnet/minecraft/world/phys/Vec3;", "loadAdditionalData", "tag", "Lnet/minecraft/nbt/CompoundTag;", "maxSqrLinkRange", "", "resetTransmittingTo", "saveAdditionalData", "to", "shouldRemove", "", "toString", "", "writeToNbt", "Lnet/minecraft/nbt/Tag;", "writeToSync", "Companion", "RenderCentre", "hexal-forge-1.19.2"})
public final class PlayerLinkstore
implements ILinkable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ServerPlayer player;
    @NotNull
    private final List<EntityIota> asActionResult;
    @NotNull
    private final ServerLinkableHolder linkableHolder;
    @NotNull
    private final ILinkable.LazyILinkable lazyTransmittingTo;
    @NotNull
    public static final String TAG_LINKABLE_HOLDER = "hexal:linkable_holder";
    @NotNull
    public static final String TAG_TRANSMITTING_TO = "hexal:transmitting_to";

    public PlayerLinkstore(@NotNull ServerPlayer player) {
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        this.player = player;
        this.asActionResult = CollectionsKt.listOf((Object)new EntityIota((Entity)this.player));
        ILinkable iLinkable = this;
        ServerLevel serverLevel = this.player.m_9236_();
        Intrinsics.checkNotNullExpressionValue((Object)serverLevel, (String)"player.getLevel()");
        this.linkableHolder = new ServerLinkableHolder(iLinkable, serverLevel);
        Level level = this.player.f_19853_;
        Intrinsics.checkNotNull((Object)level, (String)"null cannot be cast to non-null type net.minecraft.server.level.ServerLevel");
        this.lazyTransmittingTo = new ILinkable.LazyILinkable((ServerLevel)level);
    }

    @NotNull
    public final ServerPlayer getPlayer() {
        return this.player;
    }

    @NotNull
    public List<EntityIota> getAsActionResult() {
        return this.asActionResult;
    }

    @Override
    @NotNull
    public ServerLinkableHolder getLinkableHolder() {
        return this.linkableHolder;
    }

    @Nullable
    public final ILinkable getTransmittingTo() {
        ILinkable iLinkable = (ILinkable)this.lazyTransmittingTo.get();
        if (iLinkable == null) {
            return null;
        }
        ILinkable it = iLinkable;
        if (this.isInRange(it)) {
            return it;
        }
        this.resetTransmittingTo();
        return null;
    }

    private final void setTransmittingTo(ILinkable value) {
        this.lazyTransmittingTo.set(value);
    }

    public final void setTransmittingTo(int to) {
        if (to >= this.numLinked()) {
            this.resetTransmittingTo();
            return;
        }
        this.setTransmittingTo(this.getLinked(to));
    }

    public final void resetTransmittingTo() {
        this.setTransmittingTo(null);
    }

    @Override
    public double maxSqrLinkRange() {
        return 1024.0;
    }

    @NotNull
    public LinkableRegistry.LinkableType<PlayerLinkstore, ?> getLinkableType() {
        return LinkableTypes.INSTANCE.getPLAYER_LINKSTORE_TYPE();
    }

    @Override
    @NotNull
    public Vec3 getPosition() {
        Vec3 vec3 = this.player.m_20182_();
        Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"player.position()");
        return vec3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean shouldRemove() {
        if (!this.player.m_213877_()) return false;
        Entity.RemovalReason removalReason = this.player.m_146911_();
        if (removalReason == null) return false;
        if (!removalReason.m_146965_()) return false;
        return true;
    }

    @Override
    @NotNull
    public Tag writeToNbt() {
        IntArrayTag intArrayTag = NbtUtils.m_129226_((UUID)this.player.m_20148_());
        Intrinsics.checkNotNullExpressionValue((Object)intArrayTag, (String)"createUUID(player.uuid)");
        return (Tag)intArrayTag;
    }

    @Override
    @NotNull
    public Tag writeToSync() {
        IntTag intTag = IntTag.m_128679_((int)this.player.m_19879_());
        Intrinsics.checkNotNullExpressionValue((Object)intTag, (String)"valueOf(player.id)");
        return (Tag)intTag;
    }

    @Override
    public int canAcceptMedia(@NotNull ILinkable other, int otherMediaLevel) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return 0;
    }

    @Override
    public void acceptMedia(@NotNull ILinkable other, int sentMedia) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
    }

    public final void loadAdditionalData(@NotNull CompoundTag tag) {
        CompoundTag transmittingToTag;
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Tag tag2 = tag.m_128423_(TAG_LINKABLE_HOLDER);
        CompoundTag compoundTag = tag2 instanceof CompoundTag ? (CompoundTag)tag2 : null;
        if (compoundTag != null) {
            CompoundTag it = compoundTag;
            boolean bl = false;
            this.getLinkableHolder().readFromNbt(it);
        }
        tag2 = tag.m_128423_(TAG_TRANSMITTING_TO);
        CompoundTag compoundTag2 = transmittingToTag = tag2 instanceof CompoundTag ? (CompoundTag)tag2 : null;
        if (transmittingToTag == null) {
            this.lazyTransmittingTo.set(null);
        } else {
            this.lazyTransmittingTo.set((Tag)transmittingToTag);
        }
    }

    public final void saveAdditionalData(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128365_(TAG_LINKABLE_HOLDER, (Tag)this.getLinkableHolder().writeToNbt());
        tag.m_128365_(TAG_TRANSMITTING_TO, this.lazyTransmittingTo.getUnloaded());
    }

    @NotNull
    public String toString() {
        return "PlayerLinkstore(player=" + this.player + ")";
    }

    @Override
    public boolean isInRange(@NotNull ILinkable other) {
        return ILinkable.DefaultImpls.isInRange(this, other);
    }

    @Override
    public void link(@NotNull ILinkable other, boolean linkOther) {
        ILinkable.DefaultImpls.link(this, other, linkOther);
    }

    @Override
    public void unlink(@NotNull ILinkable other, boolean unlinkOther) {
        ILinkable.DefaultImpls.unlink(this, other, unlinkOther);
    }

    @Override
    @NotNull
    public ILinkable getLinked(int index) {
        return ILinkable.DefaultImpls.getLinked(this, index);
    }

    @Override
    public int getLinkedIndex(@NotNull ILinkable linked) {
        return ILinkable.DefaultImpls.getLinkedIndex(this, linked);
    }

    @Override
    public int numLinked() {
        return ILinkable.DefaultImpls.numLinked(this);
    }

    @Override
    public void checkLinks() {
        ILinkable.DefaultImpls.checkLinks(this);
    }

    @Override
    public void receiveIota(@NotNull Iota iota) {
        ILinkable.DefaultImpls.receiveIota(this, iota);
    }

    @Override
    @NotNull
    public Iota nextReceivedIota() {
        return ILinkable.DefaultImpls.nextReceivedIota(this);
    }

    @Override
    public int numRemainingIota() {
        return ILinkable.DefaultImpls.numRemainingIota(this);
    }

    @Override
    public void clearReceivedIotas() {
        ILinkable.DefaultImpls.clearReceivedIotas(this);
    }

    @Override
    @NotNull
    public List<Iota> allReceivedIotas() {
        return ILinkable.DefaultImpls.allReceivedIotas(this);
    }

    @Override
    @NotNull
    public List<Component> transmittingTargetReturnDisplay() {
        return ILinkable.DefaultImpls.transmittingTargetReturnDisplay(this);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u000b\u001a\n \r*\u0004\u0018\u00010\f0\fH\u0016J\u0014\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00000\u000fH\u0016J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00012\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\b\u0010\u0016\u001a\u00020\u0015H\u0016R\u0014\u0010\u0005\u001a\u00020\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lram/talia/hexal/api/linkable/PlayerLinkstore$RenderCentre;", "Lram/talia/hexal/api/linkable/ILinkable$IRenderCentre;", "player", "Lnet/minecraft/world/entity/player/Player;", "(Lnet/minecraft/world/entity/player/Player;)V", "clientLinkableHolder", "Lram/talia/hexal/api/linkable/ClientLinkableHolder;", "getClientLinkableHolder", "()Lram/talia/hexal/api/linkable/ClientLinkableHolder;", "getPlayer", "()Lnet/minecraft/world/entity/player/Player;", "colouriser", "Lat/petrak/hexcasting/api/misc/FrozenColorizer;", "kotlin.jvm.PlatformType", "getLinkableType", "Lram/talia/hexal/api/linkable/LinkableRegistry$LinkableType;", "Lram/talia/hexal/api/linkable/PlayerLinkstore;", "renderCentre", "Lnet/minecraft/world/phys/Vec3;", "other", "recursioning", "", "shouldRemove", "hexal-forge-1.19.2"})
    public static final class RenderCentre
    implements ILinkable.IRenderCentre {
        @NotNull
        private final Player player;
        @NotNull
        private final ClientLinkableHolder clientLinkableHolder;

        public RenderCentre(@NotNull Player player) {
            Intrinsics.checkNotNullParameter((Object)player, (String)"player");
            this.player = player;
            ILinkable.IRenderCentre iRenderCentre = this;
            Level level = this.player.f_19853_;
            Intrinsics.checkNotNullExpressionValue((Object)level, (String)"player.level");
            RandomSource randomSource = this.player.m_217043_();
            Intrinsics.checkNotNullExpressionValue((Object)randomSource, (String)"player.random");
            this.clientLinkableHolder = new ClientLinkableHolder(iRenderCentre, level, randomSource);
        }

        @NotNull
        public final Player getPlayer() {
            return this.player;
        }

        @Override
        @NotNull
        public ClientLinkableHolder getClientLinkableHolder() {
            return this.clientLinkableHolder;
        }

        @Override
        @NotNull
        public Vec3 renderCentre(@NotNull ILinkable.IRenderCentre other, boolean recursioning) {
            Intrinsics.checkNotNullParameter((Object)other, (String)"other");
            if (!recursioning) {
                Vec3 vec3 = this.player.m_146892_();
                Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"player.eyePosition");
                return vec3;
            }
            Vec3 vec3 = this.player.m_146892_();
            Intrinsics.checkNotNullExpressionValue((Object)vec3, (String)"player.eyePosition");
            Vec3 vec32 = other.renderCentre(this, false);
            Vec3 vec33 = this.player.m_146892_();
            Intrinsics.checkNotNullExpressionValue((Object)vec33, (String)"player.eyePosition");
            Vec3 vec34 = OperatorUtilsKt.minus(vec32, vec33).m_82541_();
            Intrinsics.checkNotNullExpressionValue((Object)vec34, (String)"other.renderCentre(this,\u2026.eyePosition).normalize()");
            return OperatorUtilsKt.plus(vec3, vec34);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean shouldRemove() {
            if (!this.player.m_213877_()) return false;
            Entity.RemovalReason removalReason = this.player.m_146911_();
            if (removalReason == null) return false;
            if (!removalReason.m_146965_()) return false;
            return true;
        }

        @Override
        public FrozenColorizer colouriser() {
            return IXplatAbstractions.INSTANCE.getColorizer(this.player);
        }

        @NotNull
        public LinkableRegistry.LinkableType<PlayerLinkstore, RenderCentre> getLinkableType() {
            return LinkableTypes.INSTANCE.getPLAYER_LINKSTORE_TYPE();
        }

        @Override
        public void renderLinks() {
            ILinkable.IRenderCentre.DefaultImpls.renderLinks(this);
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lram/talia/hexal/api/linkable/PlayerLinkstore$Companion;", "", "()V", "TAG_LINKABLE_HOLDER", "", "TAG_TRANSMITTING_TO", "hexal-forge-1.19.2"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

