/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.api.gates;

import at.petrak.hexcasting.api.utils.NBTHelper;
import com.mojang.datafixers.util.Either;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.nbt.HexalNBTHelperKt;
import ram.talia.hexal.api.spell.iota.GateIota;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\b\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\bH\u0007J\b\u0010\u0011\u001a\u00020\u0012H\u0007J*\u0010\u0011\u001a\u00020\u00122 \u0010\u0013\u001a\u001c\u0012\u0004\u0012\u00020\u0015\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u0016\u0018\u00010\u0014H\u0002J\u001c\u0010\u0011\u001a\u00020\u00122\u0012\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00150\u0016H\u0007J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0015H\u0007J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\nH\u0007J\u0018\u0010\u0018\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0017H\u0007J\u0010\u0010\u001a\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\nH\u0007J\u0018\u0010\u001d\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0019\u001a\u00020\u0017H\u0007J\u0010\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001b\u001a\u00020\u001cH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\"\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\b\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0012\u0010\f\u001a\u00020\r8\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lram/talia/hexal/api/gates/GateManager;", "", "()V", "TAG_CURRENT_GATE_NUM", "", "TAG_MARKED", "allMarked", "", "", "", "Ljava/util/UUID;", "currentGateNum", "shouldClearOnWrite", "", "clearMarked", "", "gate", "makeGate", "Lram/talia/hexal/api/spell/iota/GateIota;", "target", "Lcom/mojang/datafixers/util/Either;", "Lnet/minecraft/world/phys/Vec3;", "Lkotlin/Pair;", "Lnet/minecraft/world/entity/Entity;", "mark", "entity", "readFromNbt", "tag", "Lnet/minecraft/nbt/CompoundTag;", "unmark", "writeToNbt", "hexal-forge-1.19.2"})
public final class GateManager {
    @NotNull
    public static final GateManager INSTANCE = new GateManager();
    private static int currentGateNum;
    @JvmField
    public static boolean shouldClearOnWrite;
    @JvmField
    @NotNull
    public static final Map<Integer, Set<UUID>> allMarked;
    @NotNull
    public static final String TAG_CURRENT_GATE_NUM = "hexal:current_gate_num";
    @NotNull
    public static final String TAG_MARKED = "hexal:marked";

    private GateManager() {
    }

    @JvmStatic
    public static final void mark(int gate, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        UUID uUID = entity.m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"entity.uuid");
        GateManager.mark(gate, uUID);
    }

    @JvmStatic
    public static final void mark(int gate, @NotNull UUID entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        allMarked.putIfAbsent(gate, new LinkedHashSet());
        Set<UUID> set = allMarked.get(gate);
        Intrinsics.checkNotNull(set);
        set.add(entity);
    }

    @JvmStatic
    public static final void unmark(int gate, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        UUID uUID = entity.m_20148_();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"entity.uuid");
        GateManager.unmark(gate, uUID);
    }

    @JvmStatic
    public static final void unmark(int gate, @NotNull UUID entity) {
        block0: {
            Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
            Set<UUID> set = allMarked.get(gate);
            if (set == null) break block0;
            set.remove(entity);
        }
    }

    @JvmStatic
    public static final void clearMarked(int gate) {
        allMarked.remove(gate);
    }

    @JvmStatic
    @NotNull
    public static final GateIota makeGate() {
        return INSTANCE.makeGate(null);
    }

    @JvmStatic
    @NotNull
    public static final GateIota makeGate(@NotNull Vec3 target) {
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return INSTANCE.makeGate((Either<Vec3, Pair<Entity, Vec3>>)Either.left((Object)target));
    }

    @JvmStatic
    @NotNull
    public static final GateIota makeGate(@NotNull Pair<? extends Entity, ? extends Vec3> target) {
        Intrinsics.checkNotNullParameter(target, (String)"target");
        return INSTANCE.makeGate((Either<Vec3, Pair<Entity, Vec3>>)Either.right(target));
    }

    private final GateIota makeGate(Either<Vec3, Pair<Entity, Vec3>> target) {
        GateIota gate = new GateIota(currentGateNum, target);
        ++currentGateNum;
        return gate;
    }

    @JvmStatic
    public static final void readFromNbt(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (tag.m_128441_(TAG_CURRENT_GATE_NUM)) {
            currentGateNum = tag.m_128451_(TAG_CURRENT_GATE_NUM);
        }
        if (tag.m_128441_(TAG_MARKED)) {
            CompoundTag markedTag = tag.m_128469_(TAG_MARKED);
            for (String gateStr : markedTag.m_128431_()) {
                Intrinsics.checkNotNullExpressionValue((Object)gateStr, (String)"gateStr");
                Integer n = Integer.parseInt(gateStr);
                Intrinsics.checkNotNullExpressionValue((Object)markedTag, (String)"markedTag");
                allMarked.put(n, CollectionsKt.toMutableSet((Iterable)HexalNBTHelperKt.toUUIDList(NBTHelper.getListByByte((CompoundTag)markedTag, (String)gateStr, (byte)11))));
            }
        }
    }

    @JvmStatic
    public static final void writeToNbt(@NotNull CompoundTag tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        tag.m_128405_(TAG_CURRENT_GATE_NUM, currentGateNum);
        CompoundTag markedTag = new CompoundTag();
        for (Map.Entry<Integer, Set<UUID>> entry : allMarked.entrySet()) {
            int gate = ((Number)entry.getKey()).intValue();
            Set<UUID> marked = entry.getValue();
            NBTHelper.putList((CompoundTag)markedTag, (String)String.valueOf(gate), (ListTag)HexalNBTHelperKt.toNbtListUUID(CollectionsKt.toList((Iterable)marked)));
        }
        NBTHelper.putCompound((CompoundTag)tag, (String)TAG_MARKED, (CompoundTag)markedTag);
        if (shouldClearOnWrite) {
            currentGateNum = 0;
            allMarked.clear();
        }
    }

    static {
        allMarked = new LinkedHashMap();
    }
}

